/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.function.Function;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;

public class DelegateFileSystemAbstraction
implements FileSystemAbstraction {
    private final FileSystem fs;
    private final Map<Class<?>, Object> thirdPartyFs = new HashMap();

    public DelegateFileSystemAbstraction(FileSystem fs) {
        this.fs = fs;
    }

    @Override
    public StoreChannel open(File fileName, String mode) throws IOException {
        return new StoreFileChannel(FileUtils.open(this.path(fileName), mode));
    }

    private Path path(File fileName) {
        return this.path(fileName.getPath());
    }

    private Path path(String fileName) {
        return this.fs.getPath(fileName, new String[0]);
    }

    @Override
    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return FileUtils.openAsOutputStream(this.path(fileName), append);
    }

    @Override
    public InputStream openAsInputStream(File fileName) throws IOException {
        return FileUtils.openAsInputStream(this.path(fileName));
    }

    @Override
    public Reader openAsReader(File fileName, String encoding) throws IOException {
        return new InputStreamReader(this.openAsInputStream(fileName), encoding);
    }

    @Override
    public Writer openAsWriter(File fileName, String encoding, boolean append) throws IOException {
        return new OutputStreamWriter(this.openAsOutputStream(fileName, append), encoding);
    }

    @Override
    public StoreChannel create(File fileName) throws IOException {
        return this.open(fileName, "rw");
    }

    @Override
    public boolean fileExists(File fileName) {
        return Files.exists(this.path(fileName), new LinkOption[0]);
    }

    @Override
    public boolean mkdir(File fileName) {
        if (!this.fileExists(fileName)) {
            try {
                Files.createDirectory(this.path(fileName), new FileAttribute[0]);
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void mkdirs(File fileName) throws IOException {
        Files.createDirectories(this.path(fileName), new FileAttribute[0]);
    }

    @Override
    public long getFileSize(File fileName) {
        try {
            return Files.size(this.path(fileName));
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public boolean deleteFile(File fileName) {
        try {
            Files.delete(this.path(fileName));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void deleteRecursively(File directory) throws IOException {
        if (this.fileExists(directory)) {
            FileUtils.deletePathRecursively(this.path(directory));
        }
    }

    @Override
    public boolean renameFile(File from, File to) throws IOException {
        Files.move(this.path(from), this.path(to), new CopyOption[0]);
        return true;
    }

    @Override
    public File[] listFiles(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            for (Path path : Files.newDirectoryStream(this.path(directory))) {
                files.add(path.toFile());
            }
        }
        catch (IOException e) {
            return null;
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public File[] listFiles(File directory, final FilenameFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            DirectoryStream.Filter<Path> dirfilter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    return filter.accept(entry.getParent().toFile(), entry.getFileName().toString());
                }
            };
            for (Path path : Files.newDirectoryStream(this.path(directory), (DirectoryStream.Filter<? super Path>)dirfilter)) {
                files.add(path.toFile());
            }
        }
        catch (IOException e) {
            return null;
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public boolean isDirectory(File file) {
        return Files.isDirectory(this.path(file), new LinkOption[0]);
    }

    @Override
    public void moveToDirectory(File file, File toDirectory) throws IOException {
        Files.move(this.path(file), this.path(toDirectory).resolve(this.path(file.getName())), new CopyOption[0]);
    }

    @Override
    public void copyFile(File from, File to) throws IOException {
        Files.copy(this.path(from), this.path(to), new CopyOption[0]);
    }

    @Override
    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        Path target = this.path(toDirectory);
        Path source = this.path(fromDirectory);
        this.copyRecursively(source, target);
    }

    private void copyRecursively(Path source, Path target) throws IOException {
        for (Path sourcePath : Files.newDirectoryStream(source)) {
            Path targetPath = target.resolve(sourcePath.getFileName());
            if (Files.isDirectory(sourcePath, new LinkOption[0])) {
                Files.createDirectories(targetPath, new FileAttribute[0]);
                this.copyRecursively(sourcePath, targetPath);
                continue;
            }
            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
    }

    @Override
    public synchronized <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        FileSystemAbstraction.ThirdPartyFileSystem otherFs = (FileSystemAbstraction.ThirdPartyFileSystem)this.thirdPartyFs.get(clazz);
        if (otherFs == null) {
            otherFs = (FileSystemAbstraction.ThirdPartyFileSystem)creator.apply(clazz);
            this.thirdPartyFs.put(clazz, otherFs);
        }
        return (K)otherFs;
    }

    @Override
    public void truncate(File path, long size) throws IOException {
        try (FileChannel channel = FileChannel.open(this.path(path), new OpenOption[0]);){
            channel.truncate(size);
        }
    }
}

