/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;

final class MuninnWritePageCursor
extends MuninnPageCursor {
    MuninnWritePageCursor() {
    }

    @Override
    protected void unpinCurrentPage() {
        if (this.page != null) {
            this.pinEvent.done();
            assert (this.page.isWriteLocked()) : "page pinned for writing was not write locked: " + this.page;
            this.unlockPage(this.page);
            this.page = null;
        }
        this.lockStamp = 0L;
    }

    @Override
    public boolean next() throws IOException {
        this.unpinCurrentPage();
        this.assertPagedFileStillMapped();
        if (this.nextPageId > this.lastPageId) {
            if ((this.pf_flags & 4) != 0) {
                return false;
            }
            this.pagedFile.increaseLastPageIdTo(this.nextPageId);
        }
        this.pin(this.nextPageId, true);
        this.currentPageId = this.nextPageId++;
        return true;
    }

    @Override
    protected void lockPage(MuninnPage page) {
        this.lockStamp = page.writeLock();
    }

    @Override
    protected void unlockPage(MuninnPage page) {
        page.unlockWrite(this.lockStamp);
    }

    @Override
    protected void pinCursorToPage(MuninnPage page, long filePageId, PageSwapper swapper) {
        this.reset(page);
        this.assertPagedFileStillMapped();
        page.incrementUsage();
        page.markAsDirty();
    }

    @Override
    protected void convertPageFaultLock(MuninnPage page, long stamp) {
        this.lockStamp = stamp;
    }

    @Override
    public final boolean shouldRetry() {
        return false;
    }
}

