/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.memory.MemoryTracker;

public final class FileSystemUtils {
    private FileSystemUtils() {
    }

    public static void writeString(FileSystemAbstraction fs, Path path, String value, MemoryTracker memoryTracker) throws IOException {
        FileSystemUtils.writeAllBytes(fs, path, value.getBytes(StandardCharsets.UTF_8), memoryTracker);
    }

    public static void writeAllBytes(FileSystemAbstraction fs, Path path, byte[] data, MemoryTracker memoryTracker) throws IOException {
        try (StoreChannel storeChannel = fs.write(path);
             NativeScopedBuffer scopedBuffer = new NativeScopedBuffer(data.length, ByteOrder.LITTLE_ENDIAN, memoryTracker);){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            buffer.put(data);
            buffer.flip();
            storeChannel.writeAll(buffer);
        }
    }

    public static String readString(FileSystemAbstraction fs, Path path, MemoryTracker memoryTracker) throws IOException {
        if (!fs.fileExists(path)) {
            return null;
        }
        return new String(FileSystemUtils.readAllBytes(fs, path, memoryTracker), StandardCharsets.UTF_8);
    }

    public static byte[] readAllBytes(FileSystemAbstraction fs, Path path, MemoryTracker memoryTracker) throws IOException {
        long fileSize = fs.getFileSize(path);
        try (StoreChannel reader = fs.read(path);){
            NativeScopedBuffer scopedBuffer = new NativeScopedBuffer(fileSize, ByteOrder.LITTLE_ENDIAN, memoryTracker);
            try {
                ByteBuffer buffer = scopedBuffer.getBuffer();
                reader.readAll(buffer);
                buffer.flip();
                byte[] data = new byte[(int)fileSize];
                buffer.get(data);
                byte[] byArray = data;
                scopedBuffer.close();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    scopedBuffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static List<String> readLines(FileSystemAbstraction fs, Path path, MemoryTracker memoryTracker) throws IOException {
        String string = FileSystemUtils.readString(fs, path, memoryTracker);
        return string != null ? string.lines().toList() : null;
    }

    public static boolean isEmptyOrNonExistingDirectory(FileSystemAbstraction fs, Path directory) throws IOException {
        if (fs.isDirectory(directory)) {
            Object[] files = fs.listFiles(directory);
            return ArrayUtils.isEmpty((Object[])files);
        }
        return !fs.fileExists(directory);
    }

    public static long size(FileSystemAbstraction fs, Path file) {
        try {
            if (fs.isDirectory(file)) {
                Path[] files = fs.listFiles(file);
                long size = 0L;
                for (Path child : files) {
                    size += FileSystemUtils.size(fs, child);
                }
                return size;
            }
            return fs.getFileSize(file);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static void deleteFile(FileSystemAbstraction fs, Path fileToDelete) throws IOException {
        if (fs.isDirectory(fileToDelete)) {
            fs.deleteRecursively(fileToDelete);
        } else {
            fs.deleteFile(fileToDelete);
        }
    }

    public static String pathToString(Path path) {
        return path.toString().replace("\\", "\\\\");
    }
}

