/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.InputStreamReadableChannel;
import org.neo4j.io.fs.ReadPastEndException;

public class InputStreamReadableChannelTest {
    @Test
    void getByteArray_simple() throws IOException {
        byte[] input = "hello".getBytes();
        try (InputStreamReadableChannel channel = new InputStreamReadableChannel((InputStream)new ByteArrayInputStream(input));){
            byte[] output = new byte[input.length];
            channel.get(output, input.length);
            Assertions.assertThat((byte[])output).isEqualTo((Object)input);
        }
    }

    @Test
    void getByteArray_readPastStreamEnd() throws IOException {
        byte[] input = "small".getBytes();
        try (InputStreamReadableChannel channel = new InputStreamReadableChannel((InputStream)new ByteArrayInputStream(input));){
            byte[] output = new byte[input.length + 2];
            Assertions.assertThatThrownBy(() -> channel.get(output, output.length)).isInstanceOf(ReadPastEndException.class);
        }
    }

    @Test
    void getByteArray_readMoreThanByteArraySize() throws IOException {
        byte[] input = "too large".getBytes();
        try (InputStreamReadableChannel channel = new InputStreamReadableChannel((InputStream)new ByteArrayInputStream(input));){
            byte[] output = new byte[2];
            Assertions.assertThatThrownBy(() -> channel.get(output, input.length)).isInstanceOf(IndexOutOfBoundsException.class);
        }
    }

    @Test
    void getByteArray_readLessThanByteArraySize() throws IOException {
        byte[] input = "just a slice please".getBytes();
        try (InputStreamReadableChannel channel = new InputStreamReadableChannel((InputStream)new ByteArrayInputStream(input));){
            byte[] output = new byte[input.length];
            channel.get(output, 6);
            Assertions.assertThat((byte[])output).startsWith("just a".getBytes()).endsWith(new byte["slice please".length()]);
        }
    }

    @Test
    void getByteArray_streamReturnsFewerBytesThanRequested() throws IOException {
        SomeExceptionsInputStream stream = new SomeExceptionsInputStream(49, "An exception", 50, 51, "Another exception", 52, 53);
        byte[] expected = "12345".getBytes();
        byte[] output = new byte[expected.length];
        try (InputStreamReadableChannel channel = new InputStreamReadableChannel((InputStream)stream);){
            channel.get(output, output.length);
        }
        Assertions.assertThat((byte[])output).isEqualTo((Object)expected);
    }

    private static class SomeExceptionsInputStream
    extends InputStream {
        private final List<IntSupplier> items = new ArrayList<IntSupplier>();

        public SomeExceptionsInputStream(Object ... results) {
            for (Object result : results) {
                if (result instanceof Integer) {
                    Integer someInt = (Integer)result;
                    this.items.add(() -> someInt);
                    continue;
                }
                this.items.add(() -> {
                    throw new RuntimeException(result.toString());
                });
            }
        }

        @Override
        public int read() throws IOException {
            if (this.items.isEmpty()) {
                return -1;
            }
            try {
                return this.items.remove(0).getAsInt();
            }
            catch (RuntimeException e) {
                throw new IOException(e);
            }
        }
    }
}

