/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.context;

import java.util.Objects;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContext;
import org.neo4j.io.pagecache.context.UnboundedReadVersionContext;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.io.pagecache.tracing.cursor.CursorStatisticSnapshot;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class CursorContext
implements AutoCloseable {
    public static final CursorContext NULL_CONTEXT = new CursorContext(CursorContextFactory.NULL_CONTEXT_FACTORY, PageCursorTracer.NULL, FixedVersionContext.EMPTY_VERSION_CONTEXT);
    private final PageCursorTracer cursorTracer;
    private final VersionContext versionContext;
    private final CursorContextFactory contextFactory;

    protected CursorContext(CursorContextFactory contextFactory, PageCursorTracer cursorTracer, VersionContext versionContext) {
        this.cursorTracer = Objects.requireNonNull(cursorTracer);
        this.versionContext = Objects.requireNonNull(versionContext);
        this.contextFactory = contextFactory;
    }

    public PageCursorTracer getCursorTracer() {
        return this.cursorTracer;
    }

    public VersionContext getVersionContext() {
        return this.versionContext;
    }

    @Override
    public void close() {
        this.cursorTracer.close();
    }

    public void merge(CursorStatisticSnapshot statisticSnapshot) {
        this.cursorTracer.merge(statisticSnapshot);
    }

    public CursorContext createRelatedContext(String tag) {
        return this.contextFactory.create(tag, this.versionContext.createRelatedContext());
    }

    public CursorContext createUnboundedReadRelatedContext(String tag) {
        return this.contextFactory.create(tag, new UnboundedReadVersionContext(this.versionContext.committingTransactionId(), this.versionContext.committingAppendIndex()));
    }

    public CursorContext createUnboundedRelatedContext() {
        return new CursorContext(this.contextFactory, this.cursorTracer, FixedVersionContext.EMPTY_VERSION_CONTEXT);
    }
}

