/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.muninn.CursorFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnReadPageCursor;
import org.neo4j.scheduler.CancelListener;
import org.neo4j.time.SystemNanoClock;

class PreFetcher
implements Runnable,
CancelListener {
    private static final String TRACER_PRE_FETCHER_TAG = "Pre-fetcher";
    private final MuninnPageCursor observedCursor;
    private final CursorFactory cursorFactory;
    private final SystemNanoClock clock;
    private volatile boolean cancelled;
    private long startTime;
    private long deadline;
    private long tripCount;
    private long pauseNanos = TimeUnit.MILLISECONDS.toNanos(10L);

    PreFetcher(MuninnPageCursor observedCursor, CursorFactory cursorFactory, SystemNanoClock clock) {
        this.observedCursor = observedCursor;
        this.cursorFactory = cursorFactory;
        this.clock = clock;
    }

    @Override
    public void run() {
        long offset;
        long secondPageId;
        long initialPageId;
        this.setDeadline(150L, TimeUnit.MILLISECONDS);
        while ((initialPageId = this.getCurrentObservedPageId()) == -1L) {
            this.pause();
            if (!this.pastDeadline()) continue;
            return;
        }
        this.setDeadline(200L, TimeUnit.MILLISECONDS);
        while ((secondPageId = this.getCurrentObservedPageId()) == initialPageId) {
            this.pause();
            if (!this.pastDeadline()) continue;
            return;
        }
        if (secondPageId == -1L) {
            return;
        }
        boolean forward = initialPageId < secondPageId;
        long jump = offset = forward ? 1L : -1L;
        try (CursorContext context = this.observedCursor.cursorContext.createRelatedContext(TRACER_PRE_FETCHER_TAG);
             MuninnReadPageCursor prefetchCursor = this.cursorFactory.takeReadCursor(0L, 1, context);){
            long currentPageId = this.getCurrentObservedPageId();
            while (currentPageId != -1L) {
                long toPage;
                long fromPage;
                long cp = currentPageId + offset;
                if (forward) {
                    fromPage = cp;
                    toPage = cp + jump;
                } else {
                    fromPage = Math.max(0L, cp + jump);
                    toPage = cp;
                }
                while (fromPage < toPage) {
                    if (!((PageCursor)prefetchCursor).next(fromPage) || this.cancelled) {
                        return;
                    }
                    ++fromPage;
                }
                long nextPageId = this.getCurrentObservedPageId();
                if (nextPageId == currentPageId) {
                    this.setDeadline(10L, TimeUnit.SECONDS);
                    while (nextPageId == currentPageId) {
                        this.pause();
                        if (this.pastDeadline()) {
                            return;
                        }
                        nextPageId = this.getCurrentObservedPageId();
                    }
                    this.madeProgress();
                }
                if (nextPageId != -1L) {
                    jump = (nextPageId - currentPageId) * 2L;
                }
                currentPageId = nextPageId;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void setDeadline(long timeout, TimeUnit unit) {
        this.startTime = this.clock.nanos();
        this.deadline = unit.toNanos(timeout) + this.startTime;
        if (this.tripCount != 0L) {
            this.tripCount = 0L;
        }
    }

    private void pause() {
        if (this.tripCount < 10L) {
            Thread.onSpinWait();
        } else {
            LockSupport.parkNanos(this, this.pauseNanos);
        }
        ++this.tripCount;
    }

    private boolean pastDeadline() {
        boolean past;
        boolean bl = past = this.clock.nanos() > this.deadline;
        if (past && this.tripCount != 0L) {
            this.tripCount = 0L;
        }
        return past || this.cancelled;
    }

    private void madeProgress() {
        long timeToProgressNanos = this.clock.nanos() - this.startTime;
        long pause = (this.pauseNanos * 3L + timeToProgressNanos * 5L) / 8L;
        this.pauseNanos = Math.min(pause, TimeUnit.MILLISECONDS.toNanos(10L));
    }

    private long getCurrentObservedPageId() {
        return this.observedCursor.loadVolatileCurrentPageId();
    }

    public void cancelled() {
        this.cancelled = true;
    }
}

