/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.neo4j.io.pagecache.ByteArrayPageCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.opentest4j.AssertionFailedError;

@ExtendWith(value={PrintOnFailure.class})
class PageCursorUtilTest {
    private static Random random;
    private static long seed;

    PageCursorUtilTest() {
    }

    @BeforeEach
    void setUp() {
        seed = System.currentTimeMillis();
        random = new Random(seed);
    }

    @Test
    void shouldPutAndGet6BLongs() {
        PageCursor cursor = ByteArrayPageCursor.wrap((int)10);
        for (int i = 0; i < 1000; ++i) {
            long expected = random.nextLong() & 0xFFFFFFFFFFFFL;
            cursor.setOffset(0);
            PageCursorUtil.put6BLong((PageCursor)cursor, (long)expected);
            int offsetAfterWrite = cursor.getOffset();
            cursor.setOffset(0);
            long read = PageCursorUtil.get6BLong((PageCursor)cursor);
            int offsetAfterRead = cursor.getOffset();
            org.junit.jupiter.api.Assertions.assertEquals((long)expected, (long)read);
            org.junit.jupiter.api.Assertions.assertTrue((read >= 0L ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)(read & 0xFFFF000000000000L));
            org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)offsetAfterWrite);
            org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)offsetAfterRead);
        }
    }

    @Test
    void shouldPutAndGet6BLongMinusOneAware() {
        PageCursor cursor = ByteArrayPageCursor.wrap((int)20);
        PageCursorUtil.put6BLongMinusOneAware((PageCursor)cursor, (long)-1L);
        long value = random.nextLong() & 0xFFFFFFFFFFFEL;
        PageCursorUtil.put6BLongMinusOneAware((PageCursor)cursor, (long)value);
        cursor.setOffset(0);
        Assertions.assertThat((long)PageCursorUtil.get6BLongMinusOneAware((PageCursor)cursor)).isEqualTo(-1L);
        Assertions.assertThat((long)PageCursorUtil.get6BLongMinusOneAware((PageCursor)cursor)).isEqualTo(value);
    }

    @Test
    void shouldPutAndGet3BInt() {
        PageCursor cursor = ByteArrayPageCursor.wrap((int)10);
        for (int i = 0; i < 1000; ++i) {
            int expected = random.nextInt() & 0xFFFFFF;
            cursor.setOffset(0);
            PageCursorUtil.put3BInt((PageCursor)cursor, (int)expected);
            int offsetAfterWrite = cursor.getOffset();
            cursor.setOffset(0);
            int read = PageCursorUtil.get3BInt((PageCursor)cursor);
            int offsetAfterRead = cursor.getOffset();
            org.junit.jupiter.api.Assertions.assertEquals((int)expected, (int)read);
            org.junit.jupiter.api.Assertions.assertTrue((read >= 0 ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)(read & 0xFF000000));
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)offsetAfterWrite);
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)offsetAfterRead);
        }
    }

    @Test
    void shouldPutAndGet3BIntMinusOneAware() {
        PageCursor cursor = ByteArrayPageCursor.wrap((int)20);
        PageCursorUtil.put3BIntMinusOneAware((PageCursor)cursor, (int)-1);
        int value = random.nextInt(0xFFFFFE);
        PageCursorUtil.put3BIntMinusOneAware((PageCursor)cursor, (int)value);
        cursor.setOffset(0);
        Assertions.assertThat((int)PageCursorUtil.get3BIntMinusOneAware((PageCursor)cursor)).isEqualTo(-1);
        Assertions.assertThat((int)PageCursorUtil.get3BIntMinusOneAware((PageCursor)cursor)).isEqualTo(value);
    }

    @Test
    void shouldPutAndGet3BIntAtOffset() {
        PageCursor cursor = ByteArrayPageCursor.wrap((int)10);
        for (int i = 0; i < 1000; ++i) {
            int expected = random.nextInt() & 0xFFFFFF;
            cursor.setOffset(0);
            PageCursorUtil.put3BInt((PageCursor)cursor, (int)1, (int)expected);
            int offsetAfterWrite = cursor.getOffset();
            cursor.setOffset(0);
            int read = PageCursorUtil.get3BInt((PageCursor)cursor, (int)1);
            int offsetAfterRead = cursor.getOffset();
            org.junit.jupiter.api.Assertions.assertEquals((int)expected, (int)read);
            org.junit.jupiter.api.Assertions.assertTrue((read >= 0 ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)(read & 0xFF000000));
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)offsetAfterWrite);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)offsetAfterRead);
        }
    }

    @Test
    void shouldPutAndGetUnsignedShort() {
        PageCursor cursor = ByteArrayPageCursor.wrap((int)10);
        for (int i = 0; i < 1000; ++i) {
            int expected = random.nextInt() & 0xFFFF;
            cursor.setOffset(0);
            PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)expected);
            int offsetAfterWrite = cursor.getOffset();
            cursor.setOffset(0);
            int read = PageCursorUtil.getUnsignedShort((PageCursor)cursor);
            int offsetAfterRead = cursor.getOffset();
            org.junit.jupiter.api.Assertions.assertEquals((int)expected, (int)read);
            org.junit.jupiter.api.Assertions.assertTrue((read >= 0 ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)(read & 0xFFFF0000));
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)offsetAfterWrite);
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)offsetAfterRead);
        }
    }

    @Test
    void shouldPutAndGetUnsignedShortAtOffset() {
        PageCursor cursor = ByteArrayPageCursor.wrap((int)10);
        for (int i = 0; i < 1000; ++i) {
            int expected = random.nextInt() & 0xFFFF;
            cursor.setOffset(0);
            PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)1, (int)expected);
            int offsetAfterWrite = cursor.getOffset();
            cursor.setOffset(0);
            int read = PageCursorUtil.getUnsignedShort((PageCursor)cursor, (int)1);
            int offsetAfterRead = cursor.getOffset();
            org.junit.jupiter.api.Assertions.assertEquals((int)expected, (int)read);
            org.junit.jupiter.api.Assertions.assertTrue((read >= 0 ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)(read & 0xFFFF0000));
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)offsetAfterWrite);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)offsetAfterRead);
        }
    }

    @Test
    void shouldFailOnInvalidValues() {
        PageCursor cursor = ByteArrayPageCursor.wrap((int)10);
        int i = 0;
        while (i < 1000) {
            long expected = random.nextLong();
            if ((expected & 0xFFFF000000000000L) == 0L) continue;
            cursor.setOffset(0);
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> PageCursorUtil.put6BLong((PageCursor)cursor, (long)expected));
            ++i;
        }
    }

    public static class PrintOnFailure
    implements TestWatcher {
        public void testFailed(ExtensionContext context, Throwable cause) {
            throw new AssertionFailedError(String.format("%s [ random seed used: %dL ]", cause.getMessage(), seed), cause);
        }
    }
}

