/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.async;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.async.AsyncCompletionHandler;
import org.neo4j.io.async.AsyncFailureHandler;
import org.neo4j.io.async.AsyncIOProvider;
import org.neo4j.io.async.IllegalStateExceptionFailureHandler;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class DefaultAsyncIOProviderTest {
    DefaultAsyncIOProviderTest() {
    }

    @Test
    void asyncProviderIsNotAvailableByDefault() {
        AsyncIOProvider asyncIOProvider = AsyncIOProvider.getInstance();
        AsyncBlockAccessor asyncBlockAccessor = asyncIOProvider.createAsyncBlockAccessor(10, AsyncCompletionHandler.EMPTY_COMPLETION_HANDLER, (AsyncFailureHandler)IllegalStateExceptionFailureHandler.ILLEGAL_STATE_HANDLER, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)asyncBlockAccessor.isAvailable());
        Assertions.assertThatThrownBy(() -> asyncBlockAccessor.asyncRead(1, 2L, 3L, 4L, 5)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> asyncBlockAccessor.asyncWrite(1, 2L, 3L, 4L, 5)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> asyncBlockAccessor.asyncVectorRead(1, 2L, new long[]{3L}, new int[]{4})).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> asyncBlockAccessor.asyncVectorWrite(1, 2L, new long[]{3L}, new int[]{4})).isInstanceOf(UnsupportedOperationException.class);
    }
}

