/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;

class ByteBuffersTest {
    ByteBuffersTest() {
    }

    @Test
    void trackMemoryAllocationsForNativeByteBuffers() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 100L, 0L, null);
        ByteBuffer byteBuffer = ByteBuffers.allocateDirect((int)30, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)memoryTracker);
        try {
            Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
            Assertions.assertEquals((long)30L, (long)memoryTracker.usedNativeMemory());
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)byteBuffer, (MemoryTracker)memoryTracker);
        }
        Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void trackMemoryAllocationsForHeapByteBuffers() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 100L, 0L, null);
        ByteBuffer byteBuffer = ByteBuffers.allocate((int)30, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)memoryTracker);
        try {
            Assertions.assertEquals((long)30L, (long)memoryTracker.estimatedHeapMemory());
            Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)byteBuffer, (MemoryTracker)memoryTracker);
        }
        Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void byteBufferMustThrowOutOfBoundsAfterRelease() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)8, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)tracker);
        buffer.get(0);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(0));
    }

    @Test
    void heapByteBufferMustThrowOutOfBoundsAfterRelease() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)8, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)tracker);
        buffer.get(0);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(0));
    }

    @Test
    void doubleFreeOfByteBufferIsOkay() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        ByteBuffer buffer = ByteBuffers.allocate((int)8, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)tracker);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(0));
    }

    @Test
    void doubleFreeOfHeapByteBufferIsOkay() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        ByteBuffer buffer = ByteBuffers.allocate((int)8, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)tracker);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(0));
    }

    @Test
    void directBufferAllZeros() {
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)10, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            Assertions.assertFalse((boolean)ByteBuffers.directBufferContainsNonZeroData((ByteBuffer)buffer));
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }

    @Test
    void directBufferWithNonZeroData() {
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)10, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            buffer.put(5, (byte)42);
            buffer.rewind();
            Assertions.assertTrue((boolean)ByteBuffers.directBufferContainsNonZeroData((ByteBuffer)buffer));
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }

    @Test
    void directBufferNonZeroAtEnd() {
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)10, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            buffer.put(9, (byte)-42);
            buffer.rewind();
            Assertions.assertTrue((boolean)ByteBuffers.directBufferContainsNonZeroData((ByteBuffer)buffer));
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }

    @Test
    void emptyDirectBufferDoesNotContainNonZeroData() {
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)10, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            Assertions.assertFalse((boolean)ByteBuffers.directBufferContainsNonZeroData((ByteBuffer)buffer));
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }

    @Test
    void bigDirectBufferAllZeros() {
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)((int)ByteUnit.kibiBytes((long)16L)), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            Assertions.assertFalse((boolean)ByteBuffers.directBufferContainsNonZeroData((ByteBuffer)buffer));
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }

    @Test
    void bigDirectBufferNonZeroAtEnd() {
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)((int)ByteUnit.kibiBytes((long)16L) + 17), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            buffer.put(buffer.limit() - 4, (byte)-42);
            buffer.rewind();
            Assertions.assertTrue((boolean)ByteBuffers.directBufferContainsNonZeroData((ByteBuffer)buffer));
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 3, 4, 5, 6, 7, 8, 9, 15, 16, 17, 31, 32, 33, 63, 64, 65, 127, 128, 129, 255, 256, 257, 1023, 1024, 1025, 2056, 12288, 12289, 16384, 16386})
    void variousBufferSizesNonZeroAtEnd(int size) {
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)size, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            buffer.put(size - 1, (byte)1);
            Assertions.assertTrue((boolean)ByteBuffers.directBufferContainsNonZeroData((ByteBuffer)buffer));
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 3, 4, 5, 6, 7, 8, 9, 15, 16, 17, 31, 32, 33, 63, 64, 65, 127, 128, 129, 255, 256, 257, 1023, 1024, 1025, 2056, 12288, 12289, 16384, 16386})
    void variousBufferSizesAllZero(int size) {
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)size, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            Assertions.assertFalse((boolean)ByteBuffers.directBufferContainsNonZeroData((ByteBuffer)buffer));
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }
}

