/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.pagecache.impl.muninn.EvictionClockArm;

class EvictionClockArmTest {
    EvictionClockArmTest() {
    }

    @Test
    void startClockWithZeroPage() {
        EvictionClockArm arm = new EvictionClockArm(5);
        Assertions.assertEquals((int)0, (int)arm.nextPage());
    }

    @Test
    void startClockWithCustomArm() {
        EvictionClockArm arm = new EvictionClockArm(10, 5);
        Assertions.assertEquals((int)6, (int)arm.nextPage());
        Assertions.assertEquals((int)7, (int)arm.nextPage());
    }

    @Test
    void switchToZeroAfterReachingEnd() {
        EvictionClockArm arm = new EvictionClockArm(3, 1);
        Assertions.assertEquals((int)2, (int)arm.nextPage());
        Assertions.assertEquals((int)0, (int)arm.nextPage());
        Assertions.assertEquals((int)1, (int)arm.nextPage());
    }

    @Test
    void pageCycles() {
        int[] expected;
        EvictionClockArm arm = new EvictionClockArm(3);
        for (int exp : expected = new int[]{0, 1, 2, 0, 1, 2}) {
            Assertions.assertEquals((int)exp, (int)arm.nextPage());
        }
    }

    @Test
    void startClockOnTheLastPage() {
        EvictionClockArm arm = new EvictionClockArm(7, 6);
        Assertions.assertEquals((int)0, (int)arm.nextPage());
        Assertions.assertEquals((int)1, (int)arm.nextPage());
    }
}

