/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.locker;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.locker.FileLockException;

public class Locker
implements Closeable {
    private final FileSystemAbstraction fileSystemAbstraction;
    private final Path lockFile;
    protected FileLock lockFileLock;
    private StoreChannel lockFileChannel;

    public Locker(FileSystemAbstraction fileSystemAbstraction, Path lockFile) {
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.lockFile = lockFile;
    }

    public final Path lockFile() {
        return this.lockFile;
    }

    public void checkLock() {
        if (this.haveLockAlready()) {
            return;
        }
        try {
            if (!this.fileSystemAbstraction.fileExists(this.lockFile)) {
                this.fileSystemAbstraction.mkdirs(this.lockFile.getParent());
            }
        }
        catch (IOException e) {
            String message = "Unable to create path for dir: " + String.valueOf(this.lockFile.getParent());
            throw Locker.storeLockException(message, e);
        }
        try {
            if (this.lockFileChannel == null) {
                this.lockFileChannel = this.fileSystemAbstraction.write(this.lockFile);
            }
            this.lockFileLock = this.lockFileChannel.tryLock();
            if (this.lockFileLock == null) {
                String message = "Lock file has been locked by another process: " + String.valueOf(this.lockFile);
                throw Locker.storeLockException(message, null);
            }
        }
        catch (OverlappingFileLockException e) {
            throw this.unableToObtainLockException();
        }
        catch (IOException e) {
            throw this.unableToObtainLockException(Locker.tryCollectPermissionInformation(this.fileSystemAbstraction, this.lockFile), e);
        }
    }

    public static String tryCollectPermissionInformation(FileSystemAbstraction fs, Path file) {
        String processUserName = ProcessHandle.current().info().user().orElse(System.getProperty("user.name"));
        if (processUserName != null && !processUserName.equals("?")) {
            String filePermissionInformation = null;
            try {
                filePermissionInformation = Locker.tryCollectPermissionInformation(processUserName, file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (filePermissionInformation == null && !fs.isDirectory(file)) {
                try {
                    filePermissionInformation = Locker.tryCollectPermissionInformation(processUserName, file.getParent());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return filePermissionInformation;
        }
        return null;
    }

    private static String tryCollectPermissionInformation(String processUserName, Path file) throws IOException {
        String fileOwner = Files.getOwner(file, new LinkOption[0]).getName();
        if (!processUserName.equals(fileOwner)) {
            return String.format("Owner '%s' of '%s' and user running this process '%s' differs, potentially resulting in a file permission problem. Ensure that the file has the same owner, or at least has write access for the user running the Neo4j process trying to use it.", fileOwner, file, processUserName);
        }
        return null;
    }

    protected boolean haveLockAlready() {
        return this.lockFileLock != null && this.lockFileChannel != null;
    }

    protected FileLockException unableToObtainLockException() {
        return this.unableToObtainLockException(null, null);
    }

    protected FileLockException unableToObtainLockException(String additionalInformation, Exception cause) {
        String message = String.format("Unable to obtain lock on file: %s%s", this.lockFile, additionalInformation != null ? ": " + additionalInformation : "");
        return Locker.storeLockException(message, cause);
    }

    private static FileLockException storeLockException(String message, Exception e) {
        String help = "Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)";
        return new FileLockException(message + ". " + help, e);
    }

    @Override
    public void close() throws IOException {
        if (this.lockFileLock != null) {
            this.releaseLock();
        }
        if (this.lockFileChannel != null) {
            this.releaseChannel();
        }
    }

    private void releaseChannel() throws IOException {
        this.lockFileChannel.close();
        this.lockFileChannel = null;
    }

    protected void releaseLock() throws IOException {
        this.lockFileLock.release();
        this.lockFileLock = null;
    }
}

