/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.eclipse.collections.api.map.primitive.MutableLongLongMap;
import org.eclipse.collections.impl.factory.primitive.LongLongMaps;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.impl.muninn.swapper.PageSwapper;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.util.FeatureToggles;

final class MuninnWritePageCursor
extends MuninnPageCursor {
    private static final long UNKNOWN_STAMP = -1L;
    private static final MutableLongLongMap LOCKED_PAGES = FeatureToggles.flag(MuninnWritePageCursor.class, (String)"CHECK_WRITE_LOCKS", (boolean)false) ? LongLongMaps.mutable.empty().asSynchronized() : null;

    MuninnWritePageCursor(MuninnPagedFile pagedFile, int pf_flags, long victimPage, CursorContext cursorContext, long pageId) {
        super(pagedFile, pf_flags, victimPage, cursorContext, pageId);
    }

    @Override
    public void unpin() {
        long pageRef = this.pinnedPageRef;
        if (pageRef != 0L) {
            this.tracer.unpin(this.loadPlainCurrentPageId(), this.swapper);
            if (this.eagerFlush) {
                this.eagerlyFlushAndUnlockPage(pageRef);
            } else {
                this.unlockPage(pageRef);
            }
        }
        this.clearPageCursorState();
        this.storeCurrentPageId(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eagerlyFlushAndUnlockPage(long pageRef) {
        long flushStamp = 0L;
        if (this.multiVersioned) {
            if (!this.isPinnedByLinkedFriends(pageRef)) {
                long currentThread;
                long locker;
                if (LOCKED_PAGES != null && (locker = LOCKED_PAGES.removeKeyIfAbsent(pageRef, -1L)) != (currentThread = Thread.currentThread().threadId())) {
                    throw new IllegalStateException("Recorded locker of the page is " + locker + " doesn't match current thread id " + currentThread);
                }
                flushStamp = PageList.unlockWriteAndTryTakeFlushLock(pageRef);
            }
        } else {
            flushStamp = PageList.unlockWriteAndTryTakeFlushLock(pageRef);
        }
        if (flushStamp != 0L) {
            boolean success = false;
            try {
                success = this.pagedFile.flushLockedPage(pageRef, this.loadPlainCurrentPageId());
            }
            finally {
                PageList.unlockFlush(pageRef, flushStamp, success);
            }
        }
    }

    @Override
    public boolean next() throws IOException {
        this.unpin();
        long lastPageId = this.assertCursorOpenFileMappedAndGetIdOfLastPage();
        if (this.nextPageId < 0L) {
            this.storeCurrentPageId(-1L);
            return false;
        }
        if (this.nextPageId > lastPageId) {
            if (this.noGrow) {
                this.storeCurrentPageId(-1L);
                return false;
            }
            this.pagedFile.increaseLastPageIdTo(this.nextPageId);
        }
        this.storeCurrentPageId(this.nextPageId);
        ++this.nextPageId;
        long filePageId = this.loadPlainCurrentPageId();
        try (PinEvent pinEvent = this.tracer.beginPin(true, filePageId, this.swapper);){
            this.pin(pinEvent, filePageId);
        }
        return true;
    }

    @Override
    protected boolean tryLockPage(long pageRef) {
        if (this.multiVersioned) {
            long threadId;
            long locker;
            if (this.isPinnedByLinkedFriends(pageRef)) {
                return true;
            }
            if (LOCKED_PAGES != null && (locker = LOCKED_PAGES.getIfAbsent(pageRef, -1L)) == (threadId = Thread.currentThread().threadId())) {
                throw new IllegalStateException("Multiversioned page locks are not reentrant unless it's from linked cursors. Other thread " + threadId + " already holds write lock on page " + pageRef);
            }
            boolean writeLock = PageList.tryWriteLock(pageRef, true);
            if (LOCKED_PAGES != null && writeLock) {
                LOCKED_PAGES.put(pageRef, Thread.currentThread().threadId());
            }
            return writeLock;
        }
        return PageList.tryWriteLock(pageRef, false);
    }

    private boolean isPinnedByLinkedFriends(long pageRef) {
        MuninnPageCursor backwardCursor = this.backLinkedCursor;
        while (backwardCursor != null) {
            if (backwardCursor.pinnedPageRef == pageRef) {
                return true;
            }
            backwardCursor = backwardCursor.backLinkedCursor;
        }
        MuninnPageCursor forwardCursor = this.linkedCursor;
        while (forwardCursor != null) {
            if (forwardCursor.pinnedPageRef == pageRef) {
                return true;
            }
            forwardCursor = forwardCursor.linkedCursor;
        }
        return false;
    }

    @Override
    protected void unlockPage(long pageRef) {
        if (this.multiVersioned) {
            if (!this.isPinnedByLinkedFriends(pageRef)) {
                long currentThread;
                long locker;
                if (LOCKED_PAGES != null && (locker = LOCKED_PAGES.removeKeyIfAbsent(pageRef, -1L)) != (currentThread = Thread.currentThread().threadId())) {
                    throw new IllegalStateException("Recorded locker of the page is " + locker + " doesn't match current thread id " + currentThread);
                }
                PageList.unlockWrite(pageRef);
            }
        } else {
            PageList.unlockWrite(pageRef);
        }
    }

    @Override
    protected void pinCursorToPage(PinEvent pinEvent, long pageRef, long filePageId, PageSwapper swapper) throws FileIsNotMappedException {
        this.init(pinEvent, pageRef);
        this.assertCursorOpenFileMappedAndGetIdOfLastPage();
        if (this.multiVersioned) {
            this.versionStamp = this.versionContext.stamp();
            long pagePointer = this.pointer;
            long headVersion = MuninnWritePageCursor.getLongAt(pagePointer, this.littleEndian);
            if (this.isOldHead(this.versionContext, headVersion)) {
                long copyPageReference = this.versionStorage.createPageSnapshot(this, this.versionContext, headVersion, pinEvent);
                MuninnWritePageCursor.putLongAt(pagePointer + 8L, copyPageReference, this.littleEndian);
                MuninnWritePageCursor.putLongAt(pagePointer, this.versionContext.committingTransactionId(), this.littleEndian);
            }
        } else if (this.contextVersionUpdates) {
            PageList.setLastModifiedTxId(pageRef, this.versionContext.committingTransactionId());
        }
    }

    private boolean isOldHead(VersionContext versionContext, long headVersion) {
        return headVersion != versionContext.committingTransactionId();
    }

    @Override
    long lockStamp() {
        return -1L;
    }

    @Override
    protected void convertPageFaultLock(long pageRef) {
        PageList.unlockExclusiveAndTakeWriteLock(pageRef);
        if (LOCKED_PAGES != null && this.multiVersioned) {
            LOCKED_PAGES.put(pageRef, Thread.currentThread().threadId());
        }
    }

    @Override
    public void setPageHorizon(long horizon) {
        if (this.multiVersioned && this.pinnedPageRef != 0L) {
            PageList.setPageHorizon(this.pinnedPageRef, horizon);
        }
    }

    @Override
    public boolean shouldRetry() {
        return false;
    }

    @Override
    public boolean retrySnapshot() {
        return false;
    }
}

