/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.pagecache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialPagedFile;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;

public class AdversarialPageCache
implements PageCache {
    private final PageCache delegate;
    private final Adversary adversary;

    public AdversarialPageCache(PageCache delegate, Adversary adversary) {
        this.delegate = Objects.requireNonNull(delegate);
        this.adversary = Objects.requireNonNull(adversary);
    }

    public PagedFile map(File file, int pageSize, OpenOption ... openOptions) throws IOException {
        if (ArrayUtils.contains((Object[])openOptions, (Object)StandardOpenOption.CREATE)) {
            this.adversary.injectFailure(IOException.class, SecurityException.class);
        } else {
            this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        }
        PagedFile pagedFile = this.delegate.map(file, pageSize, openOptions);
        return new AdversarialPagedFile(pagedFile, this.adversary);
    }

    public void flushAndForce() throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        this.delegate.flushAndForce();
    }

    public void flushAndForce(IOLimiter limiter) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        this.delegate.flushAndForce(limiter);
    }

    public void close() throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        this.delegate.close();
    }

    public int pageSize() {
        return this.delegate.pageSize();
    }

    public int maxCachedPages() {
        return this.delegate.maxCachedPages();
    }
}

