/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.pagecache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.adversaries.Adversary;
import org.neo4j.io.pagecache.PageCursor;

class AdversarialReadPageCursor
implements PageCursor {
    private final PageCursor delegate;
    private final Adversary adversary;
    private PageCursor linkedCursor;
    private boolean currentReadIsInconsistent;

    AdversarialReadPageCursor(PageCursor delegate, Adversary adversary) {
        this.delegate = Objects.requireNonNull(delegate);
        this.adversary = Objects.requireNonNull(adversary);
    }

    public byte getByte() {
        return this.currentReadIsInconsistent ? (byte)0 : this.delegate.getByte();
    }

    public byte getByte(int offset) {
        return this.currentReadIsInconsistent ? (byte)0 : this.delegate.getByte(offset);
    }

    public void putByte(byte value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void putByte(int offset, byte value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public long getLong() {
        long result = this.delegate.getLong();
        return this.currentReadIsInconsistent ? 0L : result;
    }

    public long getLong(int offset) {
        long result = this.delegate.getLong(offset);
        return this.currentReadIsInconsistent ? 0L : result;
    }

    public void putLong(long value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void putLong(int offset, long value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public int getInt() {
        int result = this.delegate.getInt();
        return this.currentReadIsInconsistent ? 0 : result;
    }

    public int getInt(int offset) {
        int result = this.delegate.getInt(offset);
        return this.currentReadIsInconsistent ? 0 : result;
    }

    public void putInt(int value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void putInt(int offset, int value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void getBytes(byte[] data) {
        this.delegate.getBytes(data);
        if (this.currentReadIsInconsistent) {
            ThreadLocalRandom.current().nextBytes(data);
        }
    }

    public void getBytes(byte[] data, int arrayOffset, int length) {
        this.delegate.getBytes(data, arrayOffset, length);
        if (this.currentReadIsInconsistent) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            for (int i = arrayOffset; i < length; ++i) {
                data[i] = (byte)rng.nextInt();
            }
        }
    }

    public void putBytes(byte[] data) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void putBytes(byte[] data, int arrayOffset, int length) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public short getShort() {
        return this.currentReadIsInconsistent ? (short)0 : this.delegate.getShort();
    }

    public short getShort(int offset) {
        return this.currentReadIsInconsistent ? (short)0 : this.delegate.getShort(offset);
    }

    public void putShort(short value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void putShort(int offset, short value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void setOffset(int offset) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.setOffset(offset);
    }

    public int getOffset() {
        return this.delegate.getOffset();
    }

    public long getCurrentPageId() {
        return this.delegate.getCurrentPageId();
    }

    public int getCurrentPageSize() {
        return this.delegate.getCurrentPageSize();
    }

    public File getCurrentFile() {
        return this.delegate.getCurrentFile();
    }

    public void rewind() {
        this.delegate.rewind();
    }

    public boolean next() throws IOException {
        this.currentReadIsInconsistent = this.adversary.injectFailureOrMischief(FileNotFoundException.class, IOException.class, SecurityException.class, IllegalStateException.class);
        return this.delegate.next();
    }

    public boolean next(long pageId) throws IOException {
        this.currentReadIsInconsistent = this.adversary.injectFailureOrMischief(FileNotFoundException.class, IOException.class, SecurityException.class, IllegalStateException.class);
        return this.delegate.next(pageId);
    }

    public void close() {
        this.delegate.close();
        this.linkedCursor = null;
    }

    public boolean shouldRetry() throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class, IllegalStateException.class);
        if (this.currentReadIsInconsistent) {
            this.currentReadIsInconsistent = false;
            this.delegate.shouldRetry();
            this.delegate.setOffset(0);
            return true;
        }
        boolean retry = this.delegate.shouldRetry();
        return retry || this.linkedCursor != null && this.linkedCursor.shouldRetry();
    }

    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        if (!this.currentReadIsInconsistent) {
            this.delegate.copyTo(sourceOffset, targetCursor, targetOffset, lengthInBytes);
        }
        return lengthInBytes;
    }

    public boolean checkAndClearBoundsFlag() {
        return this.delegate.checkAndClearBoundsFlag() || this.linkedCursor != null && this.linkedCursor.checkAndClearBoundsFlag();
    }

    public void raiseOutOfBounds() {
        this.delegate.raiseOutOfBounds();
    }

    public PageCursor openLinkedCursor(long pageId) {
        this.linkedCursor = new AdversarialReadPageCursor(this.delegate.openLinkedCursor(pageId), this.adversary);
        return this.linkedCursor;
    }
}

