/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.mockfs.SelectiveFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;

public class SelectiveFileSystemAbstractionTest {
    @Test
    public void shouldUseCorrectFileSystemForChosenFile() throws Exception {
        File specialFile = new File("special");
        FileSystemAbstraction normal = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        FileSystemAbstraction special = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        new SelectiveFileSystemAbstraction(specialFile, special, normal).open(specialFile, "r");
        ((FileSystemAbstraction)Mockito.verify((Object)special)).open(specialFile, "r");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{special});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{normal});
    }

    @Test
    public void shouldUseDefaultFileSystemForOtherFiles() throws Exception {
        File specialFile = new File("special");
        File otherFile = new File("other");
        FileSystemAbstraction normal = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        FileSystemAbstraction special = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        SelectiveFileSystemAbstraction fs = new SelectiveFileSystemAbstraction(specialFile, special, normal);
        fs.create(otherFile);
        fs.open(otherFile, "r");
        ((FileSystemAbstraction)Mockito.verify((Object)normal)).create(otherFile);
        ((FileSystemAbstraction)Mockito.verify((Object)normal)).open(otherFile, "r");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{special});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{normal});
    }
}

