/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.neo4j.io.pagecache.Page;

public class ByteBufferPage
implements Page {
    private static final MethodHandle addressOfMH = ByteBufferPage.addressOfMH();
    protected ByteBuffer buffer;

    private static MethodHandle addressOfMH() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Field addressField = Buffer.class.getDeclaredField("address");
            addressField.setAccessible(true);
            return lookup.unreflectGetter(addressField);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static long addressOf(Buffer buffer) {
        try {
            return addressOfMH.invokeExact(buffer);
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable);
        }
    }

    public ByteBufferPage(ByteBuffer buffer) {
        assert (ByteBufferPage.addressOf(buffer) != 0L) : "Probably not a DirectByteBuffer: " + buffer + " (address = " + ByteBufferPage.addressOf(buffer) + ")";
        this.buffer = buffer;
    }

    public byte getByte(int offset) {
        return this.buffer.get(offset);
    }

    public long getLong(int offset) {
        return this.buffer.getLong(offset);
    }

    public void putLong(long value, int offset) {
        this.buffer.putLong(offset, value);
    }

    public int getInt(int offset) {
        return this.buffer.getInt(offset);
    }

    public void putInt(int value, int offset) {
        this.buffer.putInt(offset, value);
    }

    public void getBytes(byte[] data, int pageOffset, int arrayOffset, int length) {
        for (int i = 0; i < length; ++i) {
            data[arrayOffset + i] = this.getByte(pageOffset + i);
        }
    }

    public void putBytes(byte[] data, int pageOffset, int arrayOffset, int length) {
        for (int i = 0; i < length; ++i) {
            this.putByte(data[arrayOffset + i], pageOffset + i);
        }
    }

    public void putByte(byte value, int offset) {
        this.buffer.put(offset, value);
    }

    public short getShort(int offset) {
        return this.buffer.getShort(offset);
    }

    public void putShort(short value, int offset) {
        this.buffer.putShort(offset, value);
    }

    public int size() {
        return this.buffer.capacity();
    }

    public long address() {
        return ByteBufferPage.addressOf(this.buffer);
    }
}

