/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.bootclasspathrunner;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashSet;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.neo4j.io.proc.ProcessUtil;
import org.neo4j.test.bootclasspathrunner.DelegatingRemoteRunNotifier;
import org.neo4j.test.bootclasspathrunner.DelegatingRunNotifier;
import org.neo4j.test.bootclasspathrunner.RemoteRunNotifier;
import org.neo4j.test.bootclasspathrunner.RmiServer;

public class BootClassPathRunner
extends Runner {
    private static final String RMI_RUN_NOTIFIER_NAME = "RunNotifier";
    private final Class<?> testClass;
    private final String classpathEntryToBootWith;

    public BootClassPathRunner(Class<?> testClass) throws Exception {
        this.testClass = testClass;
        BootEntryOf bootEntryOf = testClass.getAnnotation(BootEntryOf.class);
        Class<?> bootEntryOfClass = bootEntryOf.value();
        URL location = bootEntryOfClass.getProtectionDomain().getCodeSource().getLocation();
        this.classpathEntryToBootWith = location.getPath();
    }

    public Description getDescription() {
        try {
            BlockJUnit4ClassRunner describingRunner = new BlockJUnit4ClassRunner(this.testClass);
            return describingRunner.getDescription();
        }
        catch (InitializationError initializationError) {
            throw new RuntimeException(initializationError);
        }
    }

    public void run(RunNotifier notifier) {
        StringBuilder classpath = this.buildClassPath();
        try (RmiServer server = new RmiServer();){
            int port = server.getPort();
            server.export(RMI_RUN_NOTIFIER_NAME, new DelegatingRemoteRunNotifier(notifier));
            ArrayList<String> command = new ArrayList<String>();
            command.add(ProcessUtil.getJavaExecutable().toString());
            for (String argument : ProcessUtil.getJavaExecutableArguments()) {
                if (argument.startsWith("-agentlib")) continue;
                command.add(argument);
            }
            command.add("-ea");
            command.add("-Xbootclasspath/a:" + this.classpathEntryToBootWith);
            command.add("-cp");
            command.add(classpath.toString());
            command.add(((Object)((Object)this)).getClass().getName());
            command.add(String.valueOf(port));
            command.add(this.testClass.getName());
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(command);
            pb.inheritIO();
            Process process = pb.start();
            process.waitFor();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private StringBuilder buildClassPath() {
        HashSet classpathEntries = new HashSet();
        classpathEntries.addAll(ProcessUtil.getClassPathList());
        classpathEntries.remove(this.classpathEntryToBootWith);
        StringBuilder classpath = new StringBuilder();
        for (String classpathEntry : classpathEntries) {
            classpath.append(classpathEntry);
            classpath.append(File.pathSeparator);
        }
        classpath.setLength(classpath.length() - 1);
        return classpath;
    }

    public static void main(String[] args) throws Exception {
        int rmiPort = Integer.parseInt(args[0]);
        String testClassName = args[1];
        Class<?> testClass = Class.forName(testClassName);
        Registry registry = LocateRegistry.getRegistry(rmiPort);
        RemoteRunNotifier remote = (RemoteRunNotifier)registry.lookup(RMI_RUN_NOTIFIER_NAME);
        BlockJUnit4ClassRunner runner = new BlockJUnit4ClassRunner(testClass);
        runner.run((RunNotifier)new DelegatingRunNotifier(remote));
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BootEntryOf {
        public Class<?> value();
    }
}

