/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.test.ByteArrayMatcher;
import org.neo4j.test.RepeatRule;

public abstract class PageCacheTestSupport<T extends PageCache> {
    protected static final long SHORT_TIMEOUT_MILLIS = 10000L;
    protected static final long SEMI_LONG_TIMEOUT_MILLIS = 60000L;
    protected static final long LONG_TIMEOUT_MILLIS = 360000L;
    protected static ExecutorService executor;
    @Rule
    public RepeatRule repeatRule = new RepeatRule();
    protected int recordSize = 9;
    protected int maxPages = 20;
    protected int pageCachePageSize = 32;
    protected int recordsPerFilePage = this.pageCachePageSize / this.recordSize;
    protected int recordCount = 25 * this.maxPages * this.recordsPerFilePage;
    protected int filePageSize = this.recordsPerFilePage * this.recordSize;
    protected ByteBuffer bufA = ByteBuffer.allocate(this.recordSize);
    protected FileSystemAbstraction fs;
    protected T pageCache;
    private Fixture<T> fixture;

    @BeforeClass
    public static void startExecutor() {
        executor = Executors.newCachedThreadPool();
    }

    @AfterClass
    public static void stopExecutor() {
        executor.shutdown();
    }

    protected abstract Fixture<T> createFixture();

    @Before
    public void setUp() throws IOException {
        this.fixture = this.createFixture();
        Thread.interrupted();
        this.fs = this.createFileSystemAbstraction();
        this.ensureExists(this.file("a"));
    }

    @After
    public void tearDown() throws IOException {
        Thread.interrupted();
        if (this.pageCache != null) {
            this.tearDownPageCache(this.pageCache);
        }
        if (this.fs instanceof EphemeralFileSystemAbstraction) {
            ((EphemeralFileSystemAbstraction)this.fs).shutdown();
        }
    }

    protected final T createPageCache(PageSwapperFactory swapperFactory, int maxPages, int pageSize, PageCacheTracer tracer) {
        return this.fixture.createPageCache(swapperFactory, maxPages, pageSize, tracer);
    }

    protected T createPageCache(FileSystemAbstraction fs, int maxPages, int pageSize, PageCacheTracer tracer) {
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory();
        swapperFactory.setFileSystemAbstraction(fs);
        return this.createPageCache((PageSwapperFactory)swapperFactory, maxPages, pageSize, tracer);
    }

    protected final T getPageCache(FileSystemAbstraction fs, int maxPages, int pageSize, PageCacheTracer tracer) throws IOException {
        if (this.pageCache != null) {
            this.tearDownPageCache(this.pageCache);
        }
        this.pageCache = this.createPageCache(fs, maxPages, pageSize, tracer);
        return this.pageCache;
    }

    protected final void tearDownPageCache(T pageCache) throws IOException {
        this.fixture.tearDownPageCache(pageCache);
    }

    protected final FileSystemAbstraction createFileSystemAbstraction() {
        return this.fixture.getFileSystemAbstraction();
    }

    protected final File file(String pathname) {
        return this.fixture.file(pathname);
    }

    protected void ensureExists(File file) throws IOException {
        this.fs.create(file).close();
    }

    protected File existingFile(String name) throws IOException {
        File file = this.file(name);
        this.ensureExists(file);
        return file;
    }

    protected void verifyRecordsMatchExpected(PageCursor cursor) throws IOException {
        ByteBuffer expectedPageContents = ByteBuffer.allocate(this.filePageSize);
        ByteBuffer actualPageContents = ByteBuffer.allocate(this.filePageSize);
        byte[] record = new byte[this.recordSize];
        long pageId = cursor.getCurrentPageId();
        for (int i = 0; i < this.recordsPerFilePage; ++i) {
            long recordId = pageId * (long)this.recordsPerFilePage + (long)i;
            expectedPageContents.position(this.recordSize * i);
            PageCacheTestSupport.generateRecordForId(recordId, expectedPageContents.slice());
            do {
                cursor.setOffset(this.recordSize * i);
                cursor.getBytes(record);
            } while (cursor.shouldRetry());
            actualPageContents.position(this.recordSize * i);
            actualPageContents.put(record);
        }
        this.assertRecord(pageId, actualPageContents, expectedPageContents);
    }

    protected void assertRecord(long pageId, ByteBuffer actualPageContents, ByteBuffer expectedPageContents) {
        byte[] actualBytes = actualPageContents.array();
        byte[] expectedBytes = expectedPageContents.array();
        int estimatedPageId = this.estimateId(actualBytes);
        Assert.assertThat((String)("Page id: " + pageId + " " + "(based on record data, it should have been " + estimatedPageId + ", a difference of " + Math.abs(pageId - (long)estimatedPageId) + ")"), (Object)actualBytes, (Matcher)ByteArrayMatcher.byteArray(expectedBytes));
    }

    protected int estimateId(byte[] record) {
        return ByteBuffer.wrap(record).getInt() - 1;
    }

    protected void writeRecords(PageCursor cursor) {
        cursor.setOffset(0);
        for (int i = 0; i < this.recordsPerFilePage; ++i) {
            long recordId = cursor.getCurrentPageId() * (long)this.recordsPerFilePage + (long)i;
            PageCacheTestSupport.generateRecordForId(recordId, this.bufA);
            cursor.putBytes(this.bufA.array());
        }
    }

    protected void generateFileWithRecords(File file, int recordCount, int recordSize) throws IOException {
        StoreChannel channel = this.fs.open(file, "rw");
        ByteBuffer buf = ByteBuffer.allocate(recordSize);
        for (int i = 0; i < recordCount; ++i) {
            PageCacheTestSupport.generateRecordForId(i, buf);
            channel.writeAll(buf);
        }
        channel.close();
    }

    protected static void generateRecordForId(long id, ByteBuffer buf) {
        buf.position(0);
        int x = (int)(id + 1L);
        buf.putInt(x);
        while (buf.position() < buf.limit()) {
            buf.put((byte)(++x & 0xFF));
        }
        buf.position(0);
    }

    protected void verifyRecordsInFile(File file, int recordCount) throws IOException {
        StoreChannel channel = this.fs.open(file, "r");
        ByteBuffer buf = ByteBuffer.allocate(this.recordSize);
        ByteBuffer observation = ByteBuffer.allocate(this.recordSize);
        for (int i = 0; i < recordCount; ++i) {
            PageCacheTestSupport.generateRecordForId(i, buf);
            observation.position(0);
            channel.read(observation);
            this.assertRecord(i, observation, buf);
        }
        channel.close();
    }

    protected Runnable $close(PagedFile file) {
        return () -> {
            try {
                file.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    public static abstract class Fixture<T extends PageCache> {
        private Supplier<FileSystemAbstraction> fileSystemAbstractionSupplier = EphemeralFileSystemAbstraction::new;
        private Function<String, File> fileConstructor = File::new;

        public abstract T createPageCache(PageSwapperFactory var1, int var2, int var3, PageCacheTracer var4);

        public abstract void tearDownPageCache(T var1) throws IOException;

        public final FileSystemAbstraction getFileSystemAbstraction() {
            return this.fileSystemAbstractionSupplier.get();
        }

        public final Fixture<T> withFileSystemAbstraction(Supplier<FileSystemAbstraction> fileSystemAbstractionSupplier) {
            this.fileSystemAbstractionSupplier = fileSystemAbstractionSupplier;
            return this;
        }

        public final File file(String pathname) {
            return this.fileConstructor.apply(pathname);
        }

        public final Fixture<T> withFileConstructor(Function<String, File> fileConstructor) {
            this.fileConstructor = fileConstructor;
            return this;
        }
    }
}

