/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.AfterClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.pagecache.impl.muninn.DaemonThreadFactory;
import org.neo4j.io.pagecache.impl.muninn.SequenceLock;
import org.neo4j.io.pagecache.impl.muninn.SequenceLockTest;
import org.neo4j.test.RepeatRule;

public class SequenceLockStressIT {
    private static final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory());
    @Rule
    public RepeatRule repeatRule = new RepeatRule();
    private SequenceLock lock = new SequenceLock();

    @AfterClass
    public static void shutDownExecutor() {
        executor.shutdown();
    }

    @RepeatRule.Repeat(times=20)
    @Test
    public void stressTest() throws Exception {
        int i;
        final int[][] data = new int[10][10];
        final AtomicBoolean stop = new AtomicBoolean();
        final AtomicInteger writerId = new AtomicInteger();
        abstract class Worker
        implements Runnable {
            final /* synthetic */ AtomicBoolean val$stop;

            Worker() {
                this.val$stop = atomicBoolean;
            }

            @Override
            public void run() {
                try {
                    this.doWork();
                }
                finally {
                    this.val$stop.set(true);
                }
            }

            protected abstract void doWork();
        }
        Worker reader = new Worker(){
            {
                super(SequenceLockStressIT.this, atomicBoolean);
            }

            @Override
            protected void doWork() {
                while (!stop.get()) {
                    ThreadLocalRandom rng = ThreadLocalRandom.current();
                    int[] record = data[rng.nextInt(data.length)];
                    long stamp = SequenceLockStressIT.this.lock.tryOptimisticReadLock();
                    int value = record[0];
                    boolean consistent = true;
                    for (int i : record) {
                        consistent &= i == value;
                    }
                    if (SequenceLockStressIT.this.lock.validateReadLock(stamp) && !consistent) {
                        throw new AssertionError((Object)"inconsistent read");
                    }
                }
            }
        };
        Worker writer = new Worker(){
            private volatile long unused;
            {
                super(SequenceLockStressIT.this, atomicBoolean);
            }

            @Override
            protected void doWork() {
                int id = writerId.getAndIncrement();
                int counter = 1;
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                int smallSpin = rng.nextInt(5, 50);
                int bigSpin = rng.nextInt(100, 1000);
                while (!stop.get()) {
                    if (SequenceLockStressIT.this.lock.tryWriteLock()) {
                        int[] record = data[id];
                        for (int i = 0; i < record.length; ++i) {
                            record[i] = counter;
                            for (int j = 0; j < smallSpin; ++j) {
                                this.unused = rng.nextLong();
                            }
                        }
                        SequenceLockStressIT.this.lock.unlockWrite();
                    }
                    for (int j = 0; j < bigSpin; ++j) {
                        this.unused = rng.nextLong();
                    }
                }
            }
        };
        Worker exclusive = new Worker(){
            private volatile long unused;
            {
                super(SequenceLockStressIT.this, atomicBoolean);
            }

            @Override
            protected void doWork() {
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                int spin = rng.nextInt(20, 2000);
                while (!stop.get()) {
                    while (!SequenceLockStressIT.this.lock.tryExclusiveLock()) {
                    }
                    long sumA = 0L;
                    long sumB = 0L;
                    int[][] nArray = data;
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        int[] ints;
                        for (int i2 : ints = nArray[i]) {
                            sumA += (long)i2;
                        }
                    }
                    for (int i = 0; i < spin; ++i) {
                        this.unused = rng.nextLong();
                    }
                    for (int[] record : data) {
                        for (int value : record) {
                            sumB += (long)value;
                        }
                        Arrays.fill(record, 0);
                    }
                    SequenceLockStressIT.this.lock.unlockExclusive();
                    if (sumA != sumB) {
                        throw new AssertionError((Object)("Inconsistent exclusive lock. 'Sum A' = " + sumA + ", 'Sum B' = " + sumB));
                    }
                }
            }
        };
        ArrayList readers = new ArrayList();
        ArrayList writers = new ArrayList();
        Future<?> exclusiveFuture = executor.submit(exclusive);
        for (i = 0; i < 20; ++i) {
            readers.add(executor.submit(reader));
        }
        for (i = 0; i < data.length; ++i) {
            writers.add(executor.submit(writer));
        }
        long deadline = System.currentTimeMillis() + 1000L;
        while (!stop.get() && System.currentTimeMillis() < deadline) {
            Thread.sleep(20L);
        }
        stop.set(true);
        exclusiveFuture.get();
        for (Future future : writers) {
            future.get();
        }
        for (Future future : readers) {
            future.get();
        }
    }

    @Test
    public void thoroughlyEnsureAtomicityOfUnlockExclusiveAndTakeWriteLock() throws Exception {
        SequenceLockTest test = new SequenceLockTest();
        for (int i = 0; i < 30000; ++i) {
            test.unlockExclusiveAndTakeWriteLockMustBeAtomic();
            test.lock = new SequenceLock();
        }
    }
}

