/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.pagecache;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialReadPageCursor;
import org.neo4j.adversaries.pagecache.AdversarialWritePageCursor;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.PagedReadableByteChannel;
import org.neo4j.io.pagecache.impl.PagedWritableByteChannel;

public class AdversarialPagedFile
implements PagedFile {
    private final PagedFile delegate;
    private final Adversary adversary;

    public AdversarialPagedFile(PagedFile delegate, Adversary adversary) {
        this.delegate = Objects.requireNonNull(delegate);
        this.adversary = Objects.requireNonNull(adversary);
    }

    public PageCursor io(long pageId, int pf_flags) throws IOException {
        this.adversary.injectFailure(IllegalStateException.class);
        PageCursor pageCursor = this.delegate.io(pageId, pf_flags);
        if ((pf_flags & 1) == 1) {
            return new AdversarialReadPageCursor(pageCursor, this.adversary);
        }
        return new AdversarialWritePageCursor(pageCursor, this.adversary);
    }

    public int pageSize() {
        return this.delegate.pageSize();
    }

    public void flushAndForce() throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        this.delegate.flushAndForce();
    }

    public void flushAndForce(IOLimiter limiter) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        this.delegate.flushAndForce(limiter);
    }

    public long getLastPageId() throws IOException {
        this.adversary.injectFailure(IllegalStateException.class);
        return this.delegate.getLastPageId();
    }

    public void close() throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        this.delegate.close();
    }

    public ReadableByteChannel openReadableByteChannel() throws IOException {
        return new PagedReadableByteChannel((PagedFile)this);
    }

    public WritableByteChannel openWritableByteChannel() throws IOException {
        return new PagedWritableByteChannel((PagedFile)this);
    }
}

