/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.pagecache.impl.muninn.DaemonThreadFactory;
import org.neo4j.io.pagecache.impl.muninn.SequenceLock;

public class SequenceLockTest {
    private static final long TIMEOUT = 5000L;
    private static final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory());
    SequenceLock lock = new SequenceLock();

    @AfterClass
    public static void shutDownExecutor() {
        executor.shutdown();
    }

    @Test
    public void uncontendedOptimisticLockMustValidate() throws Exception {
        long stamp = this.lock.tryOptimisticReadLock();
        Assert.assertTrue((boolean)this.lock.validateReadLock(stamp));
    }

    @Test
    public void mustNotValidateRandomStamp() throws Exception {
        Assert.assertFalse((boolean)this.lock.validateReadLock(4242L));
    }

    @Test
    public void writeLockMustInvalidateOptimisticReadLock() throws Exception {
        long r = this.lock.tryOptimisticReadLock();
        this.lock.tryWriteLock();
        this.lock.unlockWrite();
        Assert.assertFalse((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void takingWriteLockMustInvalidateOptimisticReadLock() throws Exception {
        long r = this.lock.tryOptimisticReadLock();
        this.lock.tryWriteLock();
        Assert.assertFalse((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void optimisticReadLockMustNotValidateUnderWriteLock() throws Exception {
        this.lock.tryWriteLock();
        long r = this.lock.tryOptimisticReadLock();
        Assert.assertFalse((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void writeLockReleaseMustInvalidateOptimisticReadLock() throws Exception {
        this.lock.tryWriteLock();
        long r = this.lock.tryOptimisticReadLock();
        this.lock.unlockWrite();
        Assert.assertFalse((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void uncontendedWriteLockMustBeAvailable() throws Exception {
        Assert.assertTrue((boolean)this.lock.tryWriteLock());
    }

    @Test
    public void uncontendedOptimisticReadLockMustValidateAfterWriteLockRelease() throws Exception {
        this.lock.tryWriteLock();
        this.lock.unlockWrite();
        long r = this.lock.tryOptimisticReadLock();
        Assert.assertTrue((boolean)this.lock.validateReadLock(r));
    }

    @Test(timeout=5000L)
    public void writeLocksMustNotBlockOtherWriteLocks() throws Exception {
        Assert.assertTrue((boolean)this.lock.tryWriteLock());
        Assert.assertTrue((boolean)this.lock.tryWriteLock());
    }

    @Test(timeout=5000L)
    public void writeLocksMustNotBlockOtherWriteLocksInOtherThreads() throws Exception {
        int threads = 10;
        CountDownLatch end = new CountDownLatch(threads);
        Runnable runnable = () -> {
            Assert.assertTrue((boolean)this.lock.tryWriteLock());
            end.countDown();
        };
        ArrayList futures = new ArrayList();
        for (int i = 0; i < threads; ++i) {
            futures.add(executor.submit(runnable));
        }
        end.await();
        for (Future future : futures) {
            future.get();
        }
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void unmatchedUnlockWriteLockMustThrow() throws Exception {
        this.lock.unlockWrite();
    }

    @Test(expected=IllegalMonitorStateException.class, timeout=5000L)
    public void writeLockCountOverflowMustThrow() throws Exception {
        while (true) {
            Assert.assertTrue((boolean)this.lock.tryWriteLock());
        }
    }

    @Test
    public void exclusiveLockMustInvalidateOptimisticLock() throws Exception {
        long r = this.lock.tryOptimisticReadLock();
        this.lock.tryExclusiveLock();
        this.lock.unlockExclusive();
        Assert.assertFalse((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void takingExclusiveLockMustInvalidateOptimisticLock() throws Exception {
        long r = this.lock.tryOptimisticReadLock();
        this.lock.tryExclusiveLock();
        Assert.assertFalse((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void optimisticReadLockMustNotValidateUnderExclusiveLock() throws Exception {
        this.lock.tryExclusiveLock();
        long r = this.lock.tryOptimisticReadLock();
        Assert.assertFalse((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void exclusiveLockReleaseMustInvalidateOptimisticReadLock() throws Exception {
        this.lock.tryExclusiveLock();
        long r = this.lock.tryOptimisticReadLock();
        this.lock.unlockExclusive();
        Assert.assertFalse((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void uncontendedOptimisticReadLockMustValidateAfterExclusiveLockRelease() throws Exception {
        this.lock.tryExclusiveLock();
        this.lock.unlockExclusive();
        long r = this.lock.tryOptimisticReadLock();
        Assert.assertTrue((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void canTakeUncontendedExclusiveLocks() throws Exception {
        Assert.assertTrue((boolean)this.lock.tryExclusiveLock());
    }

    @Test
    public void writeLocksMustFailExclusiveLocks() throws Exception {
        this.lock.tryWriteLock();
        Assert.assertFalse((boolean)this.lock.tryExclusiveLock());
    }

    @Test
    public void concurrentWriteLocksMustFailExclusiveLocks() throws Exception {
        this.lock.tryWriteLock();
        this.lock.tryWriteLock();
        this.lock.unlockWrite();
        Assert.assertFalse((boolean)this.lock.tryExclusiveLock());
    }

    @Test
    public void exclusiveLockMustBeAvailableAfterWriteLock() throws Exception {
        this.lock.tryWriteLock();
        this.lock.unlockWrite();
        Assert.assertTrue((boolean)this.lock.tryExclusiveLock());
    }

    @Test
    public void cannotTakeExclusiveLockIfAlreadyTaken() throws Exception {
        Assert.assertTrue((boolean)this.lock.tryExclusiveLock());
        Assert.assertFalse((boolean)this.lock.tryExclusiveLock());
    }

    @Test
    public void exclusiveLockMustBeAvailableAfterExclusiveLock() throws Exception {
        Assert.assertTrue((boolean)this.lock.tryExclusiveLock());
        this.lock.unlockExclusive();
        Assert.assertTrue((boolean)this.lock.tryExclusiveLock());
    }

    @Test(timeout=5000L)
    public void exclusiveLockMustFailWriteLocks() throws Exception {
        this.lock.tryExclusiveLock();
        Assert.assertFalse((boolean)this.lock.tryWriteLock());
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void unmatchedUnlockExclusiveLockMustThrow() throws Exception {
        this.lock.unlockExclusive();
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void unmatchedUnlockWriteAfterTakingExclusiveLockMustThrow() throws Exception {
        this.lock.tryExclusiveLock();
        this.lock.unlockWrite();
    }

    @Test(timeout=5000L)
    public void writeLockMustBeAvailableAfterExclusiveLock() throws Exception {
        this.lock.tryExclusiveLock();
        this.lock.unlockExclusive();
        Assert.assertTrue((boolean)this.lock.tryWriteLock());
        this.lock.unlockWrite();
    }

    @Test
    public void unlockExclusiveMustReturnStampForOptimisticReadLock() throws Exception {
        this.lock.tryExclusiveLock();
        long r = this.lock.unlockExclusive();
        Assert.assertTrue((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void unlockExclusiveAndTakeWriteLockMustInvalidateOptimisticReadLocks() throws Exception {
        this.lock.tryExclusiveLock();
        this.lock.unlockExclusiveAndTakeWriteLock();
        long r = this.lock.tryOptimisticReadLock();
        Assert.assertFalse((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void unlockExclusiveAndTakeWriteLockMustPreventExclusiveLocks() throws Exception {
        this.lock.tryExclusiveLock();
        this.lock.unlockExclusiveAndTakeWriteLock();
        Assert.assertFalse((boolean)this.lock.tryExclusiveLock());
    }

    @Test(timeout=5000L)
    public void unlockExclusiveAndTakeWriteLockMustAllowConcurrentWriteLocks() throws Exception {
        this.lock.tryExclusiveLock();
        this.lock.unlockExclusiveAndTakeWriteLock();
        Assert.assertTrue((boolean)this.lock.tryWriteLock());
    }

    @Test(timeout=5000L)
    public void unlockExclusiveAndTakeWriteLockMustBeAtomic() throws Exception {
        int threads = Runtime.getRuntime().availableProcessors() - 1;
        CountDownLatch start = new CountDownLatch(threads);
        AtomicBoolean stop = new AtomicBoolean();
        this.lock.tryExclusiveLock();
        Runnable runnable = () -> {
            while (!stop.get()) {
                if (this.lock.tryExclusiveLock()) {
                    this.lock.unlockExclusive();
                    throw new RuntimeException("I should not have gotten that lock");
                }
                start.countDown();
            }
        };
        ArrayList futures = new ArrayList();
        for (int i = 0; i < threads; ++i) {
            futures.add(executor.submit(runnable));
        }
        start.await();
        this.lock.unlockExclusiveAndTakeWriteLock();
        stop.set(true);
        for (Future future : futures) {
            future.get();
        }
    }

    @Test
    public void stampFromUnlockExclusiveMustNotBeValidIfThereAreWriteLocks() throws Exception {
        this.lock.tryExclusiveLock();
        long r = this.lock.unlockExclusive();
        Assert.assertTrue((boolean)this.lock.tryWriteLock());
        Assert.assertFalse((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void uncontendedFlushLockMustBeAvailable() throws Exception {
        Assert.assertTrue((boolean)this.lock.tryFlushLock());
    }

    @Test
    public void flushLockMustNotInvalidateOptimisticReadLock() throws Exception {
        long r = this.lock.tryOptimisticReadLock();
        this.lock.tryFlushLock();
        this.lock.unlockFlush();
        Assert.assertTrue((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void flushLockMustNotFailWriteLock() throws Exception {
        this.lock.tryFlushLock();
        Assert.assertTrue((boolean)this.lock.tryWriteLock());
    }

    @Test
    public void flushLockMustFailExclusiveLock() throws Exception {
        this.lock.tryFlushLock();
        Assert.assertFalse((boolean)this.lock.tryExclusiveLock());
    }

    @Test
    public void cannotTakeFlushLockIfAlreadyTaken() throws Exception {
        Assert.assertTrue((boolean)this.lock.tryFlushLock());
        Assert.assertFalse((boolean)this.lock.tryFlushLock());
    }

    @Test
    public void writeLockMustNotFailFlushLock() throws Exception {
        this.lock.tryWriteLock();
        Assert.assertTrue((boolean)this.lock.tryFlushLock());
    }

    @Test
    public void exclusiveLockMustFailFlushLock() throws Exception {
        this.lock.tryExclusiveLock();
        Assert.assertFalse((boolean)this.lock.tryFlushLock());
    }

    @Test
    public void unlockExclusiveAndTakeWriteLockMustNotFailFlushLock() throws Exception {
        this.lock.tryExclusiveLock();
        this.lock.unlockExclusiveAndTakeWriteLock();
        Assert.assertTrue((boolean)this.lock.tryFlushLock());
    }

    @Test
    public void flushUnlockMustNotInvalidateOptimisticReadLock() throws Exception {
        long r = this.lock.tryOptimisticReadLock();
        Assert.assertTrue((boolean)this.lock.tryFlushLock());
        Assert.assertTrue((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void optimisticReadLockMustValidateUnderFlushLock() throws Exception {
        this.lock.tryFlushLock();
        long r = this.lock.tryOptimisticReadLock();
        Assert.assertTrue((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void flushLockReleaseMustNotInvalidateOptimisticReadLock() throws Exception {
        this.lock.tryFlushLock();
        long r = this.lock.tryOptimisticReadLock();
        this.lock.unlockFlush();
        Assert.assertTrue((boolean)this.lock.validateReadLock(r));
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void unmatchedUnlockFlushMustThrow() throws Exception {
        this.lock.unlockFlush();
    }

    @Test
    public void uncontendedOptimisticReadLockMustBeAvailableAfterFlushLock() throws Exception {
        this.lock.tryFlushLock();
        this.lock.unlockFlush();
        long r = this.lock.tryOptimisticReadLock();
        Assert.assertTrue((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void uncontendedWriteLockMustBeAvailableAfterFlushLock() throws Exception {
        this.lock.tryFlushLock();
        this.lock.unlockFlush();
        Assert.assertTrue((boolean)this.lock.tryWriteLock());
    }

    @Test
    public void uncontendedExclusiveLockMustBeAvailableAfterFlushLock() throws Exception {
        this.lock.tryFlushLock();
        this.lock.unlockFlush();
        Assert.assertTrue((boolean)this.lock.tryExclusiveLock());
    }

    @Test
    public void uncontendedFlushLockMustBeAvailableAfterWriteLock() throws Exception {
        this.lock.tryWriteLock();
        this.lock.unlockWrite();
        Assert.assertTrue((boolean)this.lock.tryFlushLock());
    }

    @Test
    public void uncontendedFlushLockMustBeAvailableAfterExclusiveLock() throws Exception {
        this.lock.tryExclusiveLock();
        this.lock.unlockExclusive();
        Assert.assertTrue((boolean)this.lock.tryFlushLock());
    }

    @Test
    public void uncontendedFlushLockMustBeAvailableAfterFlushLock() throws Exception {
        this.lock.tryFlushLock();
        this.lock.unlockFlush();
        Assert.assertTrue((boolean)this.lock.tryFlushLock());
    }

    @Test
    public void stampFromUnlockExclusiveMustBeValidUnderFlushLock() throws Exception {
        this.lock.tryExclusiveLock();
        long r = this.lock.unlockExclusive();
        this.lock.tryFlushLock();
        Assert.assertTrue((boolean)this.lock.validateReadLock(r));
    }

    @Test
    public void toStringMustDescribeState() throws Exception {
        Assert.assertThat((Object)this.lock.toString(), (Matcher)Matchers.is((Object)"SequenceLock[Flush: 0, Excl: 0, Ws: 0, S: 0]"));
        this.lock.tryWriteLock();
        Assert.assertThat((Object)this.lock.toString(), (Matcher)Matchers.is((Object)"SequenceLock[Flush: 0, Excl: 0, Ws: 1, S: 0]"));
        this.lock.tryFlushLock();
        Assert.assertThat((Object)this.lock.toString(), (Matcher)Matchers.is((Object)"SequenceLock[Flush: 1, Excl: 0, Ws: 1, S: 0]"));
        this.lock.unlockWrite();
        Assert.assertThat((Object)this.lock.toString(), (Matcher)Matchers.is((Object)"SequenceLock[Flush: 1, Excl: 0, Ws: 0, S: 1]"));
        this.lock.unlockFlush();
        Assert.assertThat((Object)this.lock.toString(), (Matcher)Matchers.is((Object)"SequenceLock[Flush: 0, Excl: 0, Ws: 0, S: 1]"));
        this.lock.tryExclusiveLock();
        Assert.assertThat((Object)this.lock.toString(), (Matcher)Matchers.is((Object)"SequenceLock[Flush: 0, Excl: 1, Ws: 0, S: 1]"));
        this.lock.unlockExclusive();
        Assert.assertThat((Object)this.lock.toString(), (Matcher)Matchers.is((Object)"SequenceLock[Flush: 0, Excl: 0, Ws: 0, S: 2]"));
    }
}

