/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.adversaries.RandomAdversary;
import org.neo4j.adversaries.pagecache.AdversarialPagedFile;
import org.neo4j.concurrent.BinaryLatch;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.DelegatingStoreChannel;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.DelegatingPageSwapper;
import org.neo4j.io.pagecache.FileHandle;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.FileIsMappedException;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.randomharness.Record;
import org.neo4j.io.pagecache.randomharness.StandardRecordFormat;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.test.ByteArrayMatcher;
import org.neo4j.test.RepeatRule;
import org.neo4j.test.ThreadTestUtils;

public abstract class PageCacheTest<T extends PageCache>
extends PageCacheTestSupport<T> {
    @BeforeClass
    public static void enablePinUnpinMonitoring() {
        DefaultPageCacheTracer.enablePinUnpinTracing();
    }

    @Test
    public void mustReportConfiguredMaxPages() throws IOException {
        this.configureStandardPageCache();
        Assert.assertThat((Object)this.pageCache.maxCachedPages(), (Matcher)Matchers.is((Object)this.maxPages));
    }

    @Test
    public void mustReportConfiguredCachePageSize() throws IOException {
        this.configureStandardPageCache();
        Assert.assertThat((Object)this.pageCache.pageSize(), (Matcher)Matchers.is((Object)this.pageCachePageSize));
    }

    @Test
    public void cachePageSizeMustBePowerOfTwo() throws IOException {
        this.expectedException.expect(IllegalArgumentException.class);
        this.getPageCache(this.fs, this.maxPages, 31, PageCacheTracer.NULL);
    }

    @Test
    public void mustHaveAtLeastTwoPages() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.getPageCache(this.fs, 1, this.pageCachePageSize, PageCacheTracer.NULL);
    }

    @Test
    public void mustAcceptTwoPagesAsMinimumConfiguration() throws Exception {
        this.getPageCache(this.fs, 2, this.pageCachePageSize, PageCacheTracer.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustClosePageSwapperFactoryOnPageCacheClose() throws Exception {
        block12: {
            final AtomicBoolean closed = new AtomicBoolean();
            SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory(){

                public void close() {
                    closed.set(true);
                }
            };
            Object cache = this.createPageCache((PageSwapperFactory)swapperFactory, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
            Exception exception = null;
            try {
                Assert.assertFalse((boolean)closed.get());
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                try {
                    cache.close();
                    Assert.assertTrue((boolean)closed.get());
                }
                catch (Exception e) {
                    if (exception == null) {
                        exception = e;
                    }
                    exception.addSuppressed(e);
                }
                if (exception == null) break block12;
                throw exception;
            }
        }
    }

    @Test
    public void closingOfPageCacheMustBeConsideredSuccessfulEvenIfPageSwapperFactoryCloseThrows() throws Exception {
        final AtomicInteger closed = new AtomicInteger();
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory(){

            public void close() {
                closed.getAndIncrement();
                throw new RuntimeException("boo");
            }
        };
        Object cache = this.createPageCache((PageSwapperFactory)swapperFactory, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try {
            cache.close();
            Assert.fail((String)"Should have thrown");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"boo"));
        }
        cache.close();
    }

    @Test(timeout=10000L)
    public void mustReadExistingData() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        int recordId = 0;
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
                this.verifyRecordsMatchExpected(cursor);
                recordId += this.recordsPerFilePage;
            }
        }
        Assert.assertThat((Object)recordId, (Matcher)Matchers.is((Object)this.recordCount));
    }

    @Test(timeout=10000L)
    public void mustScanInTheMiddleOfTheFile() throws IOException {
        long startPage = 10L;
        long endPage = this.recordCount / this.recordsPerFilePage - 10;
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        int recordId = (int)(startPage * (long)this.recordsPerFilePage);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(startPage, 1);){
            while (cursor.next() && cursor.getCurrentPageId() < endPage) {
                this.verifyRecordsMatchExpected(cursor);
                recordId += this.recordsPerFilePage;
            }
        }
        Assert.assertThat((Object)recordId, (Matcher)Matchers.is((Object)(this.recordCount - 10 * this.recordsPerFilePage)));
    }

    @Test(timeout=120000L)
    public void writesFlushedFromPageFileMustBeExternallyObservable() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        long startPageId = 0L;
        long endPageId = this.recordCount / this.recordsPerFilePage;
        try (PageCursor cursor = pagedFile.io(startPageId, 2);){
            while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                do {
                    this.writeRecords(cursor);
                } while (cursor.shouldRetry());
            }
        }
        pagedFile.flushAndForce();
        this.verifyRecordsInFile(this.file("a"), this.recordCount);
        pagedFile.close();
    }

    @Test
    public void pageCacheFlushAndForceMustThrowOnNullIOPSLimiter() throws Exception {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        this.expectedException.expect(IllegalArgumentException.class);
        cache.flushAndForce(null);
    }

    @Test
    public void pagedFileFlushAndForceMustThrowOnNullIOPSLimiter() throws Exception {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pf = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.expectedException.expect(IllegalArgumentException.class);
            pf.flushAndForce(null);
        }
    }

    @Test
    public void pageCacheFlushAndForceMustQueryTheGivenIOPSLimiter() throws Exception {
        int pagesToDirty = 10000;
        Object cache = this.getPageCache(this.fs, this.nextPowerOf2(2 * pagesToDirty), this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pfA = cache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
        PagedFile pfB = cache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);
        this.dirtyManyPages(pfA, pagesToDirty);
        this.dirtyManyPages(pfB, pagesToDirty);
        AtomicInteger callbackCounter = new AtomicInteger();
        AtomicInteger ioCounter = new AtomicInteger();
        cache.flushAndForce((previousStamp, recentlyCompletedIOs, swapper) -> {
            ioCounter.addAndGet(recentlyCompletedIOs);
            return callbackCounter.getAndIncrement();
        });
        pfA.close();
        pfB.close();
        Assert.assertThat((Object)callbackCounter.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)ioCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(pagesToDirty * 2 - 30)));
    }

    @Test
    public void pagedFileFlushAndForceMustQueryTheGivenIOPSLimiter() throws Exception {
        int pagesToDirty = 10000;
        Object cache = this.getPageCache(this.fs, this.nextPowerOf2(pagesToDirty), this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pf = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        this.dirtyManyPages(pf, pagesToDirty);
        AtomicInteger callbackCounter = new AtomicInteger();
        AtomicInteger ioCounter = new AtomicInteger();
        pf.flushAndForce((previousStamp, recentlyCompletedIOs, swapper) -> {
            ioCounter.addAndGet(recentlyCompletedIOs);
            return callbackCounter.getAndIncrement();
        });
        pf.close();
        Assert.assertThat((Object)callbackCounter.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)ioCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(pagesToDirty - 30)));
    }

    private void dirtyManyPages(PagedFile pf, int pagesToDirty) throws IOException {
        try (PageCursor cursor = pf.io(0L, 2);){
            for (int i = 0; i < pagesToDirty; ++i) {
                Assert.assertTrue((boolean)cursor.next());
            }
        }
    }

    @Test(timeout=120000L)
    public void repeatablyWritesFlushedFromPageFileMustBeExternallyObservable() throws IOException {
        for (int i = 0; i < 100; ++i) {
            this.tearDown();
            this.setUp();
            try {
                this.writesFlushedFromPageFileMustBeExternallyObservable();
                continue;
            }
            catch (Throwable e) {
                System.err.println("iteration " + i);
                System.err.flush();
                throw e;
            }
        }
    }

    @Test(timeout=360000L)
    public void writesFlushedFromPageFileMustBeObservableEvenWhenRacingWithEviction() throws IOException {
        Object cache = this.getPageCache(this.fs, 20, this.pageCachePageSize, PageCacheTracer.NULL);
        long startPageId = 0L;
        long endPageId = 21L;
        int iterations = 10000;
        int shortsPerPage = this.pageCachePageSize / 2;
        try (PagedFile pagedFile = cache.map(this.file("a"), this.pageCachePageSize, new OpenOption[0]);){
            for (int i = 1; i <= iterations; ++i) {
                try (PageCursor cursor = pagedFile.io(startPageId, 2);){
                    while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                        for (int j = 0; j < shortsPerPage; ++j) {
                            cursor.putShort((short)i);
                        }
                    }
                }
                pagedFile.flushAndForce();
                var12_12 = null;
                try (DataInputStream stream = new DataInputStream(this.fs.openAsInputStream(this.file("a")));){
                    for (int j = 0; j < shortsPerPage; ++j) {
                        short value = stream.readShort();
                        Assert.assertThat((String)("short pos = " + j + ", iteration = " + i), (Object)value, (Matcher)Matchers.is((Object)i));
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    var12_12 = throwable;
                    throw throwable;
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void writesFlushedFromPageCacheMustBeExternallyObservable() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        long startPageId = 0L;
        long endPageId = this.recordCount / this.recordsPerFilePage;
        File file = this.file("a");
        try (PagedFile pagedFile = cache.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(startPageId, 2);){
            while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                do {
                    this.writeRecords(cursor);
                } while (cursor.shouldRetry());
            }
        }
        this.verifyRecordsInFile(file, this.recordCount);
    }

    @Test(timeout=10000L)
    public void writesToPagesMustNotBleedIntoAdjacentPages() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            for (int i = 1; i <= 100; ++i) {
                Assert.assertTrue((boolean)cursor.next());
                for (int j = 0; j < this.filePageSize; ++j) {
                    cursor.putByte((byte)i);
                }
            }
        }
        InputStream inputStream = this.fs.openAsInputStream(this.file("a"));
        for (int i = 1; i <= 100; ++i) {
            for (int j = 0; j < this.filePageSize; ++j) {
                Assert.assertThat((Object)inputStream.read(), (Matcher)Matchers.is((Object)i));
            }
        }
        inputStream.close();
    }

    @Test
    public void channelMustBeForcedAfterPagedFileFlushAndForce() throws Exception {
        AtomicInteger writeCounter = new AtomicInteger();
        AtomicInteger forceCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = this.writeAndForceCountingFs(writeCounter, forceCounter);
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            pagedFile.flushAndForce();
            Assert.assertThat((Object)writeCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
            Assert.assertThat((Object)forceCounter.get(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test
    public void channelsMustBeForcedAfterPageCacheFlushAndForce() throws Exception {
        AtomicInteger writeCounter = new AtomicInteger();
        AtomicInteger forceCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = this.writeAndForceCountingFs(writeCounter, forceCounter);
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFileA = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PagedFile pagedFileB = this.pageCache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFileA.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            cursor = pagedFileB.io(0L, 2);
            var9_13 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            catch (Throwable throwable) {
                var9_13 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var9_13 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var9_13.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            this.pageCache.flushAndForce();
            Assert.assertThat((Object)writeCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3)));
            Assert.assertThat((Object)forceCounter.get(), (Matcher)Matchers.is((Object)2));
        }
    }

    private DelegatingFileSystemAbstraction writeAndForceCountingFs(final AtomicInteger writeCounter, final AtomicInteger forceCounter) {
        return new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        writeCounter.getAndIncrement();
                        super.writeAll(src, position);
                    }

                    @Override
                    public void force(boolean metaData) throws IOException {
                        forceCounter.getAndIncrement();
                        super.force(metaData);
                    }
                };
            }
        };
    }

    @Test(timeout=10000L)
    public void firstNextCallMustReturnFalseWhenTheFileIsEmptyAndNoGrowIsSpecified() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 6);){
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    @Test(timeout=10000L)
    public void nextMustReturnTrueThenFalseWhenThereIsOnlyOnePageInTheFileAndNoGrowIsSpecified() throws IOException {
        int numberOfRecordsToGenerate = this.recordsPerFilePage;
        this.generateFileWithRecords(this.file("a"), numberOfRecordsToGenerate, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 6);){
            Assert.assertTrue((boolean)cursor.next());
            this.verifyRecordsMatchExpected(cursor);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    @Test(timeout=10000L)
    public void closingWithoutCallingNextMustLeavePageUnpinnedAndUntouched() throws IOException {
        int numberOfRecordsToGenerate = this.recordsPerFilePage;
        this.generateFileWithRecords(this.file("a"), numberOfRecordsToGenerate, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            PageCursor ignore = pagedFile.io(0L, 2);
            Throwable throwable = null;
            if (ignore != null) {
                if (throwable != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignore.close();
                }
            }
            throwable = null;
            try (PageCursor cursor = pagedFile.io(0L, 1);){
                cursor.next();
                this.verifyRecordsMatchExpected(cursor);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    @Test
    public void nextWithNegativeInitialPageIdMustReturnFalse() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pf.io(-1L, 2);){
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = pf.io(-1L, 1);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test
    public void nextWithNegativePageIdMustReturnFalse() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);){
            long pageId = 12L;
            try (PageCursor cursor = pf.io(pageId, 2);){
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next(-1L));
                Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)-1L));
            }
            cursor = pf.io(pageId, 1);
            var7_8 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next(-1L));
                Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)-1L));
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var7_8 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var7_8.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=120000L)
    public void rewindMustStartScanningOverFromTheBeginning() throws IOException {
        int numberOfRewindsToTest = 10;
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        int actualPageCounter = 0;
        int filePageCount = this.recordCount / this.recordsPerFilePage;
        int expectedPageCounterResult = numberOfRewindsToTest * filePageCount;
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            for (int i = 0; i < numberOfRewindsToTest; ++i) {
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                    ++actualPageCounter;
                }
                cursor.rewind();
            }
        }
        Assert.assertThat((Object)actualPageCounter, (Matcher)Matchers.is((Object)expectedPageCounterResult));
    }

    @Test(timeout=10000L)
    public void mustCloseFileChannelWhenTheLastHandleIsUnmapped() throws Exception {
        Assume.assumeTrue((String)"This depends on EphemeralFSA specific features", (this.fs.getClass() == EphemeralFileSystemAbstraction.class ? 1 : 0) != 0);
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile a = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PagedFile b = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        a.close();
        b.close();
        ((EphemeralFileSystemAbstraction)this.fs).assertNoOpenFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void dirtyPagesMustBeFlushedWhenTheCacheIsClosed() throws IOException {
        this.configureStandardPageCache();
        long startPageId = 0L;
        long endPageId = this.recordCount / this.recordsPerFilePage;
        File file = this.file("a");
        try (PagedFile pagedFile = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(startPageId, 2);){
            while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                do {
                    this.writeRecords(cursor);
                } while (cursor.shouldRetry());
            }
        }
        finally {
            this.pageCache.close();
        }
        this.verifyRecordsInFile(file, this.recordCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatRule.Repeat(times=100)
    @Test(timeout=10000L)
    public void flushingDuringPagedFileCloseMustRetryUntilItSucceeds() throws IOException {
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){
                    private int writeCount;
                    {
                        this.writeCount = 0;
                    }

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        if (this.writeCount++ < 10) {
                            throw new IOException("This is a benign exception that we expect to be thrown during a flush of a PagedFile.");
                        }
                        super.writeAll(src, position);
                    }
                };
            }
        };
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PrintStream oldSystemErr = System.err;
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            this.writeRecords(cursor);
            System.setErr(new PrintStream(new ByteArrayOutputStream()));
        }
        finally {
            System.setErr(oldSystemErr);
        }
        this.verifyRecordsInFile(this.file("a"), this.recordsPerFilePage);
    }

    @Test(timeout=10000L)
    public void mappingFilesInClosedCacheMustThrow() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        cache.close();
        this.expectedException.expect(IllegalStateException.class);
        cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
    }

    @Test(timeout=10000L)
    public void flushingClosedCacheMustThrow() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        cache.close();
        this.expectedException.expect(IllegalStateException.class);
        cache.flushAndForce();
    }

    @Test(timeout=10000L)
    public void mappingFileWithPageSizeGreaterThanCachePageSizeMustThrow() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        this.expectedException.expect(IllegalArgumentException.class);
        cache.map(this.file("a"), this.pageCachePageSize + 1, new OpenOption[0]);
    }

    @Test(timeout=10000L)
    public void mappingFileWithPageSizeSmallerThanLongSizeBytesMustThrow() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        this.expectedException.expect(IllegalArgumentException.class);
        cache.map(this.file("a"), 7, new OpenOption[0]);
    }

    @Test(timeout=10000L)
    public void mappingFileWithPageSizeSmallerThanLongSizeBytesMustThrowEvenWithAnyPageSizeOpenOptionAndNoExistingMapping() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        this.expectedException.expect(IllegalArgumentException.class);
        cache.map(this.file("a"), 7, new OpenOption[]{PageCacheOpenOptions.ANY_PAGE_SIZE});
    }

    @Test(timeout=10000L)
    public void mappingFileWithPageZeroPageSizeMustThrowEvenWithExistingMapping() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        try (PagedFile oldMapping = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);){
            this.expectedException.expect(IllegalArgumentException.class);
            this.pageCache.map(file, 7, new OpenOption[0]);
        }
    }

    @Test(timeout=10000L)
    public void mappingFileWithPageZeroPageSizeAndAnyPageSizeOpenOptionMustNotThrowGivenExistingMapping() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        try (PagedFile oldMapping = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);){
            PagedFile newMapping = this.pageCache.map(file, 0, new OpenOption[]{PageCacheOpenOptions.ANY_PAGE_SIZE});
            Throwable throwable = null;
            if (newMapping != null) {
                if (throwable != null) {
                    try {
                        newMapping.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    newMapping.close();
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void mappingFileWithPageSizeEqualToCachePageSizeMustNotThrow() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = cache.map(this.file("a"), this.pageCachePageSize, new OpenOption[0]);
        pagedFile.close();
    }

    @Test(timeout=10000L)
    public void notSpecifyingAnyPfFlagsMustThrow() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.expectedException.expect(IllegalArgumentException.class);
            pagedFile.io(0L, 0);
        }
    }

    @Test(timeout=10000L)
    public void notSpecifyingAnyPfLockFlagsMustThrow() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.expectedException.expect(IllegalArgumentException.class);
            pagedFile.io(0L, 16);
        }
    }

    @Test(timeout=10000L)
    public void specifyingBothReadAndWriteLocksMustThrow() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.expectedException.expect(IllegalArgumentException.class);
            pagedFile.io(0L, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void mustNotPinPagesAfterNextReturnsFalse() throws Exception {
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch unpinLatch = new CountDownLatch(1);
        AtomicReference exceptionRef = new AtomicReference();
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage, this.recordSize);
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        Runnable runnable = () -> {
            try (PageCursor cursorA = pagedFile.io(0L, 6);){
                Assert.assertTrue((boolean)cursorA.next());
                Assert.assertFalse((boolean)cursorA.next());
                startLatch.countDown();
                unpinLatch.await();
                cursorA.close();
            }
            catch (Exception e) {
                exceptionRef.set(e);
            }
        };
        executor.submit(runnable);
        startLatch.await();
        try (PageCursor cursorB = pagedFile.io(1L, 2);){
            Assert.assertTrue((boolean)cursorB.next());
            unpinLatch.countDown();
        }
        finally {
            pagedFile.close();
        }
        Exception e = (Exception)exceptionRef.get();
        if (e != null) {
            throw new Exception("Child thread got exception", e);
        }
    }

    @Test(timeout=10000L)
    public void nextMustResetTheCursorOffset() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            do {
                cursor.setOffset(0);
                cursor.putByte((byte)1);
                cursor.putByte((byte)2);
                cursor.putByte((byte)3);
                cursor.putByte((byte)4);
            } while (cursor.shouldRetry());
            Assert.assertTrue((boolean)cursor.next());
            do {
                cursor.setOffset(0);
                cursor.putByte((byte)5);
                cursor.putByte((byte)6);
                cursor.putByte((byte)7);
                cursor.putByte((byte)8);
            } while (cursor.shouldRetry());
        }
        cursor = pagedFile.io(0L, 2);
        var4_4 = null;
        try {
            byte[] bytes = new byte[4];
            Assert.assertTrue((boolean)cursor.next());
            do {
                cursor.getBytes(bytes);
            } while (cursor.shouldRetry());
            Assert.assertThat((Object)bytes, (Matcher)ByteArrayMatcher.byteArray(1, 2, 3, 4));
            Assert.assertTrue((boolean)cursor.next());
            do {
                cursor.getBytes(bytes);
            } while (cursor.shouldRetry());
            Assert.assertThat((Object)bytes, (Matcher)ByteArrayMatcher.byteArray(5, 6, 7, 8));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var4_4 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        pagedFile.close();
    }

    @Test(timeout=10000L)
    public void nextMustAdvanceCurrentPageId() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)0L));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)1L));
        }
    }

    @Test(timeout=10000L)
    public void nextToSpecificPageIdMustAdvanceFromThatPointOn() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(1L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)1L));
            Assert.assertTrue((boolean)cursor.next(4L));
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)4L));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)5L));
        }
    }

    @Test(timeout=10000L)
    public void currentPageIdIsUnboundBeforeFirstNextAndAfterRewind() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)-1L));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)0L));
            cursor.rewind();
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)-1L));
        }
    }

    @Test(timeout=10000L)
    public void pageCursorMustKnowCurrentFilePageSize() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertThat((Object)cursor.getCurrentPageSize(), (Matcher)Matchers.is((Object)-1));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentPageSize(), (Matcher)Matchers.is((Object)this.filePageSize));
            cursor.rewind();
            Assert.assertThat((Object)cursor.getCurrentPageSize(), (Matcher)Matchers.is((Object)-1));
        }
    }

    @Test(timeout=10000L)
    public void pageCursorMustKnowCurrentFile() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertThat((Object)cursor.getCurrentFile(), (Matcher)Matchers.nullValue());
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentFile(), (Matcher)Matchers.is((Object)this.file("a")));
            cursor.rewind();
            Assert.assertThat((Object)cursor.getCurrentFile(), (Matcher)Matchers.nullValue());
        }
    }

    @Test(timeout=10000L)
    public void readingFromUnboundReadCursorMustThrow() throws IOException {
        this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkUnboundReadCursorAccess));
    }

    @Test(timeout=10000L)
    public void readingFromUnboundWriteCursorMustThrow() throws IOException {
        this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkUnboundWriteCursorAccess));
    }

    @Test(timeout=10000L)
    public void readingFromPreviouslyBoundCursorMustThrow() throws IOException {
        this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundWriteCursorAccess));
    }

    @Test(timeout=10000L)
    public void writingToUnboundCursorMustThrow() throws IOException {
        this.verifyOnWriteCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkUnboundWriteCursorAccess));
    }

    @Test(timeout=10000L)
    public void writingToPreviouslyBoundCursorMustThrow() throws IOException {
        this.verifyOnWriteCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundWriteCursorAccess));
    }

    @Test(timeout=10000L)
    public void readFromReadCursorAfterNextReturnsFalseMustThrow() throws Exception {
        this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkReadCursorAfterFailedNext));
    }

    @Test(timeout=10000L)
    public void readFromPreviouslyBoundReadCursorAfterNextReturnsFalseMustThrow() throws Exception {
        this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundReadCursorAfterFailedNext));
    }

    @Test(timeout=10000L)
    public void readFromWriteCursorAfterNextReturnsFalseMustThrow() throws Exception {
        this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkWriteCursorAfterFailedNext));
    }

    @Test(timeout=10000L)
    public void readFromPreviouslyBoundWriteCursorAfterNextReturnsFalseMustThrow() throws Exception {
        this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundWriteCursorAfterFailedNext));
    }

    @Test(timeout=10000L)
    public void writeAfterNextReturnsFalseMustThrow() throws Exception {
        this.verifyOnWriteCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkWriteCursorAfterFailedNext));
    }

    @Test(timeout=10000L)
    public void writeToPreviouslyBoundCursorAfterNextReturnsFalseMustThrow() throws Exception {
        this.verifyOnWriteCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundWriteCursorAfterFailedNext));
    }

    @Test
    public void tryMappedPagedFileShouldReportMappedFilePresent() throws Exception {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        File file = this.file("a");
        try (PagedFile pf = cache.map(file, this.filePageSize, new OpenOption[0]);){
            Optional optional = cache.getExistingMapping(file);
            Assert.assertTrue((boolean)optional.isPresent());
            PagedFile actual = (PagedFile)optional.get();
            Assert.assertThat((Object)actual, (Matcher)Matchers.sameInstance((Object)pf));
            actual.close();
        }
    }

    @Test
    public void tryMappedPagedFileShouldReportNonMappedFileNotPresent() throws Exception {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        Optional dont_exist = cache.getExistingMapping(new File("dont_exist"));
        Assert.assertFalse((boolean)dont_exist.isPresent());
    }

    private void verifyOnReadCursor(ThrowingConsumer<PageCursorAction, IOException> testTemplate) throws IOException {
        testTemplate.accept(PageCursor::getByte);
        testTemplate.accept(PageCursor::getInt);
        testTemplate.accept(PageCursor::getLong);
        testTemplate.accept(PageCursor::getShort);
        testTemplate.accept(cursor -> cursor.getByte(0));
        testTemplate.accept(cursor -> cursor.getInt(0));
        testTemplate.accept(cursor -> cursor.getLong(0));
        testTemplate.accept(cursor -> cursor.getShort(0));
    }

    private void verifyOnWriteCursor(ThrowingConsumer<PageCursorAction, IOException> testTemplate) throws IOException {
        testTemplate.accept(cursor -> cursor.putByte((byte)1));
        testTemplate.accept(cursor -> cursor.putInt(1));
        testTemplate.accept(cursor -> cursor.putLong(1L));
        testTemplate.accept(cursor -> cursor.putShort((short)1));
        testTemplate.accept(cursor -> cursor.putByte(0, (byte)1));
        testTemplate.accept(cursor -> cursor.putInt(0, 1));
        testTemplate.accept(cursor -> cursor.putLong(0, 1L));
        testTemplate.accept(cursor -> cursor.putShort(0, (short)1));
    }

    private void checkUnboundReadCursorAccess(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            action.apply(cursor);
            Assert.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkUnboundWriteCursorAccess(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            action.apply(cursor);
            Assert.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkPreviouslyBoundWriteCursorAccess(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            PageCursor cursor = pagedFile.io(0L, 2);
            Assert.assertTrue((boolean)cursor.next());
            action.apply(cursor);
            Assert.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
            cursor.close();
            action.apply(cursor);
            Assert.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkReadCursorAfterFailedNext(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            Assert.assertFalse((boolean)cursor.next());
            action.apply(cursor);
            Assert.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkPreviouslyBoundReadCursorAfterFailedNext(PageCursorAction action) throws IOException {
        Throwable throwable;
        PageCursor cursor;
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            cursor = pagedFile.io(0L, 2);
            throwable = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        var3_3 = null;
        try {
            cursor = pagedFile.io(0L, 1);
            throwable = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
                action.apply(cursor);
                Assert.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var3_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (pagedFile != null) {
                if (var3_3 != null) {
                    try {
                        pagedFile.close();
                    }
                    catch (Throwable throwable7) {
                        var3_3.addSuppressed(throwable7);
                    }
                } else {
                    pagedFile.close();
                }
            }
        }
    }

    private void checkWriteCursorAfterFailedNext(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 6);){
            Assert.assertFalse((boolean)cursor.next());
            action.apply(cursor);
            Assert.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkPreviouslyBoundWriteCursorAfterFailedNext(PageCursorAction action) throws IOException {
        Throwable throwable;
        PageCursor cursor;
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            cursor = pagedFile.io(0L, 2);
            throwable = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        var3_3 = null;
        try {
            cursor = pagedFile.io(0L, 6);
            throwable = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
                action.apply(cursor);
                Assert.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var3_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (pagedFile != null) {
                if (var3_3 != null) {
                    try {
                        pagedFile.close();
                    }
                    catch (Throwable throwable7) {
                        var3_3.addSuppressed(throwable7);
                    }
                } else {
                    pagedFile.close();
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void lastPageMustBeAccessibleWithNoGrowSpecified() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = pagedFile.io(0L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 6);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(2L, 6);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(2L, 1);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(3L, 6);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(3L, 1);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void lastPageMustBeAccessibleWithNoGrowSpecifiedEvenIfLessThanFilePageSize() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2 - 1, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = pagedFile.io(0L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 6);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(2L, 6);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(2L, 1);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(3L, 6);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(3L, 1);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void firstPageMustBeAccessibleWithNoGrowSpecifiedIfItIsTheOnlyPage() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage, this.recordSize);
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = pagedFile.io(0L, 1);
            var5_7 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 6);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 1);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void firstPageMustBeAccessibleEvenIfTheFileIsNonEmptyButSmallerThanFilePageSize() throws IOException {
        this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = pagedFile.io(0L, 1);
            var5_7 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 6);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 1);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void firstPageMustNotBeAccessibleIfFileIsEmptyAndNoGrowSpecified() throws IOException {
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assert.assertFalse((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = pagedFile.io(0L, 1);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 6);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 1);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void newlyWrittenPagesMustBeAccessibleWithNoGrow() throws IOException {
        int initialPages = 1;
        int pagesToAdd = 3;
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * initialPages, this.recordSize);
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(1L, 2);){
            for (int i = 0; i < pagesToAdd; ++i) {
                Assert.assertTrue((boolean)cursor.next());
                do {
                    this.writeRecords(cursor);
                } while (cursor.shouldRetry());
            }
        }
        int pagesChecked = 0;
        try (PageCursor cursor = pagedFile.io(0L, 6);){
            while (cursor.next()) {
                this.verifyRecordsMatchExpected(cursor);
                ++pagesChecked;
            }
        }
        Assert.assertThat((Object)pagesChecked, (Matcher)Matchers.is((Object)(initialPages + pagesToAdd)));
        pagesChecked = 0;
        cursor = pagedFile.io(0L, 1);
        var7_11 = null;
        try {
            while (cursor.next()) {
                this.verifyRecordsMatchExpected(cursor);
                ++pagesChecked;
            }
        }
        catch (Throwable throwable) {
            var7_11 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var7_11 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable) {
                        var7_11.addSuppressed(throwable);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        Assert.assertThat((Object)pagesChecked, (Matcher)Matchers.is((Object)(initialPages + pagesToAdd)));
        pagedFile.close();
    }

    @Test(timeout=10000L)
    public void readLockImpliesNoGrow() throws IOException {
        int initialPages = 3;
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * initialPages, this.recordSize);
        this.configureStandardPageCache();
        int pagesChecked = 0;
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
                ++pagesChecked;
            }
        }
        Assert.assertThat((Object)pagesChecked, (Matcher)Matchers.is((Object)initialPages));
    }

    @Test
    public void retryMustResetCursorOffset() throws Exception {
        int i;
        Object cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        AtomicReference caughtWriterException = new AtomicReference();
        CountDownLatch startLatch = new CountDownLatch(1);
        int expectedByte = 13;
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            if (cursor.next()) {
                do {
                    cursor.putByte((byte)13);
                    Thread.yield();
                } while (cursor.shouldRetry());
            }
        }
        AtomicBoolean end = new AtomicBoolean(false);
        Runnable writer = () -> {
            while (!end.get()) {
                try {
                    PageCursor cursor = pagedFile.io(0L, 2);
                    Throwable throwable = null;
                    try {
                        if (cursor.next()) {
                            do {
                                cursor.setOffset(this.recordSize);
                                cursor.putByte((byte)14);
                            } while (cursor.shouldRetry());
                        }
                        startLatch.countDown();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (cursor == null) continue;
                        if (throwable != null) {
                            try {
                                cursor.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        cursor.close();
                    }
                }
                catch (IOException e) {
                    caughtWriterException.set(e);
                    throw new RuntimeException(e);
                }
            }
        };
        Future<?> writerFuture = executor.submit(writer);
        startLatch.await();
        long timeout = System.currentTimeMillis() + 10000L;
        for (i = 0; i < 1000 && System.currentTimeMillis() < timeout; ++i) {
            try (PageCursor cursor = pagedFile.io(0L, 1);){
                Assert.assertTrue((boolean)cursor.next());
                do {
                    Assert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)13));
                } while (cursor.shouldRetry() && System.currentTimeMillis() < timeout);
                continue;
            }
        }
        end.set(true);
        writerFuture.get();
        Assert.assertTrue((i > 1 ? 1 : 0) != 0);
        pagedFile.close();
    }

    @Test(timeout=10000L)
    public void nextWithPageIdMustAllowTraversingInReverse() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        long lastFilePageId = this.recordCount / this.recordsPerFilePage - 1;
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            for (long currentPageId = lastFilePageId; currentPageId >= 0L; --currentPageId) {
                Assert.assertTrue((String)("next( currentPageId = " + currentPageId + " )"), (boolean)cursor.next(currentPageId));
                Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)currentPageId));
                this.verifyRecordsMatchExpected(cursor);
            }
        }
    }

    @Test(timeout=10000L)
    public void nextWithPageIdMustReturnFalseIfPageIdIsBeyondFilePageRangeAndNoGrowSpecified() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assert.assertFalse((boolean)cursor.next(2L));
                Assert.assertTrue((boolean)cursor.next(1L));
            }
            cursor = pagedFile.io(0L, 1);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next(2L));
                Assert.assertTrue((boolean)cursor.next(1L));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void pagesAddedWithNextWithPageIdMustBeAccessibleWithNoGrowSpecified() throws IOException {
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next(2L));
            do {
                this.writeRecords(cursor);
            } while (cursor.shouldRetry());
            Assert.assertTrue((boolean)cursor.next(0L));
            do {
                this.writeRecords(cursor);
            } while (cursor.shouldRetry());
            Assert.assertTrue((boolean)cursor.next(1L));
            do {
                this.writeRecords(cursor);
            } while (cursor.shouldRetry());
        }
        cursor = pagedFile.io(0L, 6);
        var3_3 = null;
        try {
            while (cursor.next()) {
                this.verifyRecordsMatchExpected(cursor);
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var3_3 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        cursor = pagedFile.io(0L, 1);
        var3_3 = null;
        try {
            while (cursor.next()) {
                this.verifyRecordsMatchExpected(cursor);
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var3_3 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        pagedFile.close();
    }

    @Test(timeout=10000L)
    public void writesOfDifferentUnitsMustHaveCorrectEndianess() throws Exception {
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), 20, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            byte[] data = new byte[]{42, 43, 44, 45, 46};
            cursor.putLong(41L);
            cursor.putInt(41);
            cursor.putShort((short)41);
            cursor.putByte((byte)41);
            cursor.putBytes(data);
        }
        cursor = pagedFile.io(0L, 2);
        var3_3 = null;
        try {
            Assert.assertTrue((boolean)cursor.next());
            long a = cursor.getLong();
            int b = cursor.getInt();
            short c = cursor.getShort();
            byte[] data = new byte[]{cursor.getByte(), cursor.getByte(), cursor.getByte(), cursor.getByte(), cursor.getByte(), cursor.getByte()};
            cursor.setOffset(0);
            cursor.putLong(1L + a);
            cursor.putInt(1 + b);
            cursor.putShort((short)(1 + c));
            for (byte d : data) {
                d = (byte)(d + 1);
                cursor.putByte(d);
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var3_3 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        pagedFile.close();
        StoreChannel channel = this.fs.open(this.file("a"), "r");
        ByteBuffer buf = ByteBuffer.allocate(20);
        channel.read(buf);
        buf.flip();
        Assert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)42L));
        Assert.assertThat((Object)buf.getInt(), (Matcher)Matchers.is((Object)42));
        Assert.assertThat((Object)buf.getShort(), (Matcher)Matchers.is((Object)42));
        Assert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)42));
        Assert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)43));
        Assert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)44));
        Assert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)45));
        Assert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)46));
        Assert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)47));
    }

    @Test(timeout=10000L)
    public void mappingFileSecondTimeWithLesserPageSizeMustThrow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile ignore = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.expectedException.expect(IllegalArgumentException.class);
            this.pageCache.map(this.file("a"), this.filePageSize - 1, new OpenOption[0]);
        }
    }

    @Test(timeout=10000L)
    public void mappingFileSecondTimeWithGreaterPageSizeMustThrow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile ignore = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.expectedException.expect(IllegalArgumentException.class);
            this.pageCache.map(this.file("a"), this.filePageSize + 1, new OpenOption[0]);
        }
    }

    @Test(timeout=10000L)
    public void allowOpeningMultipleReadAndWriteCursorsPerThread() throws Exception {
        this.configureStandardPageCache();
        File fileA = this.existingFile("a");
        File fileB = this.existingFile("b");
        this.generateFileWithRecords(fileA, 1, 16);
        this.generateFileWithRecords(fileB, 1, 16);
        try (PagedFile pfA = this.pageCache.map(fileA, this.filePageSize, new OpenOption[0]);
             PagedFile pfB = this.pageCache.map(fileB, this.filePageSize, new OpenOption[0]);
             PageCursor a = pfA.io(0L, 1);
             PageCursor b = pfA.io(0L, 1);
             PageCursor c = pfA.io(0L, 2);
             PageCursor d = pfA.io(0L, 2);
             PageCursor e = pfB.io(0L, 1);
             PageCursor f = pfB.io(0L, 1);
             PageCursor g = pfB.io(0L, 2);
             PageCursor h = pfB.io(0L, 2);){
            Assert.assertTrue((boolean)a.next());
            Assert.assertTrue((boolean)b.next());
            Assert.assertTrue((boolean)c.next());
            Assert.assertTrue((boolean)d.next());
            Assert.assertTrue((boolean)e.next());
            Assert.assertTrue((boolean)f.next());
            Assert.assertTrue((boolean)g.next());
            Assert.assertTrue((boolean)h.next());
        }
    }

    @Test(timeout=120000L)
    public void mustNotLiveLockIfWeRunOutOfEvictablePages() throws Exception {
        this.configureStandardPageCache();
        LinkedList<PageCursor> cursors = new LinkedList<PageCursor>();
        PagedFile pf = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
        Throwable throwable = null;
        try {
            try {
                try {
                    this.expectedException.expect(IOException.class);
                    long i = 0L;
                    while (true) {
                        PageCursor cursor = pf.io(i, 2);
                        cursors.add(cursor);
                        Assert.assertTrue((boolean)cursor.next());
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    cursors.forEach(PageCursor::close);
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            if (pf != null) {
                if (throwable != null) {
                    try {
                        pf.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    pf.close();
                }
            }
            throw throwable4;
        }
    }

    @Test(timeout=10000L)
    public void writeLocksMustNotBeExclusive() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            executor.submit(() -> {
                try (PageCursor innerCursor = pf.io(0L, 2);){
                    Assert.assertTrue((boolean)innerCursor.next());
                }
                return null;
            }).get();
        }
    }

    @Test(timeout=10000L)
    public void writeLockMustInvalidateInnerReadLock() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            executor.submit(() -> {
                try (PageCursor innerCursor = pf.io(0L, 1);){
                    Assert.assertTrue((boolean)innerCursor.next());
                    Assert.assertTrue((boolean)innerCursor.shouldRetry());
                }
                return null;
            }).get();
        }
    }

    @Test(timeout=10000L)
    public void writeLockMustInvalidateExistingReadLock() throws Exception {
        this.configureStandardPageCache();
        BinaryLatch startLatch = new BinaryLatch();
        BinaryLatch continueLatch = new BinaryLatch();
        try (PagedFile pf = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertTrue((boolean)cursor.next());
            Future<Object> read = executor.submit(() -> {
                try (PageCursor innerCursor = pf.io(0L, 1);){
                    Assert.assertTrue((boolean)innerCursor.next());
                    Assert.assertFalse((boolean)innerCursor.shouldRetry());
                    startLatch.release();
                    continueLatch.await();
                    Assert.assertTrue((boolean)innerCursor.shouldRetry());
                }
                return null;
            });
            startLatch.await();
            Assert.assertTrue((boolean)cursor.next(0L));
            continueLatch.release();
            read.get();
        }
    }

    @Test(timeout=10000L)
    public void writeUnlockMustInvalidateReadLocks() throws Exception {
        this.configureStandardPageCache();
        BinaryLatch startLatch = new BinaryLatch();
        BinaryLatch continueLatch = new BinaryLatch();
        try (PagedFile pf = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            Future<Object> read = executor.submit(() -> {
                try (PageCursor innerCursor = pf.io(0L, 1);){
                    Assert.assertTrue((boolean)innerCursor.next());
                    Assert.assertTrue((boolean)innerCursor.shouldRetry());
                    startLatch.release();
                    continueLatch.await();
                    Assert.assertTrue((boolean)innerCursor.shouldRetry());
                }
                return null;
            });
            startLatch.await();
            Assert.assertTrue((boolean)cursor.next());
            continueLatch.release();
            read.get();
        }
    }

    @Test(timeout=10000L)
    public void mustNotFlushCleanPagesWhenEvicting() throws Exception {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        final AtomicBoolean observedWrite = new AtomicBoolean();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                StoreChannel channel = super.open(fileName, mode);
                return new DelegatingStoreChannel(channel){

                    @Override
                    public int write(ByteBuffer src, long position) throws IOException {
                        observedWrite.set(true);
                        throw new IOException("not allowed");
                    }

                    @Override
                    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                        observedWrite.set(true);
                        throw new IOException("not allowed");
                    }

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        observedWrite.set(true);
                        throw new IOException("not allowed");
                    }

                    @Override
                    public void writeAll(ByteBuffer src) throws IOException {
                        observedWrite.set(true);
                        throw new IOException("not allowed");
                    }

                    @Override
                    public int write(ByteBuffer src) throws IOException {
                        observedWrite.set(true);
                        throw new IOException("not allowed");
                    }

                    @Override
                    public long write(ByteBuffer[] srcs) throws IOException {
                        observedWrite.set(true);
                        throw new IOException("not allowed");
                    }
                };
            }
        };
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
                this.verifyRecordsMatchExpected(cursor);
            }
        }
        Assert.assertFalse((boolean)observedWrite.get());
    }

    @Test(timeout=10000L)
    public void evictionMustFlushPagesToTheRightFiles() throws IOException {
        boolean cursorReady2;
        boolean cursorReady1;
        boolean moreWorkToDo;
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        int filePageSize2 = this.filePageSize - 3;
        long maxPageIdCursor1 = this.recordCount / this.recordsPerFilePage;
        File file2 = this.file("b");
        OutputStream outputStream = this.fs.openAsOutputStream(file2, false);
        long file2sizeBytes = (maxPageIdCursor1 + 17L) * (long)filePageSize2;
        int i = 0;
        while ((long)i < file2sizeBytes) {
            outputStream.write(97);
            ++i;
        }
        outputStream.flush();
        outputStream.close();
        this.configureStandardPageCache();
        PagedFile pagedFile1 = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PagedFile pagedFile2 = this.pageCache.map(file2, filePageSize2, new OpenOption[0]);
        long pageId1 = 0L;
        long pageId2 = 0L;
        do {
            try (PageCursor cursor = pagedFile1.io(pageId1, 2);){
                boolean bl = cursorReady1 = cursor.next() && cursor.getCurrentPageId() < maxPageIdCursor1;
                if (cursorReady1) {
                    this.writeRecords(cursor);
                    ++pageId1;
                }
            }
            cursor = pagedFile2.io(pageId2, 6);
            var18_20 = null;
            try {
                cursorReady2 = cursor.next();
                if (cursorReady2) {
                    do {
                        for (int i2 = 0; i2 < filePageSize2; ++i2) {
                            cursor.putByte((byte)98);
                        }
                    } while (cursor.shouldRetry());
                }
                ++pageId2;
            }
            catch (Throwable throwable) {
                var18_20 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var18_20 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var18_20.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        } while (moreWorkToDo = cursorReady1 || cursorReady2);
        pagedFile1.close();
        pagedFile2.close();
        Assert.assertThat((Object)this.fs.getFileSize(file2), (Matcher)Matchers.is((Object)file2sizeBytes));
        InputStream inputStream = this.fs.openAsInputStream(file2);
        int i3 = 0;
        while ((long)i3 < file2sizeBytes) {
            int b = inputStream.read();
            Assert.assertThat((Object)b, (Matcher)Matchers.is((Object)98));
            ++i3;
        }
        Assert.assertThat((Object)inputStream.read(), (Matcher)Matchers.is((Object)-1));
        inputStream.close();
        StoreChannel channel = this.fs.open(this.file("a"), "r");
        ByteBuffer bufB = ByteBuffer.allocate(this.recordSize);
        for (int i4 = 0; i4 < this.recordCount; ++i4) {
            this.bufA.clear();
            channel.read(this.bufA);
            this.bufA.flip();
            bufB.clear();
            PageCacheTest.generateRecordForId(i4, bufB);
            Assert.assertThat((Object)bufB.array(), (Matcher)ByteArrayMatcher.byteArray(this.bufA.array()));
        }
    }

    @Test(timeout=10000L)
    public void tracerMustBeNotifiedAboutPinUnpinFaultAndEvictEventsWhenReading() throws IOException {
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, (PageCacheTracer)tracer);
        long countedPages = 0L;
        long countedFaults = 0L;
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            int i;
            while (cursor.next()) {
                ++countedPages;
                ++countedFaults;
            }
            ++countedPages;
            for (i = 0; i < 20; ++i) {
                Assert.assertTrue((boolean)cursor.next(1L));
            }
            for (i = 0; i < 20; ++i) {
                Assert.assertTrue((boolean)cursor.next((long)i));
                ++countedPages;
            }
        }
        Assert.assertThat((String)"wrong count of pins", (Object)tracer.pins(), (Matcher)Matchers.is((Object)countedPages));
        Assert.assertThat((String)"wrong count of unpins", (Object)tracer.unpins(), (Matcher)Matchers.is((Object)countedPages));
        long faults = tracer.faults();
        long bytesRead = tracer.bytesRead();
        Assert.assertThat((String)"wrong count of faults", (Object)faults, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(countedFaults)));
        Assert.assertThat((String)"wrong number of bytes read", (Object)bytesRead, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(countedFaults * (long)this.filePageSize)));
        Assert.assertThat((String)"wrong count of evictions", (Object)tracer.evictions(), (Matcher)Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(countedFaults - (long)this.maxPages))).and(Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(countedPages + faults))));
    }

    @Test(timeout=10000L)
    public void tracerMustBeNotifiedAboutPinUnpinFaultFlushAndEvictionEventsWhenWriting() throws IOException {
        long pagesToGenerate = 142L;
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, (PageCacheTracer)tracer);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            for (long i = 0L; i < pagesToGenerate; ++i) {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)i));
                Assert.assertTrue((boolean)cursor.next(i));
                Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)i));
                this.writeRecords(cursor);
            }
            Assert.assertTrue((boolean)cursor.next(0L));
            Assert.assertTrue((boolean)cursor.next(0L));
        }
        Assert.assertThat((String)"wrong count of pins", (Object)tracer.pins(), (Matcher)Matchers.is((Object)(pagesToGenerate + 1L)));
        Assert.assertThat((String)"wrong count of unpins", (Object)tracer.unpins(), (Matcher)Matchers.is((Object)(pagesToGenerate + 1L)));
        long faults = tracer.faults();
        Assert.assertThat((String)"wrong count of faults", (Object)faults, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate)));
        Assert.assertThat((String)"wrong count of evictions", (Object)tracer.evictions(), (Matcher)Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate - (long)this.maxPages))).and(Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate + faults))));
        long flushes = tracer.flushes();
        long bytesWritten = tracer.bytesWritten();
        Assert.assertThat((String)"wrong count of flushes", (Object)flushes, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate - (long)this.maxPages)));
        Assert.assertThat((String)"wrong count of bytes written", (Object)bytesWritten, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate * (long)this.filePageSize)));
    }

    @Test
    public void tracerMustBeNotifiedOfReadAndWritePins() throws Exception {
        final AtomicInteger writeCount = new AtomicInteger();
        final AtomicInteger readCount = new AtomicInteger();
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer(){

            public PinEvent beginPin(boolean writeLock, long filePageId, PageSwapper swapper) {
                (writeLock ? writeCount : readCount).getAndIncrement();
                return super.beginPin(writeLock, filePageId, swapper);
            }
        };
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, (PageCacheTracer)tracer);
        int pinsForRead = 13;
        int pinsForWrite = 42;
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 1);){
                for (int i = 0; i < pinsForRead; ++i) {
                    Assert.assertTrue((boolean)cursor.next());
                }
            }
            this.dirtyManyPages(pagedFile, pinsForWrite);
        }
        Assert.assertThat((String)"wrong read pin count", (Object)readCount.get(), (Matcher)Matchers.is((Object)pinsForRead));
        Assert.assertThat((String)"wrong write pin count", (Object)writeCount.get(), (Matcher)Matchers.is((Object)pinsForWrite));
    }

    @Test
    public void lastPageIdOfEmptyFileIsLessThanZero() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(0L)));
        }
    }

    @Test
    public void lastPageIdOfFileWithOneByteIsZero() throws IOException {
        StoreChannel channel = this.fs.create(this.file("a"));
        channel.write(ByteBuffer.wrap(new byte[]{1}));
        channel.close();
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)0L));
        }
    }

    @Test
    public void lastPageIdOfFileWithExactlyTwoPagesWorthOfDataIsOne() throws IOException {
        int twoPagesWorthOfRecords = this.recordsPerFilePage * 2;
        this.generateFileWithRecords(this.file("a"), twoPagesWorthOfRecords, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)1L));
        }
    }

    @Test
    public void lastPageIdOfFileWithExactlyTwoPagesAndOneByteWorthOfDataIsTwo() throws IOException {
        int twoPagesWorthOfRecords = this.recordsPerFilePage * 2;
        this.generateFileWithRecords(this.file("a"), twoPagesWorthOfRecords, this.recordSize);
        OutputStream outputStream = this.fs.openAsOutputStream(this.file("a"), true);
        outputStream.write(97);
        outputStream.close();
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)2L));
        }
    }

    @Test
    public void lastPageIdMustNotIncreaseWhenReadingToEndWithReadLock() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        long initialLastPageId = pagedFile.getLastPageId();
        try (PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
            }
        }
        long resultingLastPageId = pagedFile.getLastPageId();
        pagedFile.close();
        Assert.assertThat((Object)resultingLastPageId, (Matcher)Matchers.is((Object)initialLastPageId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lastPageIdMustNotIncreaseWhenReadingToEndWithNoGrowAndWriteLock() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        long initialLastPageId = pagedFile.getLastPageId();
        try (PageCursor cursor = pagedFile.io(0L, 6);){
            while (cursor.next()) {
            }
        }
        long resultingLastPageId = pagedFile.getLastPageId();
        try {
            Assert.assertThat((Object)resultingLastPageId, (Matcher)Matchers.is((Object)initialLastPageId));
        }
        finally {
            pagedFile.close();
        }
    }

    @Test
    public void lastPageIdMustIncreaseWhenScanningPastEndWithWriteLock() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 10, this.recordSize);
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)9L));
        this.dirtyManyPages(pagedFile, 15);
        try {
            Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)14L));
        }
        finally {
            pagedFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lastPageIdMustIncreaseWhenJumpingPastEndWithWriteLock() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 10, this.recordSize);
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)9L));
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next(15L));
        }
        try {
            Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)15L));
        }
        finally {
            pagedFile.close();
        }
    }

    @Test
    public void lastPageIdFromUnmappedFileMustThrow() throws IOException {
        PagedFile file;
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[]{StandardOpenOption.CREATE});){
            file = pf;
        }
        this.expectedException.expect(IllegalStateException.class);
        file.getLastPageId();
    }

    @Test
    public void cursorOffsetMustBeUpdatedReadAndWrite() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
                this.verifyWriteOffsets(cursor);
                cursor.setOffset(0);
                this.verifyReadOffsets(cursor);
            }
            cursor = pagedFile.io(0L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                this.verifyReadOffsets(cursor);
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    private void verifyWriteOffsets(PageCursor cursor) {
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)0));
        cursor.putLong(1L);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)8));
        cursor.putInt(1);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)12));
        cursor.putShort((short)1);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)14));
        cursor.putByte((byte)1);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)15));
        cursor.putBytes(new byte[]{1, 2, 3});
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)18));
        cursor.putBytes(new byte[]{1, 2, 3}, 1, 1);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)19));
    }

    private void verifyReadOffsets(PageCursor cursor) {
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)0));
        cursor.getLong();
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)8));
        cursor.getInt();
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)12));
        cursor.getShort();
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)14));
        cursor.getByte();
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)15));
        cursor.getBytes(new byte[3]);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)18));
        cursor.getBytes(new byte[3], 1, 1);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)19));
        byte[] expectedBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 3, 2};
        byte[] actualBytes = new byte[19];
        cursor.setOffset(0);
        cursor.getBytes(actualBytes);
        Assert.assertThat((Object)actualBytes, (Matcher)ByteArrayMatcher.byteArray(expectedBytes));
    }

    @Test(timeout=10000L)
    public void closeOnPageCacheMustThrowIfFilesAreStillMapped() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile ignore = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.expectedException.expect(IllegalStateException.class);
            this.pageCache.close();
        }
    }

    @Test(timeout=10000L)
    public void pagedFileIoMustThrowIfFileIsUnmapped() throws IOException {
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        pagedFile.close();
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            this.expectedException.expect(IllegalStateException.class);
            cursor.next();
            Assert.fail((String)"cursor.next() on unmapped file did not throw");
        }
    }

    @Test(timeout=10000L)
    public void writeLockedPageCursorNextMustThrowIfFileIsUnmapped() throws IOException {
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 2);
        pagedFile.close();
        this.expectedException.expect(IllegalStateException.class);
        cursor.next();
    }

    @Test(timeout=10000L)
    public void writeLockedPageCursorNextWithIdMustThrowIfFileIsUnmapped() throws IOException {
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 2);
        pagedFile.close();
        this.expectedException.expect(IllegalStateException.class);
        cursor.next(1L);
    }

    @Test(timeout=10000L)
    public void readLockedPageCursorNextMustThrowIfFileIsUnmapped() throws IOException {
        this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 1);
        pagedFile.close();
        this.expectedException.expect(IllegalStateException.class);
        cursor.next();
    }

    @Test(timeout=10000L)
    public void readLockedPageCursorNextWithIdMustThrowIfFileIsUnmapped() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 1);
        pagedFile.close();
        this.expectedException.expect(IllegalStateException.class);
        cursor.next(1L);
    }

    @Test(timeout=10000L)
    public void writeLockedPageMustBlockFileUnmapping() throws Exception {
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 2);
        Assert.assertTrue((boolean)cursor.next());
        Thread unmapper = ThreadTestUtils.fork(this.$close(pagedFile));
        unmapper.join(100L);
        cursor.close();
        unmapper.join();
    }

    @Test(timeout=10000L)
    public void optimisticReadLockedPageMustNotBlockFileUnmapping() throws Exception {
        this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 1);
        Assert.assertTrue((boolean)cursor.next());
        ThreadTestUtils.fork(this.$close(pagedFile)).join();
        cursor.close();
    }

    @Test(timeout=10000L)
    public void advancingPessimisticReadLockingCursorAfterUnmappingMustThrow() throws Exception {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 1);
        Assert.assertTrue((boolean)cursor.next());
        ThreadTestUtils.fork(this.$close(pagedFile)).join();
        this.expectedException.expect(IllegalStateException.class);
        cursor.next();
    }

    @Test(timeout=10000L)
    public void advancingOptimisticReadLockingCursorAfterUnmappingMustThrow() throws Exception {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 1);
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertTrue((boolean)cursor.next(0L));
        ThreadTestUtils.fork(this.$close(pagedFile)).join();
        try {
            cursor.next();
            Assert.fail((String)"Advancing the cursor should have thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void readingAndRetryingOnPageWithOptimisticReadLockingAfterUnmappingMustNotThrow() throws Exception {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 1);
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertTrue((boolean)cursor.next(0L));
        ThreadTestUtils.fork(this.$close(pagedFile)).join();
        this.pageCache.close();
        this.pageCache = null;
        cursor.getByte();
        cursor.shouldRetry();
        try {
            cursor.next();
            Assert.fail((String)"Advancing the cursor should have thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldRetryFromUnboundReadCursorMustNotThrow() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 1);){
            Assert.assertFalse((boolean)cursor.shouldRetry());
        }
    }

    @Test
    public void shouldRetryFromUnboundWriteCursorMustNotThrow() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertFalse((boolean)cursor.shouldRetry());
        }
    }

    @Test
    public void shouldRetryFromUnboundLinkedReadCursorMustNotThrow() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 1);){
            Assert.assertTrue((boolean)cursor.next());
            try (PageCursor linked = cursor.openLinkedCursor(1L);){
                Assert.assertFalse((boolean)cursor.shouldRetry());
            }
        }
    }

    @Test
    public void shouldRetryFromUnboundLinkedWriteCursorMustNotThrow() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            try (PageCursor linked = cursor.openLinkedCursor(1L);){
                Assert.assertFalse((boolean)cursor.shouldRetry());
            }
        }
    }

    @Test(timeout=10000L)
    public void getByteBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(PageCursor::getByte);
    }

    @Test(timeout=10000L)
    public void putByteBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(cursor -> cursor.putByte((byte)42));
    }

    @Test(timeout=10000L)
    public void getShortBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(PageCursor::getShort);
    }

    @Test(timeout=10000L)
    public void putShortBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(cursor -> cursor.putShort((short)42));
    }

    @Test(timeout=10000L)
    public void getIntBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(PageCursor::getInt);
    }

    @Test(timeout=10000L)
    public void putIntBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(cursor -> cursor.putInt(42));
    }

    @Test(timeout=10000L)
    public void putLongBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(cursor -> cursor.putLong(42L));
    }

    @Test(timeout=10000L)
    public void getLongBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(PageCursor::getLong);
    }

    @Test(timeout=10000L)
    public void putBytesBeyondPageEndMustThrow() throws IOException {
        byte[] bytes = new byte[]{1, 2, 3};
        this.verifyPageBounds(cursor -> cursor.putBytes(bytes));
    }

    @Test(timeout=10000L)
    public void getBytesBeyondPageEndMustThrow() throws IOException {
        byte[] bytes = new byte[3];
        this.verifyPageBounds(cursor -> cursor.getBytes(bytes));
    }

    @Test(timeout=10000L)
    public void putBytesWithOffsetAndLengthBeyondPageEndMustThrow() throws IOException {
        byte[] bytes = new byte[]{1, 2, 3};
        this.verifyPageBounds(cursor -> cursor.putBytes(bytes, 1, 1));
    }

    @Test(timeout=10000L)
    public void getBytesWithOffsetAndLengthBeyondPageEndMustThrow() throws IOException {
        byte[] bytes = new byte[3];
        this.verifyPageBounds(cursor -> cursor.getBytes(bytes, 1, 1));
    }

    private void verifyPageBounds(PageCursorAction action) throws IOException {
        this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            cursor.next();
            this.expectedException.expect(IndexOutOfBoundsException.class);
            for (int i = 0; i < 100000; ++i) {
                action.apply(cursor);
                if (!cursor.checkAndClearBoundsFlag()) continue;
                throw new IndexOutOfBoundsException();
            }
        }
    }

    @Test(timeout=10000L)
    public void shouldRetryMustClearBoundsFlagWhenReturningTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor reader = pf.io(0L, 1);){
            PageCursor writer = pf.io(0L, 2);
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)reader.next());
            reader.getByte(-1);
            writer.close();
            Assert.assertTrue((boolean)reader.shouldRetry());
            Assert.assertFalse((boolean)reader.checkAndClearBoundsFlag());
        }
    }

    @Test(timeout=10000L)
    public void shouldRetryMustNotClearBoundsFlagWhenReturningFalse() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor reader = pf.io(0L, 1);){
            PageCursor writer = pf.io(0L, 2);
            Assert.assertTrue((boolean)writer.next());
            writer.close();
            Assert.assertTrue((boolean)reader.next());
            reader.getByte(-1);
            Assert.assertFalse((boolean)reader.shouldRetry());
            Assert.assertTrue((boolean)reader.checkAndClearBoundsFlag());
        }
    }

    @Test(timeout=10000L)
    public void nextThatReturnsTrueMustNotClearBoundsFlagOnReadCursor() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor reader = pf.io(0L, 1);){
            PageCursor writer = pf.io(0L, 2);
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)reader.next());
            reader.getByte(-1);
            writer.next();
            writer.close();
            Assert.assertTrue((boolean)reader.next());
            Assert.assertTrue((boolean)reader.checkAndClearBoundsFlag());
        }
    }

    @Test(timeout=10000L)
    public void nextThatReturnsTrueMustNotClearBoundsFlagOnWriteCursor() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);){
            Assert.assertTrue((boolean)writer.next());
            writer.getByte(-1);
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)writer.checkAndClearBoundsFlag());
        }
    }

    @Test(timeout=10000L)
    public void nextThatReturnsFalseMustNotClearBoundsFlagOnReadCursor() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor reader = pf.io(0L, 1);){
            PageCursor writer = pf.io(0L, 2);
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)reader.next());
            reader.getByte(-1);
            writer.close();
            Assert.assertFalse((boolean)reader.next());
            Assert.assertTrue((boolean)reader.checkAndClearBoundsFlag());
        }
    }

    @Test(timeout=10000L)
    public void nextThatReturnsFalseMustNotClearBoundsFlagOnWriteCursor() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 6);){
            Assert.assertTrue((boolean)writer.next());
            writer.getByte(-1);
            Assert.assertFalse((boolean)writer.next());
            Assert.assertTrue((boolean)writer.checkAndClearBoundsFlag());
        }
    }

    @Test(timeout=10000L)
    public void nextWithPageIdThatReturnsTrueMustNotClearBoundsFlagOnReadCursor() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor reader = pf.io(0L, 1);){
            PageCursor writer = pf.io(0L, 2);
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)reader.next());
            reader.getByte(-1);
            writer.next(3L);
            writer.close();
            Assert.assertTrue((boolean)reader.next(3L));
            Assert.assertTrue((boolean)reader.checkAndClearBoundsFlag());
        }
    }

    @Test(timeout=10000L)
    public void nextWithPageIdMustNotClearBoundsFlagOnWriteCursor() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);){
            Assert.assertTrue((boolean)writer.next());
            writer.getByte(-1);
            Assert.assertTrue((boolean)writer.next(3L));
            Assert.assertTrue((boolean)writer.checkAndClearBoundsFlag());
        }
    }

    @Test(timeout=10000L)
    public void settingOutOfBoundsCursorOffsetMustNotRaiseBoundsFlag() throws IOException {
        this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            cursor.setOffset(-1);
            Assert.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
            cursor.setOffset(this.filePageSize + 1);
            Assert.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
            cursor.setOffset(this.pageCachePageSize + 1);
            Assert.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    public void manuallyRaisedBoundsFlagMustBeObservable() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pagedFile.io(0L, 2);
             PageCursor reader = pagedFile.io(0L, 1);){
            Assert.assertTrue((boolean)writer.next());
            writer.raiseOutOfBounds();
            Assert.assertTrue((boolean)writer.checkAndClearBoundsFlag());
            Assert.assertTrue((boolean)reader.next());
            reader.raiseOutOfBounds();
            Assert.assertTrue((boolean)reader.checkAndClearBoundsFlag());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void pageFaultForWriteMustThrowIfOutOfStorageSpace() throws IOException {
        final AtomicInteger writeCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        if (writeCounter.incrementAndGet() > 10) {
                            throw new IOException("No space left on device");
                        }
                        super.writeAll(src, position);
                    }
                };
            }
        };
        fs.create(this.file("a")).close();
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            this.expectedException.expect(IOException.class);
            while (cursor.next()) {
            }
        }
        finally {
            this.pageCache = null;
        }
    }

    @Test(timeout=120000L)
    public void pageFaultForReadMustThrowIfOutOfStorageSpace() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        final AtomicInteger writeCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        if (writeCounter.incrementAndGet() >= 1) {
                            throw new IOException("No space left on device");
                        }
                        super.writeAll(src, position);
                    }
                };
            }
        };
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
        }
        try {
            cursor = pagedFile.io(0L, 1);
            var5_5 = null;
            try {
                try {
                    while (true) {
                        this.expectedException.expect(IOException.class);
                        while (cursor.next()) {
                        }
                        cursor.rewind();
                    }
                }
                catch (Throwable throwable) {
                    var5_5 = throwable;
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (cursor != null) {
                    if (var5_5 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            var5_5.addSuppressed(throwable2);
                        }
                    } else {
                        cursor.close();
                    }
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            this.pageCache = null;
            throw throwable;
        }
    }

    @Test(timeout=10000L)
    public void mustRecoverFromFullDriveWhenMoreStorageBecomesAvailable() throws IOException {
        final AtomicBoolean hasSpace = new AtomicBoolean();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        if (!hasSpace.get()) {
                            throw new IOException("No space left on device");
                        }
                        super.writeAll(src, position);
                    }
                };
            }
        };
        fs.create(this.file("a")).close();
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try {
            PageCursor cursor = pagedFile.io(0L, 2);
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        Assert.assertTrue((boolean)cursor.next());
                        this.writeRecords(cursor);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cursor.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException iOException) {
            hasSpace.set(true);
            pagedFile.close();
            return;
        }
    }

    @Test(timeout=10000L)
    public void dataFromDifferentFilesMustNotBleedIntoEachOther() throws IOException {
        int i;
        File fileB = this.existingFile("b");
        int filePageSizeA = this.pageCachePageSize - 2;
        int filePageSizeB = this.pageCachePageSize - 6;
        int pagesToWriteA = 100;
        int pagesToWriteB = 3;
        this.configureStandardPageCache();
        PagedFile pagedFileA = this.pageCache.map(this.existingFile("a"), filePageSizeA, new OpenOption[0]);
        try (PageCursor cursor = pagedFileA.io(0L, 2);){
            for (int i2 = 0; i2 < pagesToWriteA; ++i2) {
                Assert.assertTrue((boolean)cursor.next());
                for (int j = 0; j < filePageSizeA; ++j) {
                    cursor.putByte((byte)42);
                }
            }
        }
        PagedFile pagedFileB = this.pageCache.map(fileB, filePageSizeB, new OpenOption[0]);
        try (PageCursor cursor = pagedFileB.io(0L, 2);){
            for (int i3 = 0; i3 < pagesToWriteB; ++i3) {
                Assert.assertTrue((boolean)cursor.next());
                cursor.putByte((byte)63);
            }
        }
        pagedFileA.close();
        pagedFileB.close();
        InputStream inputStream = this.fs.openAsInputStream(fileB);
        Assert.assertThat((String)"first page first byte", (Object)inputStream.read(), (Matcher)Matchers.is((Object)63));
        for (i = 0; i < filePageSizeB - 1; ++i) {
            Assert.assertThat((String)("page 0 byte pos " + i), (Object)inputStream.read(), (Matcher)Matchers.is((Object)0));
        }
        Assert.assertThat((String)"second page first byte", (Object)inputStream.read(), (Matcher)Matchers.is((Object)63));
        for (i = 0; i < filePageSizeB - 1; ++i) {
            Assert.assertThat((String)("page 1 byte pos " + i), (Object)inputStream.read(), (Matcher)Matchers.is((Object)0));
        }
        Assert.assertThat((String)"third page first byte", (Object)inputStream.read(), (Matcher)Matchers.is((Object)63));
        for (i = 0; i < filePageSizeB - 1; ++i) {
            Assert.assertThat((String)("page 2 byte pos " + i), (Object)inputStream.read(), (Matcher)Matchers.is((Object)0));
        }
        Assert.assertThat((String)"expect EOF", (Object)inputStream.read(), (Matcher)Matchers.is((Object)-1));
    }

    @Test(timeout=120000L)
    public void freshlyCreatedPagesMustContainAllZeros() throws IOException {
        int j;
        int i2;
        Throwable throwable;
        PageCursor cursor;
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);){
            cursor = pagedFile.io(0L, 2);
            throwable = null;
            try {
                for (i2 = 0; i2 < 100; ++i2) {
                    Assert.assertTrue((boolean)cursor.next());
                    for (j = 0; j < this.filePageSize; ++j) {
                        cursor.putByte((byte)rng.nextInt());
                    }
                }
            }
            catch (Throwable i2) {
                throwable = i2;
                throw i2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable i2) {
                            throwable.addSuppressed(i2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        this.pageCache.close();
        this.pageCache = null;
        System.gc();
        System.gc();
        this.configureStandardPageCache();
        pagedFile = this.pageCache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);
        var3_3 = null;
        try {
            cursor = pagedFile.io(0L, 2);
            throwable = null;
            try {
                for (i2 = 0; i2 < 100; ++i2) {
                    Assert.assertTrue((boolean)cursor.next());
                    for (j = 0; j < this.filePageSize; ++j) {
                        Assert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)0));
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var3_3 = throwable4;
            throw throwable4;
        }
        finally {
            if (pagedFile != null) {
                if (var3_3 != null) {
                    try {
                        pagedFile.close();
                    }
                    catch (Throwable throwable5) {
                        var3_3.addSuppressed(throwable5);
                    }
                } else {
                    pagedFile.close();
                }
            }
        }
    }

    @Test(timeout=120000L)
    public void optimisticReadLockMustFaultOnRetryIfPageHasBeenEvicted() throws Exception {
        int a = 97;
        int b = 98;
        File fileA = this.existingFile("a");
        File fileB = this.existingFile("b");
        this.configureStandardPageCache();
        PagedFile pagedFileA = this.pageCache.map(fileA, this.filePageSize, new OpenOption[0]);
        PagedFile pagedFileB = this.pageCache.map(fileB, this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFileA.io(0L, 2);){
            for (int i = 0; i < this.maxPages; ++i) {
                Assert.assertTrue((boolean)cursor.next());
                for (int j = 0; j < this.filePageSize; ++j) {
                    cursor.putByte((byte)97);
                }
            }
        }
        Runnable fillPagedFileB = () -> {
            try (PageCursor cursor = pagedFileB.io(0L, 2);){
                for (int i = 0; i < this.maxPages * 30; ++i) {
                    Assert.assertTrue((boolean)cursor.next());
                    for (int j = 0; j < this.filePageSize; ++j) {
                        cursor.putByte((byte)98);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        try (PageCursor cursor = pagedFileA.io(0L, 1);){
            Assert.assertTrue((boolean)cursor.next(0L));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertTrue((boolean)cursor.next(0L));
            for (int i = 0; i < this.filePageSize; ++i) {
                Assert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)97));
            }
            ThreadTestUtils.fork(fillPagedFileB).join();
            if (cursor.shouldRetry()) {
                int actual;
                int expected = 97 * this.filePageSize;
                do {
                    actual = 0;
                    for (int i = 0; i < this.filePageSize; ++i) {
                        actual += cursor.getByte();
                    }
                } while (cursor.shouldRetry());
                Assert.assertThat((Object)actual, (Matcher)Matchers.is((Object)expected));
            }
        }
        pagedFileA.close();
        pagedFileB.close();
    }

    @Test(timeout=10000L)
    public void pagesMustReturnToFreelistIfSwapInThrows() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        int iterations = this.maxPages * 2;
        this.accessPagesWhileInterrupted(pagedFile, 1, iterations);
        this.accessPagesWhileInterrupted(pagedFile, 2, iterations);
        Thread.interrupted();
        try (PageCursor cursor = pagedFile.io(0L, 1);){
            Assert.assertTrue((boolean)cursor.next());
            this.verifyRecordsMatchExpected(cursor);
        }
        pagedFile.close();
    }

    private void accessPagesWhileInterrupted(PagedFile pagedFile, int pf_flags, int iterations) throws IOException {
        try (PageCursor cursor = pagedFile.io(0L, pf_flags);){
            for (int i = 0; i < iterations; ++i) {
                Thread.currentThread().interrupt();
                try {
                    cursor.next(0L);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void mustSupportUnalignedWordAccesses() throws Exception {
        int pageSize = 0x800000;
        this.getPageCache(this.fs, 10, pageSize, PageCacheTracer.NULL);
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            for (int i = 0; i < pageSize - 8; ++i) {
                cursor.setOffset(i);
                long x = rng.nextLong();
                cursor.putLong(x);
                cursor.setOffset(i);
                String reason = "Failed to read back the value that was written at offset " + Long.toHexString(i);
                Assert.assertThat((String)reason, (Object)Long.toHexString(cursor.getLong()), (Matcher)Matchers.is((Object)Long.toHexString(x)));
            }
        }
    }

    @RepeatRule.Repeat(times=50)
    @Test(timeout=120000L)
    public void mustEvictPagesFromUnmappedFiles() throws Exception {
        Throwable throwable;
        PageCursor cursor;
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            cursor = pagedFile.io(0L, 2);
            throwable = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        var2_2 = null;
        try {
            cursor = pagedFile.io(0L, 2);
            throwable = null;
            try {
                for (int i = 0; i < this.maxPages + 5; ++i) {
                    Assert.assertTrue((boolean)cursor.next());
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var2_2 = throwable6;
            throw throwable6;
        }
        finally {
            if (pagedFile != null) {
                if (var2_2 != null) {
                    try {
                        pagedFile.close();
                    }
                    catch (Throwable throwable7) {
                        var2_2.addSuppressed(throwable7);
                    }
                } else {
                    pagedFile.close();
                }
            }
        }
    }

    @Test(timeout=120000L)
    public void mustReadZerosFromBeyondEndOfFile() throws Exception {
        StandardRecordFormat recordFormat = new StandardRecordFormat();
        File[] files = new File[]{this.file("1"), this.file("2"), this.file("3"), this.file("4"), this.file("5"), this.file("6"), this.file("7"), this.file("8"), this.file("9"), this.file("0"), this.file("A"), this.file("B")};
        for (int fileId = 0; fileId < files.length; ++fileId) {
            File file = files[fileId];
            StoreChannel channel = this.fs.open(file, "rw");
            for (int recordId = 0; recordId < fileId + 1; ++recordId) {
                Record record = recordFormat.createRecord(file, recordId);
                recordFormat.writeRecord(record, channel);
            }
            channel.close();
        }
        int pageSize = this.nextPowerOf2(recordFormat.getRecordSize() * (files.length + 1));
        this.getPageCache(this.fs, 2, pageSize, PageCacheTracer.NULL);
        int fileId = files.length;
        while (fileId-- > 0) {
            File file = files[fileId];
            PagedFile pf = this.pageCache.map(file, pageSize, new OpenOption[0]);
            Throwable throwable = null;
            try {
                PageCursor cursor = pf.io(0L, 1);
                Throwable throwable2 = null;
                try {
                    int pageCount = 0;
                    while (cursor.next()) {
                        ++pageCount;
                        recordFormat.assertRecordsWrittenCorrectly(cursor);
                    }
                    Assert.assertThat((String)("pages in file " + file), (Object)pageCount, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (cursor == null) continue;
                    if (throwable2 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    cursor.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (pf == null) continue;
                if (throwable != null) {
                    try {
                        pf.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                pf.close();
            }
        }
    }

    private int nextPowerOf2(int i) {
        return 1 << 32 - Integer.numberOfLeadingZeros(i);
    }

    private PageSwapperFactory factoryCountingSyncDevice(final AtomicInteger syncDeviceCounter, final Queue<Integer> expectedCountsInForce) {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory(){

            public void syncDevice() {
                super.syncDevice();
                syncDeviceCounter.getAndIncrement();
            }

            public PageSwapper createPageSwapper(File file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist) throws IOException {
                PageSwapper delegate = super.createPageSwapper(file, filePageSize, onEviction, createIfNotExist);
                return new DelegatingPageSwapper(delegate){

                    @Override
                    public void force() throws IOException {
                        super.force();
                        Assert.assertThat((Object)syncDeviceCounter.get(), (Matcher)Matchers.is(expectedCountsInForce.poll()));
                    }
                };
            }
        };
        factory.setFileSystemAbstraction(this.fs);
        return factory;
    }

    @SafeVarargs
    private static <E> Queue<E> queue(E ... items) {
        ConcurrentLinkedQueue<E> queue = new ConcurrentLinkedQueue<E>();
        for (E item : items) {
            queue.offer(item);
        }
        return queue;
    }

    @Test(timeout=120000L)
    public void mustSyncDeviceWhenFlushAndForcingPagedFile() throws Exception {
        AtomicInteger syncDeviceCounter = new AtomicInteger();
        AtomicInteger expectedCountInForce = new AtomicInteger();
        Queue<Integer> expectedCountsInForce = PageCacheTest.queue(0, 1, 2);
        PageSwapperFactory factory = this.factoryCountingSyncDevice(syncDeviceCounter, expectedCountsInForce);
        try (Object cache = this.createPageCache(factory, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
             PagedFile p1 = cache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PagedFile p2 = cache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = p1.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
            }
            cursor = p2.io(0L, 2);
            var12_18 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var12_18 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var12_18 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var12_18.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            p1.flushAndForce();
            expectedCountInForce.set(1);
            Assert.assertThat((Object)syncDeviceCounter.get(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test(timeout=120000L)
    public void mustSyncDeviceWhenFlushAndForcingPageCache() throws Exception {
        AtomicInteger syncDeviceCounter = new AtomicInteger();
        AtomicInteger expectedCountInForce = new AtomicInteger();
        Queue<Integer> expectedCountsInForce = PageCacheTest.queue(0, 0, 1, 2);
        PageSwapperFactory factory = this.factoryCountingSyncDevice(syncDeviceCounter, expectedCountsInForce);
        try (Object cache = this.createPageCache(factory, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
             PagedFile p1 = cache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PagedFile p2 = cache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = p1.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
            }
            cursor = p2.io(0L, 2);
            var12_18 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var12_18 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var12_18 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var12_18.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cache.flushAndForce();
            expectedCountInForce.set(1);
            Assert.assertThat((Object)syncDeviceCounter.get(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test(expected=NoSuchFileException.class)
    public void mustThrowWhenMappingNonExistingFile() throws Exception {
        this.configureStandardPageCache();
        this.pageCache.map(this.file("does not exist"), this.filePageSize, new OpenOption[0]);
    }

    @Test(timeout=120000L)
    public void mustCreateNonExistingFileWithCreateOption() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("does not exist"), this.filePageSize, new OpenOption[]{StandardOpenOption.CREATE});
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
        }
    }

    @Test(timeout=120000L)
    public void mustIgnoreCreateOptionIfFileAlreadyExists() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[]{StandardOpenOption.CREATE});
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
        }
    }

    @Test(timeout=120000L)
    public void mustIgnoreCertainOpenOptions() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.SPARSE});
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
        }
    }

    @Test(timeout=120000L)
    public void mustThrowOnUnsupportedOpenOptions() throws Exception {
        this.configureStandardPageCache();
        this.verifyMappingWithOpenOptionThrows(StandardOpenOption.CREATE_NEW);
        this.verifyMappingWithOpenOptionThrows(StandardOpenOption.SYNC);
        this.verifyMappingWithOpenOptionThrows(StandardOpenOption.DSYNC);
        this.verifyMappingWithOpenOptionThrows(new OpenOption(){

            public String toString() {
                return "NonStandardOpenOption";
            }
        });
    }

    private void verifyMappingWithOpenOptionThrows(OpenOption option) throws IOException {
        try {
            this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[]{option}).close();
            Assert.fail((String)("Expected PageCache.map() to throw when given the OpenOption " + option));
        }
        catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    @Test(timeout=120000L)
    public void mappingFileWithTruncateOptionMustTruncateFile() throws Exception {
        Throwable throwable;
        PageCursor cursor;
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            cursor = pf.io(10L, 2);
            throwable = null;
            try {
                Assert.assertThat((Object)pf.getLastPageId(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(0L)));
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(-889275714);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING});
        var2_2 = null;
        try {
            cursor = pf.io(0L, 1);
            throwable = null;
            try {
                Assert.assertThat((Object)pf.getLastPageId(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(0L)));
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var2_2 = throwable6;
            throw throwable6;
        }
        finally {
            if (pf != null) {
                if (var2_2 != null) {
                    try {
                        pf.close();
                    }
                    catch (Throwable throwable7) {
                        var2_2.addSuppressed(throwable7);
                    }
                } else {
                    pf.close();
                }
            }
        }
    }

    @Test
    public void mappingAlreadyMappedFileWithTruncateOptionMustThrow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile first = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.expectedException.expect(UnsupportedOperationException.class);
            try (PagedFile second = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING});){
                Assert.fail((String)"the second map call should have thrown");
            }
        }
    }

    @Test
    public void mustThrowIfFileIsClosedMoreThanItIsMapped() throws Exception {
        this.configureStandardPageCache();
        PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        pf.close();
        this.expectedException.expect(IllegalStateException.class);
        pf.close();
    }

    @Test
    public void fileMappedWithDeleteOnCloseMustNotExistAfterUnmap() throws Exception {
        this.configureStandardPageCache();
        this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[]{StandardOpenOption.DELETE_ON_CLOSE}).close();
        this.expectedException.expect(NoSuchFileException.class);
        this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
    }

    @Test
    public void fileMappedWithDeleteOnCloseMustNotExistAfterLastUnmap() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        try (PagedFile ignore = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);){
            this.pageCache.map(file, this.filePageSize, new OpenOption[]{StandardOpenOption.DELETE_ON_CLOSE}).close();
        }
        this.expectedException.expect(NoSuchFileException.class);
        this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
    }

    @Test
    public void mustNotThrowWhenMappingFileWithDifferentFilePageSizeAndAnyPageSizeIsSpecified() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile ignore = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.pageCache.map(this.file("a"), this.filePageSize + 1, new OpenOption[]{PageCacheOpenOptions.ANY_PAGE_SIZE}).close();
        }
    }

    @Test
    public void mustCopyIntoSameSizedWritePageCursor() throws Exception {
        Throwable throwable;
        this.configureStandardPageCache();
        int bytes = 200;
        try (PagedFile pf = this.pageCache.map(this.file("a"), 32, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            for (int i = 0; i < bytes; ++i) {
                if ((i & 0x1F) == 0) {
                    Assert.assertTrue((boolean)cursor.next());
                }
                cursor.putByte((byte)i);
            }
        }
        int pageSize = 16;
        try (PagedFile pfA = this.pageCache.map(this.file("a"), pageSize, new OpenOption[0]);){
            throwable = null;
            try (PagedFile pfB = this.pageCache.map(this.existingFile("b"), pageSize, new OpenOption[0]);
                 PageCursor cursorA2 = pfA.io(0L, 1);
                 PageCursor cursorB = pfB.io(0L, 2);){
                while (cursorA2.next()) {
                    int bytesCopied;
                    Assert.assertTrue((boolean)cursorB.next());
                    do {
                        bytesCopied = cursorA2.copyTo(0, cursorB, 0, cursorA2.getCurrentPageSize());
                    } while (cursorA2.shouldRetry());
                    Assert.assertThat((Object)bytesCopied, (Matcher)Matchers.is((Object)pageSize));
                }
            }
            catch (Throwable cursorA2) {
                throwable = cursorA2;
                throw cursorA2;
            }
        }
        var4_5 = null;
        try (PagedFile pf = this.pageCache.map(this.file("b"), 32, new OpenOption[0]);){
            throwable = null;
            try (PageCursor cursor = pf.io(0L, 1);){
                for (int i = 0; i < bytes; ++i) {
                    byte b;
                    if ((i & 0x1F) == 0) {
                        Assert.assertTrue((boolean)cursor.next());
                    }
                    int offset = cursor.getOffset();
                    do {
                        cursor.setOffset(offset);
                        b = cursor.getByte();
                    } while (cursor.shouldRetry());
                    Assert.assertThat((Object)b, (Matcher)Matchers.is((Object)((byte)i)));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var4_5 = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void mustCopyIntoLargerPageCursor() throws Exception {
        this.configureStandardPageCache();
        int smallPageSize = 16;
        int largePageSize = 17;
        try (PagedFile pfA = this.pageCache.map(this.file("a"), smallPageSize, new OpenOption[0]);
             PagedFile pfB = this.pageCache.map(this.existingFile("b"), largePageSize, new OpenOption[0]);
             PageCursor cursorA = pfA.io(0L, 2);
             PageCursor cursorB = pfB.io(0L, 2);){
            int i;
            Assert.assertTrue((boolean)cursorA.next());
            for (i = 0; i < smallPageSize; ++i) {
                cursorA.putByte((byte)(i + 1));
            }
            Assert.assertTrue((boolean)cursorB.next());
            Assert.assertThat((Object)cursorA.copyTo(0, cursorB, 0, smallPageSize), (Matcher)Matchers.is((Object)smallPageSize));
            for (i = 0; i < smallPageSize; ++i) {
                Assert.assertThat((Object)cursorB.getByte(), (Matcher)Matchers.is((Object)((byte)(i + 1))));
            }
            Assert.assertThat((Object)cursorB.getByte(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void mustCopyIntoSmallerPageCursor() throws Exception {
        this.configureStandardPageCache();
        int smallPageSize = 16;
        int largePageSize = 17;
        try (PagedFile pfA = this.pageCache.map(this.file("a"), largePageSize, new OpenOption[0]);
             PagedFile pfB = this.pageCache.map(this.existingFile("b"), smallPageSize, new OpenOption[0]);
             PageCursor cursorA = pfA.io(0L, 2);
             PageCursor cursorB = pfB.io(0L, 2);){
            int i;
            Assert.assertTrue((boolean)cursorA.next());
            for (i = 0; i < largePageSize; ++i) {
                cursorA.putByte((byte)(i + 1));
            }
            Assert.assertTrue((boolean)cursorB.next());
            Assert.assertThat((Object)cursorA.copyTo(0, cursorB, 0, largePageSize), (Matcher)Matchers.is((Object)smallPageSize));
            for (i = 0; i < smallPageSize; ++i) {
                Assert.assertThat((Object)cursorB.getByte(), (Matcher)Matchers.is((Object)((byte)(i + 1))));
            }
        }
    }

    @Test
    public void mustThrowOnCopyIntoReadPageCursor() throws Exception {
        this.configureStandardPageCache();
        int pageSize = 17;
        try (PagedFile pfA = this.pageCache.map(this.file("a"), pageSize, new OpenOption[0]);
             PagedFile pfB = this.pageCache.map(this.existingFile("b"), pageSize, new OpenOption[0]);){
            Throwable throwable;
            PageCursor cursorB;
            try (PageCursor cursorA = pfA.io(0L, 2);){
                cursorB = pfB.io(0L, 2);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)cursorA.next());
                    Assert.assertTrue((boolean)cursorB.next());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (cursorB != null) {
                        if (throwable != null) {
                            try {
                                cursorB.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            cursorB.close();
                        }
                    }
                }
            }
            cursorA = pfA.io(0L, 2);
            var7_11 = null;
            try {
                cursorB = pfB.io(0L, 1);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)cursorA.next());
                    Assert.assertTrue((boolean)cursorB.next());
                    this.expectedException.expect(IllegalArgumentException.class);
                    cursorA.copyTo(0, cursorB, 0, pageSize);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (cursorB != null) {
                        if (throwable != null) {
                            try {
                                cursorB.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            cursorB.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var7_11 = throwable6;
                throw throwable6;
            }
            finally {
                if (cursorA != null) {
                    if (var7_11 != null) {
                        try {
                            cursorA.close();
                        }
                        catch (Throwable throwable7) {
                            var7_11.addSuppressed(throwable7);
                        }
                    } else {
                        cursorA.close();
                    }
                }
            }
        }
    }

    @Test
    public void copyToMustCheckBounds() throws Exception {
        this.configureStandardPageCache();
        int pageSize = 16;
        try (PagedFile pf = this.pageCache.map(this.file("a"), pageSize, new OpenOption[0]);
             PageCursor cursorA = pf.io(0L, 1);
             PageCursor cursorB = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursorB.next());
            Assert.assertTrue((boolean)cursorB.next());
            Assert.assertTrue((boolean)cursorA.next());
            cursorA.copyTo(-1, cursorB, 0, 1);
            Assert.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            Assert.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            cursorA.copyTo(0, cursorB, -1, 1);
            Assert.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            Assert.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            cursorA.copyTo(pageSize, cursorB, 0, 1);
            Assert.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            Assert.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            cursorA.copyTo(0, cursorB, pageSize, 1);
            Assert.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            Assert.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            Assert.assertThat((Object)cursorA.copyTo(1, cursorB, 0, pageSize), (Matcher)Matchers.is((Object)(pageSize - 1)));
            Assert.assertFalse((boolean)cursorA.checkAndClearBoundsFlag());
            Assert.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            Assert.assertThat((Object)cursorA.copyTo(0, cursorB, 1, pageSize), (Matcher)Matchers.is((Object)(pageSize - 1)));
            Assert.assertFalse((boolean)cursorA.checkAndClearBoundsFlag());
            Assert.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            cursorA.copyTo(1, cursorB, 1, -1);
            Assert.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            Assert.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
        }
    }

    @Test(timeout=10000L)
    public void readCursorsCanOpenLinkedCursor() throws Exception {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor parent = pf.io(0L, 1);){
            PageCursor linked = parent.openLinkedCursor(1L);
            Assert.assertTrue((boolean)parent.next());
            Assert.assertTrue((boolean)linked.next());
            this.verifyRecordsMatchExpected(parent);
            this.verifyRecordsMatchExpected(linked);
        }
    }

    @Test(timeout=10000L)
    public void writeCursorsCanOpenLinkedCursor() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor parent = pf.io(0L, 2);){
            PageCursor linked = parent.openLinkedCursor(1L);
            Assert.assertTrue((boolean)parent.next());
            Assert.assertTrue((boolean)linked.next());
            this.writeRecords(parent);
            this.writeRecords(linked);
        }
        this.verifyRecordsInFile(file, this.recordsPerFilePage * 2);
    }

    @Test(timeout=10000L)
    public void closingParentCursorMustCloseLinkedCursor() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            PageCursor writerParent = pf.io(0L, 2);
            PageCursor readerParent = pf.io(0L, 1);
            Assert.assertTrue((boolean)writerParent.next());
            Assert.assertTrue((boolean)readerParent.next());
            PageCursor writerLinked = writerParent.openLinkedCursor(1L);
            PageCursor readerLinked = readerParent.openLinkedCursor(1L);
            Assert.assertTrue((boolean)writerLinked.next());
            Assert.assertTrue((boolean)readerLinked.next());
            writerParent.close();
            readerParent.close();
            writerLinked.getByte(0);
            Assert.assertTrue((boolean)writerLinked.checkAndClearBoundsFlag());
            readerLinked.getByte(0);
            Assert.assertTrue((boolean)readerLinked.checkAndClearBoundsFlag());
        }
    }

    @Test(timeout=10000L)
    public void writeCursorWithNoGrowCanOpenLinkedCursorWithNoGrow() throws Exception {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor parent = pf.io(0L, 6);){
            PageCursor linked = parent.openLinkedCursor(1L);
            Assert.assertTrue((boolean)parent.next());
            Assert.assertTrue((boolean)linked.next());
            this.verifyRecordsMatchExpected(parent);
            this.verifyRecordsMatchExpected(linked);
            Assert.assertFalse((boolean)linked.next());
        }
    }

    @Test(timeout=10000L)
    public void openingLinkedCursorMustCloseExistingLinkedCursor() throws Exception {
        PageCursor linked2;
        Throwable throwable;
        PageCursor parent;
        this.configureStandardPageCache();
        File file = this.file("a");
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);){
            parent = pf.io(0L, 2);
            throwable = null;
            try {
                linked2 = parent.openLinkedCursor(1L);
                Assert.assertTrue((boolean)parent.next());
                Assert.assertTrue((boolean)linked2.next());
                this.writeRecords(parent);
                this.writeRecords(linked2);
                parent.openLinkedCursor(2L);
                linked2.putByte(0, (byte)1);
                Assert.assertTrue((boolean)linked2.checkAndClearBoundsFlag());
            }
            catch (Throwable linked2) {
                throwable = linked2;
                throw linked2;
            }
            finally {
                if (parent != null) {
                    if (throwable != null) {
                        try {
                            parent.close();
                        }
                        catch (Throwable linked2) {
                            throwable.addSuppressed(linked2);
                        }
                    } else {
                        parent.close();
                    }
                }
            }
        }
        pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
        var3_3 = null;
        try {
            parent = pf.io(0L, 1);
            throwable = null;
            try {
                linked2 = parent.openLinkedCursor(1L);
                Assert.assertTrue((boolean)parent.next());
                Assert.assertTrue((boolean)linked2.next());
                parent.openLinkedCursor(2L);
                linked2.getByte(0);
                Assert.assertTrue((boolean)linked2.checkAndClearBoundsFlag());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (parent != null) {
                    if (throwable != null) {
                        try {
                            parent.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        parent.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var3_3 = throwable4;
            throw throwable4;
        }
        finally {
            if (pf != null) {
                if (var3_3 != null) {
                    try {
                        pf.close();
                    }
                    catch (Throwable throwable5) {
                        var3_3.addSuppressed(throwable5);
                    }
                } else {
                    pf.close();
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void shouldRetryOnParentCursorMustReturnTrueIfLinkedCursorNeedsRetry() throws Exception {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor parentReader = pf.io(0L, 1);
             PageCursor writer = pf.io(1L, 2);){
            PageCursor linkedReader = parentReader.openLinkedCursor(1L);
            Assert.assertTrue((boolean)parentReader.next());
            Assert.assertTrue((boolean)linkedReader.next());
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)parentReader.shouldRetry());
        }
    }

    @Test(timeout=10000L)
    public void checkAndClearBoundsFlagMustCheckAndClearLinkedCursor() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor parent = pf.io(0L, 2);){
            Assert.assertTrue((boolean)parent.next());
            PageCursor linked = parent.openLinkedCursor(1L);
            linked.raiseOutOfBounds();
            Assert.assertTrue((boolean)parent.checkAndClearBoundsFlag());
            Assert.assertFalse((boolean)linked.checkAndClearBoundsFlag());
        }
    }

    @Test
    public void shouldRetryMustClearBoundsFlagIfLinkedCursorNeedsRetry() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                Assert.assertTrue((boolean)linkedReader.next());
                Assert.assertTrue((boolean)writer.next(1L));
                Assert.assertTrue((boolean)writer.next());
                reader.raiseOutOfBounds();
                Assert.assertTrue((boolean)reader.shouldRetry());
                Assert.assertFalse((boolean)reader.checkAndClearBoundsFlag());
            }
        }
    }

    @Test
    public void checkAndClearCursorExceptionMustNotThrowIfNoExceptionIsSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pf.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
                cursor.checkAndClearCursorException();
            }
            cursor = pf.io(0L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                cursor.checkAndClearCursorException();
                while (cursor.shouldRetry()) {
                }
                cursor.checkAndClearCursorException();
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test
    public void checkAndClearCursorExceptionMustThrowIfExceptionIsSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            Throwable throwable;
            PageCursor cursor;
            String msg = "Boo" + ThreadLocalRandom.current().nextInt();
            try {
                cursor = pf.io(0L, 2);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)cursor.next());
                    cursor.setCursorException(msg);
                    cursor.checkAndClearCursorException();
                    Assert.fail((String)"checkAndClearError on write cursor should have thrown");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (cursor != null) {
                        if (throwable != null) {
                            try {
                                cursor.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            cursor.close();
                        }
                    }
                }
            }
            catch (CursorException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)msg));
            }
            msg = "Boo" + ThreadLocalRandom.current().nextInt();
            try {
                cursor = pf.io(0L, 1);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)cursor.next());
                    cursor.setCursorException(msg);
                    cursor.checkAndClearCursorException();
                    Assert.fail((String)"checkAndClearError on read cursor should have thrown");
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (cursor != null) {
                        if (throwable != null) {
                            try {
                                cursor.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            cursor.close();
                        }
                    }
                }
            }
            catch (CursorException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)msg));
            }
        }
    }

    @Test
    public void checkAndClearCursorExceptionMustClearExceptionIfSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pf.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
                cursor.setCursorException("boo");
                try {
                    cursor.checkAndClearCursorException();
                    Assert.fail((String)"checkAndClearError on write cursor should have thrown");
                }
                catch (CursorException cursorException) {
                    // empty catch block
                }
                cursor.checkAndClearCursorException();
            }
            cursor = pf.io(0L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                cursor.setCursorException("boo");
                try {
                    cursor.checkAndClearCursorException();
                    Assert.fail((String)"checkAndClearError on read cursor should have thrown");
                }
                catch (CursorException cursorException) {
                    // empty catch block
                }
                cursor.checkAndClearCursorException();
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test
    public void nextMustClearCursorExceptionIfSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pf.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
                cursor.setCursorException("boo");
                Assert.assertTrue((boolean)cursor.next());
                cursor.checkAndClearCursorException();
            }
            cursor = pf.io(0L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                cursor.setCursorException("boo");
                Assert.assertTrue((boolean)cursor.next());
                cursor.checkAndClearCursorException();
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test
    public void nextWithIdMustClearCursorExceptionIfSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pf.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next(1L));
                cursor.setCursorException("boo");
                Assert.assertTrue((boolean)cursor.next(2L));
                cursor.checkAndClearCursorException();
            }
            cursor = pf.io(0L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next(1L));
                cursor.setCursorException("boo");
                Assert.assertTrue((boolean)cursor.next(2L));
                cursor.checkAndClearCursorException();
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test
    public void shouldRetryMustClearCursorExceptionIfItReturnsTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)reader.next());
            Assert.assertTrue((boolean)writer.next(0L));
            Assert.assertTrue((boolean)writer.next());
            reader.setCursorException("boo");
            Assert.assertTrue((boolean)reader.shouldRetry());
            reader.checkAndClearCursorException();
        }
    }

    @Test
    public void shouldRetryMustNotClearCursorExceptionIfItReturnsFalse() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 1);){
            Assert.assertTrue((boolean)cursor.next());
            do {
                cursor.setCursorException("boo");
            } while (cursor.shouldRetry());
            try {
                cursor.checkAndClearCursorException();
                Assert.fail((String)"checkAndClearCursorException should have thrown");
            }
            catch (CursorException cursorException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldRetryMustClearCursorExceptionIfLinkedShouldRetryReturnsTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                Assert.assertTrue((boolean)linkedReader.next());
                Assert.assertTrue((boolean)writer.next(1L));
                Assert.assertTrue((boolean)writer.next());
                reader.setCursorException("boo");
                Assert.assertTrue((boolean)reader.shouldRetry());
                reader.checkAndClearCursorException();
            }
        }
    }

    @Test
    public void shouldRetryMustClearLinkedCursorExceptionIfItReturnsTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                Assert.assertTrue((boolean)linkedReader.next());
                linkedReader.setCursorException("boo");
                Assert.assertTrue((boolean)writer.next(0L));
                Assert.assertTrue((boolean)reader.shouldRetry());
                linkedReader.checkAndClearCursorException();
                reader.checkAndClearCursorException();
            }
        }
    }

    @Test
    public void shouldRetryMustClearLinkedCursorExceptionIfLinkedShouldRetryReturnsTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)writer.next());
            Assert.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                Assert.assertTrue((boolean)linkedReader.next());
                linkedReader.setCursorException("boo");
                Assert.assertTrue((boolean)writer.next(1L));
                Assert.assertTrue((boolean)reader.shouldRetry());
                linkedReader.checkAndClearCursorException();
                reader.checkAndClearCursorException();
            }
        }
    }

    @Test
    public void shouldRetryMustNotClearCursorExceptionIfBothItAndLinkedShouldRetryReturnsFalse() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor reader = pf.io(0L, 1);
             PageCursor linkedReader = reader.openLinkedCursor(1L);){
            Assert.assertTrue((boolean)reader.next());
            Assert.assertTrue((boolean)linkedReader.next());
            do {
                reader.setCursorException("boo");
            } while (reader.shouldRetry());
            try {
                reader.checkAndClearCursorException();
                Assert.fail((String)"checkAndClearCursorException should have thrown");
            }
            catch (CursorException cursorException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldRetryMustNotClearLinkedCursorExceptionIfBothItAndLinkedShouldRetryReturnsFalse() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor reader = pf.io(0L, 1);
             PageCursor linkedReader = reader.openLinkedCursor(1L);){
            Assert.assertTrue((boolean)reader.next());
            Assert.assertTrue((boolean)linkedReader.next());
            do {
                linkedReader.setCursorException("boo");
            } while (reader.shouldRetry());
            try {
                reader.checkAndClearCursorException();
                Assert.fail((String)"checkAndClearCursorException should have thrown");
            }
            catch (CursorException cursorException) {
                // empty catch block
            }
        }
    }

    @Test
    public void checkAndClearCursorExceptionMustThrowIfLinkedCursorHasErrorSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            String msg = "Boo" + ThreadLocalRandom.current().nextInt();
            Assert.assertTrue((boolean)writer.next());
            try (PageCursor linkedWriter = writer.openLinkedCursor(1L);){
                Assert.assertTrue((boolean)linkedWriter.next());
                linkedWriter.setCursorException(msg);
                try {
                    writer.checkAndClearCursorException();
                    Assert.fail((String)"checkAndClearCursorException on writer should have thrown due to linked cursor error");
                }
                catch (CursorException e) {
                    Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)msg));
                }
            }
            msg = "Boo" + ThreadLocalRandom.current().nextInt();
            Assert.assertTrue((boolean)reader.next());
            var9_15 = null;
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                Assert.assertTrue((boolean)linkedReader.next());
                linkedReader.setCursorException(msg);
                try {
                    reader.checkAndClearCursorException();
                    Assert.fail((String)"checkAndClearCursorException on reader should have thrown due to linked cursor error");
                }
                catch (CursorException e) {
                    Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)msg));
                }
            }
            catch (Throwable throwable) {
                var9_15 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void checkAndClearCursorMustNotThrowIfErrorHasBeenSetButTheCursorHasBeenClosed() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            PageCursor writer = pf.io(0L, 2);
            Assert.assertTrue((boolean)writer.next());
            writer.setCursorException("boo");
            writer.close();
            writer.checkAndClearCursorException();
            PageCursor reader = pf.io(0L, 1);
            Assert.assertTrue((boolean)reader.next());
            reader.setCursorException("boo");
            reader.close();
            reader.checkAndClearCursorException();
            writer = pf.io(0L, 2);
            PageCursor linkedWriter = writer.openLinkedCursor(1L);
            Assert.assertTrue((boolean)linkedWriter.next());
            linkedWriter.setCursorException("boo");
            writer.close();
            linkedWriter.checkAndClearCursorException();
            reader = pf.io(0L, 1);
            PageCursor linkedReader = reader.openLinkedCursor(1L);
            Assert.assertTrue((boolean)linkedReader.next());
            linkedReader.setCursorException("boo");
            reader.close();
            linkedReader.checkAndClearCursorException();
        }
    }

    @Test
    public void openingLinkedCursorOnClosedCursorMustThrow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            PageCursor writer = pf.io(0L, 2);
            Assert.assertTrue((boolean)writer.next());
            writer.close();
            try {
                writer.openLinkedCursor(1L);
                Assert.fail((String)"opening linked cursor on closed write cursor should have thrown");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            PageCursor reader = pf.io(0L, 2);
            Assert.assertTrue((boolean)reader.next());
            reader.close();
            try {
                reader.openLinkedCursor(1L);
                Assert.fail((String)"opening linked cursor on closed reader cursor should have thrown");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Test
    public void settingNullCursorExceptionMustThrow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assert.assertTrue((boolean)writer.next());
            try {
                writer.setCursorException(null);
                Assert.fail((String)"setting null cursor error on write cursor should have thrown");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertTrue((boolean)reader.next());
            try {
                reader.setCursorException(null);
                Assert.fail((String)"setting null cursor error in read cursor should have thrown");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void clearCursorExceptionMustUnsetErrorCondition() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assert.assertTrue((boolean)writer.next());
            writer.setCursorException("boo");
            writer.clearCursorException();
            writer.checkAndClearCursorException();
            Assert.assertTrue((boolean)reader.next());
            reader.setCursorException("boo");
            reader.clearCursorException();
            reader.checkAndClearCursorException();
        }
    }

    @Test
    public void clearCursorExceptionMustUnsetErrorConditionOnLinkedCursor() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assert.assertTrue((boolean)writer.next());
            PageCursor linkedWriter = writer.openLinkedCursor(1L);
            Assert.assertTrue((boolean)linkedWriter.next());
            linkedWriter.setCursorException("boo");
            writer.clearCursorException();
            writer.checkAndClearCursorException();
            Assert.assertTrue((boolean)reader.next());
            PageCursor linkedReader = reader.openLinkedCursor(1L);
            Assert.assertTrue((boolean)linkedReader.next());
            linkedReader.setCursorException("boo");
            reader.clearCursorException();
            reader.checkAndClearCursorException();
        }
    }

    @Test(timeout=10000L)
    public void readableByteChannelMustBeOpenUntilClosed() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            ReadableByteChannel channel;
            try (ReadableByteChannel ch = pf.openReadableByteChannel();){
                Assert.assertTrue((boolean)ch.isOpen());
                channel = ch;
            }
            Assert.assertFalse((boolean)channel.isOpen());
        }
    }

    @Test(timeout=10000L)
    public void readableByteChannelMustReadAllBytesInFile() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
             ReadableByteChannel channel = pf.openReadableByteChannel();){
            this.verifyRecordsInFile(channel, this.recordCount);
        }
    }

    @RepeatRule.Repeat(times=20)
    @Test(timeout=10000L)
    public void readableByteChannelMustReadAllBytesInFileConsistently() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);){
            RandomAdversary adversary = new RandomAdversary(0.9, 0.0, 0.0);
            AdversarialPagedFile apf = new AdversarialPagedFile(pf, adversary);
            try (ReadableByteChannel channel = apf.openReadableByteChannel();){
                this.verifyRecordsInFile(channel, this.recordCount);
            }
        }
    }

    @Test(timeout=10000L)
    public void readingFromClosedReadableByteChannelMustThrow() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);){
            ReadableByteChannel channel = pf.openReadableByteChannel();
            channel.close();
            this.expectedException.expect(ClosedChannelException.class);
            channel.read(ByteBuffer.allocate(this.recordSize));
            Assert.fail((String)"That read should have thrown");
        }
    }

    @Test(timeout=10000L)
    public void writableByteChannelMustBeOpenUntilClosed() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            WritableByteChannel channel;
            try (WritableByteChannel ch = pf.openWritableByteChannel();){
                Assert.assertTrue((boolean)ch.isOpen());
                channel = ch;
            }
            Assert.assertFalse((boolean)channel.isOpen());
        }
    }

    @Test(timeout=10000L)
    public void writableByteChannelMustWriteAllBytesInFile() throws Exception {
        File file = this.file("a");
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);){
            try (Channel channel = pf.openWritableByteChannel();){
                this.generateFileWithRecords((WritableByteChannel)channel, this.recordCount, this.recordSize);
            }
            channel = pf.openReadableByteChannel();
            var5_7 = null;
            try {
                this.verifyRecordsInFile((ReadableByteChannel)channel, this.recordCount);
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (channel != null) {
                    if (var5_7 != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        channel.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void writingToClosedWritableByteChannelMustThrow() throws Exception {
        File file = this.file("a");
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);){
            WritableByteChannel channel = pf.openWritableByteChannel();
            channel.close();
            this.expectedException.expect(ClosedChannelException.class);
            channel.write(ByteBuffer.allocate(this.recordSize));
            Assert.fail((String)"That read should have thrown");
        }
    }

    @Test
    public void sizeOfEmptyFileMustBeZero() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            Assert.assertThat((Object)pf.fileSize(), (Matcher)Matchers.is((Object)0L));
        }
    }

    @Test
    public void fileSizeMustIncreaseInPageIncrements() throws Exception {
        long increment = this.filePageSize;
        this.configureStandardPageCache();
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)pf.fileSize(), (Matcher)Matchers.is((Object)increment));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)pf.fileSize(), (Matcher)Matchers.is((Object)(2L * increment)));
        }
    }

    @Test
    public void streamFilesRecursiveMustBeEmptyForEmptyBaseDirectory() throws Exception {
        this.configureStandardPageCache();
        File dir = this.existingDirectory("dir");
        Assert.assertThat((Object)this.pageCache.streamFilesRecursive(dir).count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void streamFilesRecursiveMustListAllFilesInBaseDirectory() throws Exception {
        this.configureStandardPageCache();
        File a = this.existingFile("a");
        File b = this.existingFile("b");
        File c = this.existingFile("c");
        Stream stream = this.pageCache.streamFilesRecursive(a.getParentFile());
        List filepaths = stream.map(FileHandle::getFile).collect(Collectors.toList());
        Assert.assertThat(filepaths, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{a.getCanonicalFile(), b.getCanonicalFile(), c.getCanonicalFile()}));
    }

    @Test
    public void streamFilesRecursiveMustListAllFilesInSubDirectories() throws Exception {
        this.configureStandardPageCache();
        File sub1 = this.existingDirectory("sub1");
        File sub2 = this.existingDirectory("sub2");
        File a = this.existingFile("a");
        File b = new File(sub1, "b");
        File c = new File(sub2, "c");
        this.ensureExists(b);
        this.ensureExists(c);
        Stream stream = this.pageCache.streamFilesRecursive(a.getParentFile());
        List filepaths = stream.map(FileHandle::getFile).collect(Collectors.toList());
        Assert.assertThat(filepaths, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{a.getCanonicalFile(), b.getCanonicalFile(), c.getCanonicalFile()}));
    }

    @Test
    public void streamFilesRecursiveMustNotListSubDirectories() throws Exception {
        this.configureStandardPageCache();
        File sub1 = this.existingDirectory("sub1");
        File sub2 = this.existingDirectory("sub2");
        File sub2sub1 = new File(sub2, "sub1");
        this.ensureDirectoryExists(sub2sub1);
        this.existingDirectory("sub3");
        File a = this.existingFile("a");
        File b = new File(sub1, "b");
        File c = new File(sub2, "c");
        this.ensureExists(b);
        this.ensureExists(c);
        Stream stream = this.pageCache.streamFilesRecursive(a.getParentFile());
        List filepaths = stream.map(FileHandle::getFile).collect(Collectors.toList());
        Assert.assertThat(filepaths, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{a.getCanonicalFile(), b.getCanonicalFile(), c.getCanonicalFile()}));
    }

    @Test
    public void streamFilesRecursiveFilePathsMustBeCanonical() throws Exception {
        this.configureStandardPageCache();
        File sub = this.existingDirectory("sub");
        File a = new File(new File(new File(sub, ".."), "sub"), "a");
        this.ensureExists(a);
        Stream stream = this.pageCache.streamFilesRecursive(sub.getParentFile());
        List filepaths = stream.map(FileHandle::getFile).collect(Collectors.toList());
        Assert.assertThat(filepaths, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{a.getCanonicalFile(), this.file("a").getCanonicalFile()}));
    }

    @Test
    public void streamFilesRecursiveMustListSingleFileGivenAsBase() throws Exception {
        this.configureStandardPageCache();
        this.existingDirectory("sub");
        this.existingFile("sub/x");
        File a = this.file("a");
        Stream stream = this.pageCache.streamFilesRecursive(a);
        List filepaths = stream.map(FileHandle::getFile).collect(Collectors.toList());
        Assert.assertThat(filepaths, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{a.getCanonicalFile()}));
    }

    @Test
    public void streamFilesRecursiveListedSingleFileMustHaveCanonicalPath() throws Exception {
        this.configureStandardPageCache();
        File sub = this.existingDirectory("sub");
        this.existingFile("sub/x");
        File a = this.file("a");
        File queryForA = new File(new File(sub, ".."), "a");
        Stream stream = this.pageCache.streamFilesRecursive(queryForA);
        List filepaths = stream.map(FileHandle::getFile).collect(Collectors.toList());
        Assert.assertThat(filepaths, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{a.getCanonicalFile()}));
    }

    @Test
    public void streamFilesRecursiveMustThrowOnNonExistingBasePath() throws Exception {
        this.configureStandardPageCache();
        File nonExisting = this.file("nonExisting");
        this.expectedException.expect(NoSuchFileException.class);
        this.pageCache.streamFilesRecursive(nonExisting);
    }

    @Test
    public void streamFilesRecursiveMustRenameFiles() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File b = this.file("b");
        File base = a.getParentFile();
        Iterable handles = this.pageCache.streamFilesRecursive(base)::iterator;
        for (FileHandle fh : handles) {
            fh.rename(b, new CopyOption[0]);
        }
        List filepaths = this.pageCache.streamFilesRecursive(base).map(FileHandle::getFile).collect(Collectors.toList());
        Assert.assertThat(filepaths, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{b.getCanonicalFile()}));
    }

    @Test
    public void streamFilesRecursiveMustDeleteFiles() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File b = this.file("b");
        File c = this.file("c");
        this.ensureExists(a);
        this.ensureExists(b);
        this.ensureExists(c);
        File base = a.getParentFile();
        Iterable handles = this.pageCache.streamFilesRecursive(base)::iterator;
        for (FileHandle fh : handles) {
            fh.delete();
        }
        Assert.assertFalse((boolean)this.fs.fileExists(a));
        Assert.assertFalse((boolean)this.fs.fileExists(b));
        Assert.assertFalse((boolean)this.fs.fileExists(c));
    }

    @Test
    public void streamFilesRecursiveMustThrowWhenRenamingMappedSourceFile() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File b = this.file("b");
        try (PagedFile ignore = this.pageCache.map(a, this.filePageSize, new OpenOption[0]);){
            Iterable handles = this.pageCache.streamFilesRecursive(a.getParentFile())::iterator;
            for (FileHandle handle : handles) {
                this.expectedException.expect(FileIsMappedException.class);
                handle.rename(b, new CopyOption[0]);
            }
        }
    }

    @Test
    public void streamFilesRecursiveMustThrowWhenRenamingMappedTargetFile() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File b = this.existingFile("b");
        try (PagedFile ignore = this.pageCache.map(b, this.filePageSize, new OpenOption[0]);){
            Stream<FileHandle> streamOfA = this.pageCache.streamFilesRecursive(a.getParentFile()).filter(this.hasFile(a));
            Iterable handles = streamOfA::iterator;
            for (FileHandle handle : handles) {
                this.expectedException.expect(FileIsMappedException.class);
                handle.rename(b, new CopyOption[0]);
            }
        }
    }

    private Predicate<FileHandle> hasFile(File a) {
        return fh -> fh.getFile().equals(a);
    }

    @Test
    public void streamFilesRecursiveMustThrowWhenDeletingMappedFile() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        try (PagedFile ignore = this.pageCache.map(a, this.filePageSize, new OpenOption[0]);){
            FileHandle handle = (FileHandle)this.pageCache.streamFilesRecursive(a).findAny().get();
            this.expectedException.expect(FileIsMappedException.class);
            handle.delete();
        }
    }

    @Test
    public void streamFilesRecursiveMustThrowWhenDeletingNonExistingFile() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        FileHandle handle = (FileHandle)this.pageCache.streamFilesRecursive(a).findAny().get();
        this.fs.deleteFile(a);
        this.expectedException.expect(NoSuchFileException.class);
        handle.delete();
    }

    @Test
    public void streamFilesRecursiveMustThrowWhenTargetFileOfRenameAlreadyExists() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File b = this.existingFile("b");
        FileHandle handle = (FileHandle)this.pageCache.streamFilesRecursive(a).findAny().get();
        this.expectedException.expect(FileAlreadyExistsException.class);
        handle.rename(b, new CopyOption[0]);
    }

    @Test
    public void streamFilesRecursiveMustNotThrowWhenTargetFileOfRenameAlreadyExistsAndUsingReplaceExisting() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File b = this.existingFile("b");
        FileHandle handle = (FileHandle)this.pageCache.streamFilesRecursive(a).findAny().get();
        handle.rename(b, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
    }

    @Test
    public void streamFilesRecursiveMustDeleteSubDirectoriesEmptiedByFileRename() throws Exception {
        this.configureStandardPageCache();
        File sub = this.existingDirectory("sub");
        File x = new File(sub, "x");
        this.ensureExists(x);
        File target = this.file("target");
        Iterable handles = this.pageCache.streamFilesRecursive(sub)::iterator;
        for (FileHandle handle : handles) {
            handle.rename(target, new CopyOption[0]);
        }
        Assert.assertFalse((boolean)this.fs.isDirectory(sub));
        Assert.assertFalse((boolean)this.fs.fileExists(sub));
    }

    @Test
    public void streamFilesRecursiveMustDeleteMultipleLayersOfSubDirectoriesIfTheyBecomeEmptyByRename() throws Exception {
        this.configureStandardPageCache();
        File sub = this.existingDirectory("sub");
        File subsub = new File(sub, "subsub");
        this.ensureDirectoryExists(subsub);
        File x = new File(subsub, "x");
        this.ensureExists(x);
        File target = this.file("target");
        Iterable handles = this.pageCache.streamFilesRecursive(sub)::iterator;
        for (FileHandle handle : handles) {
            handle.rename(target, new CopyOption[0]);
        }
        Assert.assertFalse((boolean)this.fs.isDirectory(subsub));
        Assert.assertFalse((boolean)this.fs.fileExists(subsub));
        Assert.assertFalse((boolean)this.fs.isDirectory(sub));
        Assert.assertFalse((boolean)this.fs.fileExists(sub));
    }

    @Test
    public void streamFilesRecursiveMustNotDeleteDirectoriesAboveBaseDirectoryIfTheyBecomeEmptyByRename() throws Exception {
        this.configureStandardPageCache();
        File sub = this.existingDirectory("sub");
        File subsub = new File(sub, "subsub");
        File subsubsub = new File(subsub, "subsubsub");
        this.ensureDirectoryExists(subsub);
        this.ensureDirectoryExists(subsubsub);
        File x = new File(subsubsub, "x");
        this.ensureExists(x);
        File target = this.file("target");
        Iterable handles = this.pageCache.streamFilesRecursive(subsub)::iterator;
        for (FileHandle handle : handles) {
            handle.rename(target, new CopyOption[0]);
        }
        Assert.assertFalse((boolean)this.fs.fileExists(subsubsub));
        Assert.assertFalse((boolean)this.fs.isDirectory(subsubsub));
        Assert.assertFalse((boolean)this.fs.fileExists(subsub));
        Assert.assertFalse((boolean)this.fs.isDirectory(subsub));
        Assert.assertTrue((boolean)this.fs.fileExists(sub));
        Assert.assertTrue((boolean)this.fs.isDirectory(sub));
    }

    @Test
    public void streamFilesRecursiveMustDeleteSubDirectoriesEmptiedByFileDelete() throws Exception {
        this.configureStandardPageCache();
        File sub = this.existingDirectory("sub");
        File x = new File(sub, "x");
        this.ensureExists(x);
        Iterable handles = this.pageCache.streamFilesRecursive(sub)::iterator;
        for (FileHandle handle : handles) {
            handle.delete();
        }
        Assert.assertFalse((boolean)this.fs.isDirectory(sub));
        Assert.assertFalse((boolean)this.fs.fileExists(sub));
    }

    @Test
    public void streamFilesRecursiveMustDeleteMultipleLayersOfSubDirectoriesIfTheyBecomeEmptyByDelete() throws Exception {
        this.configureStandardPageCache();
        File sub = this.existingDirectory("sub");
        File subsub = new File(sub, "subsub");
        this.ensureDirectoryExists(subsub);
        File x = new File(subsub, "x");
        this.ensureExists(x);
        Iterable handles = this.pageCache.streamFilesRecursive(sub)::iterator;
        for (FileHandle handle : handles) {
            handle.delete();
        }
        Assert.assertFalse((boolean)this.fs.isDirectory(subsub));
        Assert.assertFalse((boolean)this.fs.fileExists(subsub));
        Assert.assertFalse((boolean)this.fs.isDirectory(sub));
        Assert.assertFalse((boolean)this.fs.fileExists(sub));
    }

    @Test
    public void streamFilesRecursiveMustNotDeleteDirectoriesAboveBaseDirectoryIfTheyBecomeEmptyByDelete() throws Exception {
        this.configureStandardPageCache();
        File sub = this.existingDirectory("sub");
        File subsub = new File(sub, "subsub");
        File subsubsub = new File(subsub, "subsubsub");
        this.ensureDirectoryExists(subsub);
        this.ensureDirectoryExists(subsubsub);
        File x = new File(subsubsub, "x");
        this.ensureExists(x);
        Iterable handles = this.pageCache.streamFilesRecursive(subsub)::iterator;
        for (FileHandle handle : handles) {
            handle.delete();
        }
        Assert.assertFalse((boolean)this.fs.fileExists(subsubsub));
        Assert.assertFalse((boolean)this.fs.isDirectory(subsubsub));
        Assert.assertFalse((boolean)this.fs.fileExists(subsub));
        Assert.assertFalse((boolean)this.fs.isDirectory(subsub));
        Assert.assertTrue((boolean)this.fs.fileExists(sub));
        Assert.assertTrue((boolean)this.fs.isDirectory(sub));
    }

    @Test
    public void streamFilesRecursiveMustCreateMissingPathDirectoriesImpliedByFileRename() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File sub = this.file("sub");
        File target = new File(sub, "b");
        FileHandle handle = (FileHandle)this.pageCache.streamFilesRecursive(a).findAny().get();
        handle.rename(target, new CopyOption[0]);
        Assert.assertTrue((boolean)this.fs.isDirectory(sub));
        Assert.assertTrue((boolean)this.fs.fileExists(target));
    }

    @Test
    public void streamFilesRecursiveMustNotSeeFilesLaterCreatedBaseDirectory() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        Stream stream = this.pageCache.streamFilesRecursive(a.getParentFile());
        File b = this.existingFile("b");
        Set files = stream.map(FileHandle::getFile).collect(Collectors.toSet());
        Assert.assertThat(files, (Matcher)Matchers.contains((Object[])new File[]{a}));
        Assert.assertThat(files, (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new File[]{b})));
    }

    @Test
    public void streamFilesRecursiveMustNotSeeFilesRenamedIntoBaseDirectory() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File sub = this.existingDirectory("sub");
        File x = new File(sub, "x");
        this.ensureExists(x);
        File target = this.file("target");
        Iterable handles = this.pageCache.streamFilesRecursive(a.getParentFile())::iterator;
        HashSet<File> observedFiles = new HashSet<File>();
        for (FileHandle handle : handles) {
            File file = handle.getFile();
            observedFiles.add(file);
            if (!file.equals(x)) continue;
            handle.rename(target, new CopyOption[0]);
        }
        Assert.assertThat(observedFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{a, x}));
    }

    @Test
    public void streamFilesRecursiveMustNotSeeFilesRenamedIntoSubDirectory() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File sub = this.existingDirectory("sub");
        File target = new File(sub, "target");
        Iterable handles = this.pageCache.streamFilesRecursive(a.getParentFile())::iterator;
        HashSet<File> observedFiles = new HashSet<File>();
        for (FileHandle handle : handles) {
            File file = handle.getFile();
            observedFiles.add(file);
            if (!file.equals(a)) continue;
            handle.rename(target, new CopyOption[0]);
        }
        Assert.assertThat(observedFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{a}));
    }

    @Test
    public void streamFilesRecursiveRenameMustCanonicaliseSourceFile() throws Exception {
        this.configureStandardPageCache();
        File a = new File(new File(this.file("a"), "poke"), "..");
        File b = this.file("b");
        FileHandle handle = (FileHandle)this.pageCache.streamFilesRecursive(a).findAny().get();
        handle.rename(b, new CopyOption[0]);
    }

    @Test
    public void streamFilesRecursiveRenameMustCanonicaliseTargetFile() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File b = new File(new File(this.file("b"), "poke"), "..");
        FileHandle handle = (FileHandle)this.pageCache.streamFilesRecursive(a).findAny().get();
        handle.rename(b, new CopyOption[0]);
    }

    @Test
    public void streamFilesRecursiveRenameTargetFileMustBeMappable() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File b = this.file("b");
        FileHandle handle = (FileHandle)this.pageCache.streamFilesRecursive(a).findAny().get();
        handle.rename(b, new CopyOption[0]);
        this.pageCache.map(b, this.filePageSize, new OpenOption[0]).close();
    }

    @Test
    public void streamFilesRecursiveSourceFileMustNotBeMappableAfterRename() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File b = this.file("b");
        FileHandle handle = (FileHandle)this.pageCache.streamFilesRecursive(a).findAny().get();
        handle.rename(b, new CopyOption[0]);
        this.expectedException.expect(NoSuchFileException.class);
        this.pageCache.map(a, this.filePageSize, new OpenOption[0]);
        Assert.fail((String)"pageCache.map should have thrown");
    }

    @Test
    public void streamFilesRecursiveRenameMustNotChangeSourceFileContents() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File b = this.file("b");
        this.generateFileWithRecords(a, this.recordCount, this.recordSize);
        FileHandle handle = (FileHandle)this.pageCache.streamFilesRecursive(a).findAny().get();
        handle.rename(b, new CopyOption[0]);
        this.verifyRecordsInFile(b, this.recordCount);
    }

    @Test
    public void streamFilesRecursiveRenameMustNotChangeSourceFileContentsWithReplaceExisting() throws Exception {
        this.configureStandardPageCache();
        File a = this.file("a");
        File b = this.existingFile("b");
        this.generateFileWithRecords(a, this.recordCount, this.recordSize);
        this.generateFileWithRecords(b, this.recordCount + this.recordsPerFilePage, this.recordSize);
        try (PagedFile pf = this.pageCache.map(b, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 6);){
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            while (cursor.next()) {
                int pageSize = cursor.getCurrentPageSize();
                for (int i = 0; i < pageSize; ++i) {
                    cursor.putByte(i, (byte)rng.nextInt());
                }
            }
        }
        FileHandle handle = (FileHandle)this.pageCache.streamFilesRecursive(a).findAny().get();
        handle.rename(b, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        this.verifyRecordsInFile(b, this.recordCount);
    }

    private static interface PageCursorAction {
        public void apply(PageCursor var1);
    }
}

