/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.Digests;

public class TestDirectory
implements TestRule {
    private final FileSystemAbstraction fileSystem;
    private File testClassBaseFolder;
    private Class<?> owningTest;
    private boolean keepDirectoryAfterSuccessfulTest;
    private File testDirectory = null;

    private TestDirectory(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
    }

    private TestDirectory(FileSystemAbstraction fileSystem, Class<?> owningTest) {
        this.fileSystem = fileSystem;
        this.owningTest = owningTest;
    }

    public static TestDirectory testDirectory() {
        return new TestDirectory((FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    public static TestDirectory testDirectory(FileSystemAbstraction fs) {
        return new TestDirectory(fs);
    }

    public static TestDirectory testDirectory(Class<?> owningTest) {
        return new TestDirectory((FileSystemAbstraction)new DefaultFileSystemAbstraction(), owningTest);
    }

    public static TestDirectory testDirectory(Class<?> owningTest, FileSystemAbstraction fs) {
        return new TestDirectory(fs, owningTest);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestDirectory.this.testDirectory = TestDirectory.this.directoryForDescription(description);
                boolean success = false;
                try {
                    base.evaluate();
                    success = true;
                }
                finally {
                    TestDirectory.this.complete(success);
                }
            }
        };
    }

    public TestDirectory keepDirectoryAfterSuccessfulTest() {
        this.keepDirectoryAfterSuccessfulTest = true;
        return this;
    }

    public File absolutePath() {
        return this.directory().getAbsoluteFile();
    }

    public File directory() {
        if (this.testDirectory == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.testDirectory;
    }

    public File directory(String name) {
        File dir = new File(this.directory(), name);
        if (!this.fileSystem.fileExists(dir)) {
            this.fileSystem.mkdir(dir);
        }
        return dir;
    }

    public File file(String name) {
        return new File(this.directory(), name);
    }

    public File graphDbDir() {
        return this.directory("graph-db");
    }

    public File makeGraphDbDir() throws IOException {
        return this.cleanDirectory("graph-db");
    }

    public void cleanup() throws IOException {
        TestDirectory.clean(this.fileSystem, this.testClassBaseFolder);
    }

    public String toString() {
        String testDirectoryName = this.testDirectory == null ? "<uninitialized>" : this.testDirectory.toString();
        return String.format("%s[%s]", this.getClass().getSimpleName(), testDirectoryName);
    }

    public File cleanDirectory(String name) throws IOException {
        return TestDirectory.clean(this.fileSystem, new File(this.ensureBase(), name));
    }

    private static File clean(FileSystemAbstraction fs, File dir) throws IOException {
        if (fs.fileExists(dir)) {
            fs.deleteRecursively(dir);
        }
        fs.mkdirs(dir);
        return dir;
    }

    private void complete(boolean success) {
        if (success && this.testDirectory != null && !this.keepDirectoryAfterSuccessfulTest) {
            try {
                this.fileSystem.deleteRecursively(this.testDirectory);
            }
            catch (FileUtils.MaybeWindowsMemoryMappedFileReleaseProblem fme) {
                System.err.println("Failed to delete test directory, maybe due to Windows memory-mapped file problem: " + fme.getMessage());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.testDirectory = null;
    }

    private File directoryForDescription(Description description) throws IOException {
        if (this.owningTest == null) {
            this.owningTest = description.getTestClass();
        }
        this.evaluateClassBaseTestFolder();
        String test = description.getMethodName();
        if (test == null) {
            test = "static";
        }
        String dir = Digests.md5Hex(test);
        this.register(test, dir);
        return this.cleanDirectory(dir);
    }

    private void evaluateClassBaseTestFolder() {
        if (this.owningTest == null) {
            throw new IllegalStateException(" Test owning class is not defined");
        }
        try {
            this.testClassBaseFolder = TestDirectory.testDataDirectoryOf(this.fileSystem, this.owningTest, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File testDataDirectoryOf(FileSystemAbstraction fs, Class<?> owningTest, boolean clean) throws IOException {
        File testData = new File(TestDirectory.locateTarget(owningTest), "test-data");
        File result = new File(testData, owningTest.getName()).getAbsoluteFile();
        if (clean) {
            TestDirectory.clean(fs, result);
        }
        return result;
    }

    private void register(String test, String dir) {
        try {
            FileUtils.writeToFile((File)new File(this.ensureBase(), ".register"), (String)String.format("%s=%s\n", dir, test), (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File ensureBase() {
        if (this.testClassBaseFolder == null) {
            this.evaluateClassBaseTestFolder();
        }
        if (this.fileSystem.fileExists(this.testClassBaseFolder) && !this.fileSystem.isDirectory(this.testClassBaseFolder)) {
            throw new IllegalStateException(this.testClassBaseFolder + " exists and is not a directory!");
        }
        try {
            this.fileSystem.mkdirs(this.testClassBaseFolder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.testClassBaseFolder;
    }

    private static File locateTarget(Class<?> owningTest) {
        try {
            File codeSource = new File(owningTest.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (codeSource.isDirectory()) {
                return codeSource.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return new File("target");
    }
}

