/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;

public final class PagedWritableByteChannel
implements WritableByteChannel {
    private final PageCursor cursor;
    private boolean open = true;
    private int bytesLeftInCurrentPage;

    public PagedWritableByteChannel(PagedFile pagedFile) throws IOException {
        this.cursor = pagedFile.io(0L, 2);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        if (this.bytesLeftInCurrentPage == 0) {
            if (!this.cursor.next()) {
                throw new IOException("Could not advance write cursor");
            }
            this.bytesLeftInCurrentPage = this.cursor.getCurrentPageSize();
        }
        int position = src.position();
        int remaining = Math.min(src.remaining(), this.bytesLeftInCurrentPage);
        int offset = this.cursor.getOffset();
        do {
            src.position(position);
            this.cursor.setOffset(offset);
            for (int i = 0; i < remaining; ++i) {
                this.cursor.putByte(src.get());
            }
        } while (this.cursor.shouldRetry());
        this.bytesLeftInCurrentPage -= remaining;
        return remaining;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        this.cursor.close();
    }
}

