/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class SequenceLock {
    private static final long CNT_BITS = 17L;
    private static final long BITS_IN_LONG = 64L;
    private static final long EXL_LOCK_BITS = 1L;
    private static final long FLS_LOCK_BITS = 1L;
    private static final long SEQ_BITS = 45L;
    private static final long CNT_UNIT = 0x200000000000L;
    private static final long SEQ_MASK = 0x1FFFFFFFFFFFL;
    private static final long SEQ_IMSK = -35184372088832L;
    private static final long CNT_MASK = 4611650834055299072L;
    private static final long EXL_MASK = 0x4000000000000000L;
    private static final long FLS_MASK = Long.MIN_VALUE;
    private static final long FLS_IMSK = Long.MAX_VALUE;
    private static final long FAE_MASK = -4611686018427387904L;
    private static final long UNL_MASK = -35184372088832L;
    private static final long STATE = UnsafeUtil.getFieldOffset(SequenceLock.class, (String)"state");
    private volatile long state;

    private long getState() {
        return this.state;
    }

    private boolean compareAndSetState(long expect, long update) {
        return UnsafeUtil.compareAndSwapLong((Object)this, (long)STATE, (long)expect, (long)update);
    }

    private void unconditionallySetState(long update) {
        this.state = update;
    }

    public long tryOptimisticReadLock() {
        return this.getState() & 0x1FFFFFFFFFFFL;
    }

    public boolean validateReadLock(long stamp) {
        UnsafeUtil.loadFence();
        return (this.getState() & Long.MAX_VALUE) == stamp;
    }

    public boolean tryWriteLock() {
        long n;
        long s;
        do {
            boolean writeCountOverflow;
            boolean unwritablyLocked = ((s = this.getState()) & 0x4000000000000000L) != 0L;
            boolean bl = writeCountOverflow = (s & 0x3FFFE00000000000L) == 4611650834055299072L;
            if (!(unwritablyLocked | writeCountOverflow)) continue;
            return this.failWriteLock(s, writeCountOverflow);
        } while (!this.compareAndSetState(s, n = s + 0x200000000000L));
        UnsafeUtil.storeFence();
        return true;
    }

    private boolean failWriteLock(long s, boolean writeCountOverflow) {
        if (writeCountOverflow) {
            this.throwWriteLockOverflow(s);
        }
        return false;
    }

    private long throwWriteLockOverflow(long s) {
        throw new IllegalMonitorStateException("Write lock counter overflow: " + this.describeState(s));
    }

    public void unlockWrite() {
        long n;
        long s;
        do {
            if (((s = this.getState()) & 0x3FFFE00000000000L) != 0L) continue;
            this.throwUnmatchedUnlockWrite(s);
        } while (!this.compareAndSetState(s, n = this.nextSeq(s) - 0x200000000000L));
    }

    private void throwUnmatchedUnlockWrite(long s) {
        throw new IllegalMonitorStateException("Unmatched unlockWrite: " + this.describeState(s));
    }

    private long nextSeq(long s) {
        return (s & 0xFFFFE00000000000L) + (s + 1L & 0x1FFFFFFFFFFFL);
    }

    public boolean tryExclusiveLock() {
        long s = this.getState();
        boolean res = (s & 0xFFFFE00000000000L) == 0L && this.compareAndSetState(s, s + 0x4000000000000000L);
        UnsafeUtil.storeFence();
        return res;
    }

    public long unlockExclusive() {
        long s = this.initiateExclusiveLockRelease();
        long n = this.nextSeq(s) - 0x4000000000000000L;
        this.unconditionallySetState(n);
        return n;
    }

    public void unlockExclusiveAndTakeWriteLock() {
        long s = this.initiateExclusiveLockRelease();
        long n = this.nextSeq(s) - 0x4000000000000000L + 0x200000000000L;
        this.unconditionallySetState(n);
    }

    private long initiateExclusiveLockRelease() {
        long s = this.getState();
        if ((s & 0x4000000000000000L) != 0x4000000000000000L) {
            this.throwUnmatchedUnlockExclusive(s);
        }
        return s;
    }

    private void throwUnmatchedUnlockExclusive(long s) {
        throw new IllegalMonitorStateException("Unmatched unlockExclusive: " + this.describeState(s));
    }

    public boolean tryFlushLock() {
        long s = this.getState();
        boolean res = (s & 0xC000000000000000L) == 0L && this.compareAndSetState(s, s + Long.MIN_VALUE);
        UnsafeUtil.storeFence();
        return res;
    }

    public void unlockFlush() {
        long n;
        long s;
        do {
            if (((s = this.getState()) & Long.MIN_VALUE) == Long.MIN_VALUE) continue;
            this.throwUnmatchedUnlockFlush(s);
        } while (!this.compareAndSetState(s, n = s - Long.MIN_VALUE));
    }

    private void throwUnmatchedUnlockFlush(long s) {
        throw new IllegalMonitorStateException("Unmatched unlockFlush: " + this.describeState(s));
    }

    public String toString() {
        long s = this.getState();
        return this.describeState(s);
    }

    private String describeState(long s) {
        long flush = s >>> 63;
        long excl = (s & 0x4000000000000000L) >>> 62;
        long cnt = (s & 0x3FFFE00000000000L) >> 45;
        long seq = s & 0x1FFFFFFFFFFFL;
        return "SequenceLock[Flush: " + flush + ", Excl: " + excl + ", Ws: " + cnt + ", S: " + seq + ']';
    }
}

