/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Parameterized.class)
public class FileSystemAbstractionInterruptionTest {
    private static final Factory<FileSystemAbstraction> ephemeral = EphemeralFileSystemAbstraction::new;
    private static final Factory<FileSystemAbstraction> real = DefaultFileSystemAbstraction::new;
    @Rule
    public final TestDirectory testdir = TestDirectory.testDirectory();
    private FileSystemAbstraction fs;
    private File file;
    private StoreChannel channel;
    private boolean channelShouldBeClosed;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> dataPoints() {
        return Arrays.asList({"ephemeral", ephemeral}, {"real", real});
    }

    public FileSystemAbstractionInterruptionTest(String name, Factory<FileSystemAbstraction> factory) {
        this.fs = (FileSystemAbstraction)factory.newInstance();
    }

    @Before
    public void createWorkingDirectoryAndTestFile() throws IOException {
        Thread.interrupted();
        this.fs.mkdirs(this.testdir.directory());
        this.file = this.testdir.file("a");
        this.fs.create(this.file).close();
        this.channel = null;
        this.channelShouldBeClosed = false;
        Thread.currentThread().interrupt();
    }

    @After
    public void verifyInterruptionAndChannelState() throws IOException {
        Assert.assertTrue((boolean)Thread.interrupted());
        Assert.assertThat((String)("channelShouldBeClosed? " + this.channelShouldBeClosed), (Object)this.channel.isOpen(), (Matcher)Matchers.is((Object)(!this.channelShouldBeClosed ? 1 : 0)));
        if (this.channelShouldBeClosed) {
            try {
                this.channel.force(true);
                Assert.fail((String)"Operating on a closed channel should fail");
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
    }

    private StoreChannel chan(boolean channelShouldBeClosed) throws IOException {
        this.channelShouldBeClosed = channelShouldBeClosed;
        this.channel = this.fs.open(this.file, "rw");
        return this.channel;
    }

    @Test
    public void fs_openClose() throws IOException {
        this.chan(true).close();
    }

    @Test
    public void ch_tryLock() throws IOException {
        this.chan(false).tryLock().release();
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_setPosition() throws IOException {
        this.chan(true).position(0L);
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_getPosition() throws IOException {
        this.chan(true).position();
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_truncate() throws IOException {
        this.chan(true).truncate(0L);
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_force() throws IOException {
        this.chan(true).force(true);
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_writeAll_ByteBuffer() throws IOException {
        this.chan(true).writeAll(ByteBuffer.allocate(1));
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_writeAll_ByteBuffer_position() throws IOException {
        this.chan(true).writeAll(ByteBuffer.allocate(1), 1L);
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_write_ByteBuffer_position() throws IOException {
        this.chan(true).write(ByteBuffer.allocate(1), 1L);
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_read_ByteBuffer() throws IOException {
        this.chan(true).read(ByteBuffer.allocate(1));
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_write_ByteBuffer() throws IOException {
        this.chan(true).write(ByteBuffer.allocate(1));
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_size() throws IOException {
        this.chan(true).size();
    }

    @Test
    public void ch_isOpen() throws IOException {
        this.chan(false).isOpen();
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_write_ByteBuffers_offset_length() throws IOException {
        this.chan(true).write(new ByteBuffer[]{ByteBuffer.allocate(1)}, 0, 1);
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_write_ByteBuffers() throws IOException {
        this.chan(true).write(new ByteBuffer[]{ByteBuffer.allocate(1)});
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_read_ByteBuffers_offset_length() throws IOException {
        this.chan(true).read(new ByteBuffer[]{ByteBuffer.allocate(1)}, 0, 1);
    }

    @Test(expected=ClosedByInterruptException.class)
    public void ch_read_ByteBuffers() throws IOException {
        this.chan(true).read(new ByteBuffer[]{ByteBuffer.allocate(1)});
    }
}

