/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.pagecache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.adversaries.Adversary;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.impl.DelegatingPageCursor;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

class AdversarialReadPageCursor
extends DelegatingPageCursor {
    private static final boolean enableInconsistencyTracing = FeatureToggles.flag(AdversarialReadPageCursor.class, (String)"enableInconsistencyTracing", (boolean)false);
    private AdversarialReadPageCursor linkedCursor;
    private final State state;

    AdversarialReadPageCursor(PageCursor delegate, Adversary adversary) {
        super(delegate);
        this.state = new State(Objects.requireNonNull(adversary));
    }

    private AdversarialReadPageCursor(PageCursor delegate, State state) {
        super(delegate);
        this.state = state;
    }

    public byte getByte() {
        return this.inconsistently(this.delegate.getByte()).byteValue();
    }

    private <T extends Number> Number inconsistently(T value) {
        return this.state.inconsistently(value, this.delegate);
    }

    private void inconsistently(byte[] data) {
        this.state.inconsistently(data);
    }

    public byte getByte(int offset) {
        return this.inconsistently(this.delegate.getByte(offset)).byteValue();
    }

    public void putByte(byte value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void putByte(int offset, byte value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public long getLong() {
        return this.inconsistently(this.delegate.getLong()).longValue();
    }

    public long getLong(int offset) {
        return this.inconsistently(this.delegate.getLong(offset)).longValue();
    }

    public void putLong(long value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void putLong(int offset, long value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public int getInt() {
        return this.inconsistently(this.delegate.getInt()).intValue();
    }

    public int getInt(int offset) {
        return this.inconsistently(this.delegate.getInt(offset)).intValue();
    }

    public void putInt(int value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void putInt(int offset, int value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void getBytes(byte[] data) {
        this.delegate.getBytes(data);
        this.inconsistently(data);
    }

    public void getBytes(byte[] data, int arrayOffset, int length) {
        this.delegate.getBytes(data, arrayOffset, length);
        this.inconsistently(data);
    }

    public void putBytes(byte[] data) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void putBytes(byte[] data, int arrayOffset, int length) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public short getShort() {
        return this.inconsistently(this.delegate.getShort()).shortValue();
    }

    public short getShort(int offset) {
        return this.inconsistently(this.delegate.getShort(offset)).shortValue();
    }

    public void putShort(short value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void putShort(int offset, short value) {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public void setOffset(int offset) {
        this.state.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.setOffset(offset);
    }

    public int getOffset() {
        return this.delegate.getOffset();
    }

    public long getCurrentPageId() {
        return this.delegate.getCurrentPageId();
    }

    public int getCurrentPageSize() {
        return this.delegate.getCurrentPageSize();
    }

    public File getCurrentFile() {
        return this.delegate.getCurrentFile();
    }

    public void rewind() {
        this.delegate.rewind();
    }

    public boolean next() throws IOException {
        this.prepareNext();
        return this.delegate.next();
    }

    public boolean next(long pageId) throws IOException {
        this.prepareNext();
        return this.delegate.next(pageId);
    }

    private void prepareNext() {
        boolean currentReadIsPreparingInconsistent = this.state.injectFailureOrMischief(FileNotFoundException.class, IOException.class, SecurityException.class, IllegalStateException.class);
        this.state.reset(currentReadIsPreparingInconsistent);
    }

    public void close() {
        this.delegate.close();
        this.linkedCursor = null;
    }

    public boolean shouldRetry() throws IOException {
        this.state.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class, IllegalStateException.class);
        if (this.state.hasPreparedInconsistentRead()) {
            this.resetDelegate();
            return true;
        }
        if (this.state.hasInconsistentRead()) {
            this.resetDelegate();
            return true;
        }
        boolean retry = this.delegate.shouldRetry();
        return retry || this.linkedCursor != null && this.linkedCursor.shouldRetry();
    }

    private void resetDelegate() throws IOException {
        this.delegate.shouldRetry();
        this.delegate.setOffset(0);
        this.delegate.checkAndClearBoundsFlag();
        this.delegate.clearCursorException();
    }

    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        this.state.injectFailure(IndexOutOfBoundsException.class);
        if (!this.state.isInconsistent()) {
            while (targetCursor instanceof DelegatingPageCursor) {
                targetCursor = ((DelegatingPageCursor)targetCursor).unwrap();
            }
            return this.delegate.copyTo(sourceOffset, targetCursor, targetOffset, lengthInBytes);
        }
        return lengthInBytes;
    }

    public boolean checkAndClearBoundsFlag() {
        return this.delegate.checkAndClearBoundsFlag() || this.linkedCursor != null && this.linkedCursor.checkAndClearBoundsFlag();
    }

    public void checkAndClearCursorException() throws CursorException {
        this.delegate.checkAndClearCursorException();
    }

    public void raiseOutOfBounds() {
        this.delegate.raiseOutOfBounds();
    }

    public void setCursorException(String message) {
        this.delegate.setCursorException(message);
    }

    public void clearCursorException() {
        this.delegate.clearCursorException();
    }

    public PageCursor openLinkedCursor(long pageId) {
        this.linkedCursor = new AdversarialReadPageCursor(this.delegate.openLinkedCursor(pageId), this.state);
        return this.linkedCursor;
    }

    public void zapPage() {
        throw new IllegalStateException("Cannot write using read cursor");
    }

    public boolean isWriteLocked() {
        return this.delegate.isWriteLocked();
    }

    public String toString() {
        State s = this.state;
        StringBuilder sb = new StringBuilder();
        for (Object o : s.inconsistentReadHistory) {
            sb.append(o.toString()).append('\n');
            if (!(o instanceof NumberValue)) continue;
            NumberValue v = (NumberValue)o;
            v.printStackTrace(sb);
        }
        return sb.toString();
    }

    private static class NumberValue {
        private final Class<? extends Number> type;
        private final long value;
        private final int offset;
        private final Number insteadOf;
        private Exception trace;

        NumberValue(Class<? extends Number> type, long value, int offset, Number insteadOf) {
            this.type = type;
            this.value = value;
            this.offset = offset;
            this.insteadOf = insteadOf;
            if (enableInconsistencyTracing) {
                this.trace = new Exception(){

                    @Override
                    public String getMessage() {
                        return this.toString();
                    }
                };
            }
        }

        public String toString() {
            String typeName;
            switch (typeName = this.type.getCanonicalName()) {
                case "java.lang.Byte": {
                    return "(byte)" + this.value + " at offset " + this.offset + " (instead of " + this.insteadOf + ")";
                }
                case "java.lang.Short": {
                    return "(short)" + this.value + " at offset " + this.offset + " (instead of " + this.insteadOf + ")";
                }
                case "java.lang.Integer": {
                    return "(int)" + this.value + " at offset " + this.offset + " (instead of " + this.insteadOf + ")";
                }
                case "java.lang.Long": {
                    return "(long)" + this.value + " at offset " + this.offset + " (instead of " + this.insteadOf + ")";
                }
            }
            return "(" + typeName + ")" + this.value + " at offset " + this.offset + " (instead of " + this.insteadOf + ")";
        }

        public void printStackTrace(StringBuilder sb) {
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            if (this.trace != null) {
                this.trace.printStackTrace(pw);
            }
            pw.flush();
            sb.append(w);
            sb.append('\n');
        }
    }

    private static class State
    implements Adversary {
        private final Adversary adversary;
        private boolean currentReadIsPreparingInconsistent;
        private boolean currentReadIsInconsistent;
        private int callCounter;
        private List<Object> inconsistentReadHistory;

        private State(Adversary adversary) {
            this.adversary = adversary;
            this.inconsistentReadHistory = new ArrayList<Object>(32);
        }

        private <T extends Number> Number inconsistently(T value, PageCursor delegate) {
            if (this.currentReadIsPreparingInconsistent) {
                ++this.callCounter;
                return value;
            }
            if (this.currentReadIsInconsistent && --this.callCounter <= 0) {
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                long x = value.longValue();
                x = x != 0L & rng.nextBoolean() ? (x ^= 0xFFFFFFFFFFFFFFFFL) : rng.nextLong();
                this.inconsistentReadHistory.add(new NumberValue(value.getClass(), x, delegate.getOffset(), value));
                return x;
            }
            return value;
        }

        private void inconsistently(byte[] data) {
            if (this.currentReadIsPreparingInconsistent) {
                ++this.callCounter;
            } else if (this.currentReadIsInconsistent) {
                ThreadLocalRandom.current().nextBytes(data);
                this.inconsistentReadHistory.add(Arrays.copyOf(data, data.length));
            }
        }

        private void reset(boolean currentReadIsPreparingInconsistent) {
            this.callCounter = 0;
            this.currentReadIsPreparingInconsistent = currentReadIsPreparingInconsistent;
        }

        @Override
        public void injectFailure(Class<? extends Throwable> ... failureTypes) {
            this.adversary.injectFailure(failureTypes);
        }

        @Override
        public boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
            return this.adversary.injectFailureOrMischief(failureTypes);
        }

        private boolean hasPreparedInconsistentRead() {
            if (this.currentReadIsPreparingInconsistent) {
                this.currentReadIsPreparingInconsistent = false;
                this.currentReadIsInconsistent = true;
                this.callCounter = ThreadLocalRandom.current().nextInt(this.callCounter + 1);
                this.inconsistentReadHistory = new ArrayList<Object>();
                return true;
            }
            return false;
        }

        private boolean hasInconsistentRead() {
            if (this.currentReadIsInconsistent) {
                this.currentReadIsInconsistent = false;
                return true;
            }
            return false;
        }

        public boolean isInconsistent() {
            if (this.currentReadIsPreparingInconsistent) {
                ++this.callCounter;
            }
            return this.currentReadIsInconsistent;
        }
    }
}

