/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.neo4j.function.Predicates;
import org.neo4j.io.fs.FileVisitors;

@RunWith(value=MockitoJUnitRunner.class)
public class OnlyMatchingFileVisitorTest {
    @Mock
    public FileVisitor<Path> wrapped;

    @Test
    public void shouldNotDelegatePreVisitDirectoryIfPredicateDoesntMatch() throws IOException {
        FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).preVisitDirectory(null, null);
        ((FileVisitor)Mockito.verify(this.wrapped, (VerificationMode)Mockito.never())).preVisitDirectory(Matchers.any(), (BasicFileAttributes)Matchers.any());
    }

    @Test
    public void shouldNotDelegatePostVisitDirectoryIfPredicateDoesntMatch() throws IOException {
        FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).postVisitDirectory(null, null);
        ((FileVisitor)Mockito.verify(this.wrapped, (VerificationMode)Mockito.never())).postVisitDirectory(Matchers.any(), (IOException)Matchers.any());
    }

    @Test
    public void shouldNotDelegateVisitFileIfPredicateDoesntMatch() throws IOException {
        FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).visitFile(null, null);
        ((FileVisitor)Mockito.verify(this.wrapped, (VerificationMode)Mockito.never())).visitFile(Matchers.any(), (BasicFileAttributes)Matchers.any());
    }

    @Test
    public void shouldNotDelegateVisitFileFailedIfPredicateDoesntMatch() throws IOException {
        FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).visitFileFailed(null, null);
        ((FileVisitor)Mockito.verify(this.wrapped, (VerificationMode)Mockito.never())).visitFileFailed(Matchers.any(), (IOException)Matchers.any());
    }

    @Test
    public void shouldNotSkipSubtreeFromPreVisitDirectoryIfPredicateDoesntMatch() throws IOException {
        Assert.assertThat((Object)((Object)FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).preVisitDirectory(null, null)), (Matcher)org.hamcrest.Matchers.is((Object)((Object)FileVisitResult.SKIP_SUBTREE)));
    }

    @Test
    public void shouldContinueAfterPostVisitDirectoryIfPredicateDoesntMatch() throws IOException {
        Assert.assertThat((Object)((Object)FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).postVisitDirectory(null, null)), (Matcher)org.hamcrest.Matchers.is((Object)((Object)FileVisitResult.CONTINUE)));
    }

    @Test
    public void shouldContinueAfterVisitFileIfPredicateDoesntMatch() throws IOException {
        Assert.assertThat((Object)((Object)FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).visitFile(null, null)), (Matcher)org.hamcrest.Matchers.is((Object)((Object)FileVisitResult.CONTINUE)));
    }

    @Test
    public void shouldContinueAfterVisitFileFailedIfPredicateDoesntMatch() throws IOException {
        Assert.assertThat((Object)((Object)FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).visitFileFailed(null, null)), (Matcher)org.hamcrest.Matchers.is((Object)((Object)FileVisitResult.CONTINUE)));
    }
}

