/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.randomharness;

import java.io.File;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.TinyLockManager;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.randomharness.Action;
import org.neo4j.io.pagecache.randomharness.Command;
import org.neo4j.io.pagecache.randomharness.Record;
import org.neo4j.io.pagecache.randomharness.RecordFormat;

class CommandPrimer {
    private final Random rng;
    private final MuninnPageCache cache;
    private final File[] files;
    private final Map<File, PagedFile> fileMap;
    private final Map<File, List<Integer>> recordsWrittenTo;
    private final List<File> mappedFiles;
    private final Set<File> filesTouched;
    private final int filePageCount;
    private final int filePageSize;
    private final RecordFormat recordFormat;
    private final int maxRecordCount;
    private final int recordsPerPage;
    private final TinyLockManager recordLocks;

    CommandPrimer(Random rng, MuninnPageCache cache, File[] files, Map<File, PagedFile> fileMap, int filePageCount, int filePageSize, RecordFormat recordFormat) {
        this.rng = rng;
        this.cache = cache;
        this.files = files;
        this.fileMap = fileMap;
        this.filePageCount = filePageCount;
        this.filePageSize = filePageSize;
        this.recordFormat = recordFormat;
        this.mappedFiles = new ArrayList<File>();
        this.mappedFiles.addAll(fileMap.keySet());
        this.filesTouched = new HashSet<File>();
        this.filesTouched.addAll(this.mappedFiles);
        this.recordsWrittenTo = new HashMap<File, List<Integer>>();
        this.recordsPerPage = cache.pageSize() / recordFormat.getRecordSize();
        this.maxRecordCount = filePageCount * this.recordsPerPage;
        this.recordLocks = new TinyLockManager();
        for (File file : files) {
            this.recordsWrittenTo.put(file, new ArrayList());
        }
    }

    public List<File> getMappedFiles() {
        return this.mappedFiles;
    }

    public Set<File> getFilesTouched() {
        return this.filesTouched;
    }

    public Action prime(Command command) {
        switch (command) {
            case FlushCache: {
                return this.flushCache();
            }
            case FlushFile: {
                return this.flushFile();
            }
            case MapFile: {
                return this.mapFile();
            }
            case UnmapFile: {
                return this.unmapFile();
            }
            case ReadRecord: {
                return this.readRecord();
            }
            case WriteRecord: {
                return this.writeRecord();
            }
            case ReadMulti: {
                return this.readMulti();
            }
            case WriteMulti: {
                return this.writeMulti();
            }
        }
        throw new IllegalArgumentException("Unknown command: " + (Object)((Object)command));
    }

    private Action flushCache() {
        return new Action(Command.FlushCache, "", new Object[0]){

            @Override
            public void perform() throws Exception {
                CommandPrimer.this.cache.flushAndForce();
            }
        };
    }

    private Action flushFile() {
        if (this.mappedFiles.size() > 0) {
            final File file = this.mappedFiles.get(this.rng.nextInt(this.mappedFiles.size()));
            return new Action(Command.FlushFile, "[file=%s]", new Object[]{file.getName()}){

                @Override
                public void perform() throws Exception {
                    PagedFile pagedFile = (PagedFile)CommandPrimer.this.fileMap.get(file);
                    if (pagedFile != null) {
                        pagedFile.flushAndForce();
                    }
                }
            };
        }
        return new Action(Command.FlushFile, "[no files mapped to flush]", new Object[0]){

            @Override
            public void perform() throws Exception {
            }
        };
    }

    private Action mapFile() {
        final File file = this.files[this.rng.nextInt(this.files.length)];
        this.mappedFiles.add(file);
        this.filesTouched.add(file);
        return new Action(Command.MapFile, "[file=%s]", new Object[]{file}){

            @Override
            public void perform() throws Exception {
                CommandPrimer.this.fileMap.put(file, CommandPrimer.this.cache.map(file, CommandPrimer.this.filePageSize, new OpenOption[0]));
            }
        };
    }

    private Action unmapFile() {
        if (this.mappedFiles.size() > 0) {
            final File file = this.mappedFiles.remove(this.rng.nextInt(this.mappedFiles.size()));
            return new Action(Command.UnmapFile, "[file=%s]", new Object[]{file}){

                @Override
                public void perform() throws Exception {
                    ((PagedFile)CommandPrimer.this.fileMap.get(file)).close();
                }
            };
        }
        return null;
    }

    private Action readRecord() {
        return this.buildReadRecord(null);
    }

    private Action writeRecord() {
        return this.buildWriteAction(null, Primitive.longSet());
    }

    private Action readMulti() {
        int count = this.rng.nextInt(5) + 1;
        Action action = null;
        for (int i = 0; i < count; ++i) {
            action = this.buildReadRecord(action);
        }
        return action;
    }

    private Action writeMulti() {
        int count = this.rng.nextInt(5) + 1;
        PrimitiveLongSet recordIds = Primitive.longSet();
        Action action = null;
        for (int i = 0; i < count; ++i) {
            action = this.buildWriteAction(action, recordIds);
        }
        return action;
    }

    private Action buildReadRecord(Action innerAction) {
        int mappedFilesCount = this.mappedFiles.size();
        if (mappedFilesCount == 0) {
            return innerAction;
        }
        File file = this.mappedFiles.get(this.rng.nextInt(mappedFilesCount));
        List<Integer> recordsWritten = this.recordsWrittenTo.get(file);
        int recordId = recordsWritten.isEmpty() ? this.rng.nextInt(this.maxRecordCount) : recordsWritten.get(this.rng.nextInt(recordsWritten.size())).intValue();
        int pageId = recordId / this.recordsPerPage;
        int pageOffset = recordId % this.recordsPerPage * this.recordFormat.getRecordSize();
        Record expectedRecord = this.recordFormat.createRecord(file, recordId);
        return new ReadAction(file, recordId, pageId, pageOffset, expectedRecord, innerAction);
    }

    private Action buildWriteAction(Action innerAction, PrimitiveLongSet forbiddenRecordIds) {
        int recordId;
        int mappedFilesCount = this.mappedFiles.size();
        if (mappedFilesCount == 0) {
            return innerAction;
        }
        File file = this.mappedFiles.get(this.rng.nextInt(mappedFilesCount));
        this.filesTouched.add(file);
        while (forbiddenRecordIds.contains((long)(recordId = this.rng.nextInt(this.filePageCount * this.recordsPerPage)))) {
        }
        this.recordsWrittenTo.get(file).add(recordId);
        int pageId = recordId / this.recordsPerPage;
        int pageOffset = recordId % this.recordsPerPage * this.recordFormat.getRecordSize();
        Record record = this.recordFormat.createRecord(file, recordId);
        return new WriteAction(file, recordId, pageId, pageOffset, record, innerAction);
    }

    private class WriteAction
    extends Action {
        private final File file;
        private final int recordId;
        private final int pageId;
        private final int pageOffset;
        private final Record record;

        WriteAction(File file, int recordId, int pageId, int pageOffset, Record record, Action innerAction) {
            super(Command.WriteRecord, innerAction, "[file=%s, recordId=%s, pageId=%s, pageOffset=%s, record=%s]", file, recordId, pageId, pageOffset, record);
            this.file = file;
            this.recordId = recordId;
            this.pageId = pageId;
            this.pageOffset = pageOffset;
            this.record = record;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void perform() throws Exception {
            PagedFile pagedFile = (PagedFile)CommandPrimer.this.fileMap.get(this.file);
            if (pagedFile != null) {
                if (!CommandPrimer.this.recordLocks.tryLock(this.recordId)) return;
                try (PageCursor cursor = pagedFile.io((long)this.pageId, 2);){
                    if (!cursor.next()) return;
                    cursor.setOffset(this.pageOffset);
                    CommandPrimer.this.recordFormat.write(this.record, cursor);
                    this.performInnerAction();
                    return;
                }
                finally {
                    CommandPrimer.this.recordLocks.unlock(this.recordId);
                }
            } else {
                this.performInnerAction();
            }
        }
    }

    private class ReadAction
    extends Action {
        private final File file;
        private final int pageId;
        private final int pageOffset;
        private final Record expectedRecord;

        ReadAction(File file, int recordId, int pageId, int pageOffset, Record expectedRecord, Action innerAction) {
            super(Command.ReadRecord, innerAction, "[file=%s, recordId=%s, pageId=%s, pageOffset=%s, expectedRecord=%s]", file, recordId, pageId, pageOffset, expectedRecord);
            this.file = file;
            this.pageId = pageId;
            this.pageOffset = pageOffset;
            this.expectedRecord = expectedRecord;
        }

        @Override
        public void perform() throws Exception {
            PagedFile pagedFile = (PagedFile)CommandPrimer.this.fileMap.get(this.file);
            if (pagedFile != null) {
                try (PageCursor cursor = pagedFile.io((long)this.pageId, 1);){
                    if (cursor.next()) {
                        cursor.setOffset(this.pageOffset);
                        Record actualRecord = CommandPrimer.this.recordFormat.readRecord(cursor);
                        Assert.assertThat((Object)actualRecord, (Matcher)Matchers.isOneOf((Object[])new Record[]{this.expectedRecord, CommandPrimer.this.recordFormat.zeroRecord()}));
                        this.performInnerAction();
                    }
                }
            }
        }
    }
}

