/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.util.function.Function;
import org.neo4j.graphdb.mockfs.SelectiveFileWatcher;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.watcher.FileWatcher;

public class SelectiveFileSystemAbstraction
implements FileSystemAbstraction {
    private final File specialFile;
    private final FileSystemAbstraction specialFileSystem;
    private final FileSystemAbstraction defaultFileSystem;

    public SelectiveFileSystemAbstraction(File specialFile, FileSystemAbstraction specialFileSystem, FileSystemAbstraction defaultFileSystem) {
        this.specialFile = specialFile;
        this.specialFileSystem = specialFileSystem;
        this.defaultFileSystem = defaultFileSystem;
    }

    public FileWatcher fileWatcher() throws IOException {
        return new SelectiveFileWatcher(this.specialFile, this.defaultFileSystem.fileWatcher(), this.specialFileSystem.fileWatcher());
    }

    public StoreChannel open(File fileName, String mode) throws IOException {
        return this.chooseFileSystem(fileName).open(fileName, mode);
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return this.chooseFileSystem(fileName).openAsOutputStream(fileName, append);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        return this.chooseFileSystem(fileName).openAsInputStream(fileName);
    }

    public Reader openAsReader(File fileName, Charset charset) throws IOException {
        return this.chooseFileSystem(fileName).openAsReader(fileName, charset);
    }

    public Writer openAsWriter(File fileName, Charset charset, boolean append) throws IOException {
        return this.chooseFileSystem(fileName).openAsWriter(fileName, charset, append);
    }

    public StoreChannel create(File fileName) throws IOException {
        return this.chooseFileSystem(fileName).create(fileName);
    }

    public boolean fileExists(File fileName) {
        return this.chooseFileSystem(fileName).fileExists(fileName);
    }

    public boolean mkdir(File fileName) {
        return this.chooseFileSystem(fileName).mkdir(fileName);
    }

    public void mkdirs(File fileName) throws IOException {
        this.chooseFileSystem(fileName).mkdirs(fileName);
    }

    public long getFileSize(File fileName) {
        return this.chooseFileSystem(fileName).getFileSize(fileName);
    }

    public boolean deleteFile(File fileName) {
        return this.chooseFileSystem(fileName).deleteFile(fileName);
    }

    public void deleteRecursively(File directory) throws IOException {
        this.chooseFileSystem(directory).deleteRecursively(directory);
    }

    public void renameFile(File from, File to, CopyOption ... copyOptions) throws IOException {
        this.chooseFileSystem(from).renameFile(from, to, copyOptions);
    }

    public File[] listFiles(File directory) {
        return this.chooseFileSystem(directory).listFiles(directory);
    }

    public File[] listFiles(File directory, FilenameFilter filter) {
        return this.chooseFileSystem(directory).listFiles(directory, filter);
    }

    public boolean isDirectory(File file) {
        return this.chooseFileSystem(file).isDirectory(file);
    }

    public void moveToDirectory(File file, File toDirectory) throws IOException {
        this.chooseFileSystem(file).moveToDirectory(file, toDirectory);
    }

    public void copyFile(File from, File to) throws IOException {
        this.chooseFileSystem(from).copyFile(from, to);
    }

    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.chooseFileSystem(fromDirectory).copyRecursively(fromDirectory, toDirectory);
    }

    public <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        return (K)this.defaultFileSystem.getOrCreateThirdPartyFileSystem(clazz, creator);
    }

    public void truncate(File path, long size) throws IOException {
        this.chooseFileSystem(path).truncate(path, size);
    }

    public long lastModifiedTime(File file) throws IOException {
        return this.chooseFileSystem(file).lastModifiedTime(file);
    }

    public void deleteFileOrThrow(File file) throws IOException {
        this.chooseFileSystem(file).deleteFileOrThrow(file);
    }

    private FileSystemAbstraction chooseFileSystem(File file) {
        return file.equals(this.specialFile) ? this.specialFileSystem : this.defaultFileSystem;
    }

    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new FileSystemAbstraction[]{this.specialFileSystem, this.defaultFileSystem});
    }
}

