/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs.watcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.ThrowsExceptionClass;
import org.mockito.stubbing.Answer;
import org.neo4j.io.fs.watcher.DefaultFileSystemWatcher;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.resource.WatchedResource;
import org.neo4j.test.rule.TestDirectory;

public class DefaultFileSystemWatcherTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private WatchService watchServiceMock = (WatchService)Mockito.mock(WatchService.class);

    @Test
    public void fileWatchRegistrationIsIllegal() throws Exception {
        TestFileSystemWatcher watcher = this.createWatcher();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Only directories can be registered to be monitored.");
        watcher.watch(new File("notADirectory"));
    }

    @Test
    public void registerMultipleDirectoriesForMonitoring() throws Exception {
        try (DefaultFileSystemWatcher watcher = new DefaultFileSystemWatcher(FileSystems.getDefault().newWatchService());){
            File directory1 = this.testDirectory.directory("test1");
            File directory2 = this.testDirectory.directory("test2");
            WatchedResource watchedResource1 = watcher.watch(directory1);
            WatchedResource watchedResource2 = watcher.watch(directory2);
            Assert.assertNotSame((Object)watchedResource1, (Object)watchedResource2);
        }
    }

    @Test
    public void notifyListenersOnDeletion() throws InterruptedException {
        TestFileSystemWatcher watcher = this.createWatcher();
        AssertableFileEventListener listener1 = new AssertableFileEventListener();
        AssertableFileEventListener listener2 = new AssertableFileEventListener();
        watcher.addFileWatchEventListener(listener1);
        watcher.addFileWatchEventListener(listener2);
        TestWatchEvent<Path> watchEvent = new TestWatchEvent<Path>(StandardWatchEventKinds.ENTRY_DELETE, Paths.get("file1", new String[0]));
        TestWatchEvent<Path> watchEvent2 = new TestWatchEvent<Path>(StandardWatchEventKinds.ENTRY_DELETE, Paths.get("file2", new String[0]));
        TestWatchKey watchKey = new TestWatchKey(Arrays.asList(watchEvent, watchEvent2));
        this.prepareWatcher(watchKey);
        this.watch(watcher);
        listener1.assertDeleted("file1");
        listener1.assertDeleted("file2");
        listener2.assertDeleted("file1");
        listener2.assertDeleted("file2");
    }

    @Test
    public void notifyListenersOnModification() throws InterruptedException {
        TestFileSystemWatcher watcher = this.createWatcher();
        AssertableFileEventListener listener1 = new AssertableFileEventListener();
        AssertableFileEventListener listener2 = new AssertableFileEventListener();
        watcher.addFileWatchEventListener(listener1);
        watcher.addFileWatchEventListener(listener2);
        TestWatchEvent<Path> watchEvent = new TestWatchEvent<Path>(StandardWatchEventKinds.ENTRY_MODIFY, Paths.get("a", new String[0]));
        TestWatchEvent<Path> watchEvent2 = new TestWatchEvent<Path>(StandardWatchEventKinds.ENTRY_MODIFY, Paths.get("b", new String[0]));
        TestWatchEvent<Path> watchEvent3 = new TestWatchEvent<Path>(StandardWatchEventKinds.ENTRY_MODIFY, Paths.get("c", new String[0]));
        TestWatchKey watchKey = new TestWatchKey(Arrays.asList(watchEvent, watchEvent2, watchEvent3));
        this.prepareWatcher(watchKey);
        this.watch(watcher);
        listener1.assertModified("a");
        listener1.assertModified("b");
        listener1.assertModified("c");
        listener2.assertModified("a");
        listener2.assertModified("b");
        listener2.assertModified("c");
    }

    @Test
    public void stopWatchingAndCloseEverythingOnClosed() throws IOException {
        TestFileSystemWatcher watcher = this.createWatcher();
        watcher.close();
        ((WatchService)Mockito.verify((Object)this.watchServiceMock)).close();
        Assert.assertTrue((boolean)watcher.isClosed());
    }

    @Test
    public void skipEmptyEvent() throws InterruptedException {
        TestFileSystemWatcher watcher = this.createWatcher();
        AssertableFileEventListener listener = new AssertableFileEventListener();
        watcher.addFileWatchEventListener(listener);
        TestWatchEvent<Object> event = new TestWatchEvent<Object>(StandardWatchEventKinds.ENTRY_MODIFY, null);
        TestWatchKey watchKey = new TestWatchKey(Arrays.asList(event));
        this.prepareWatcher(watchKey);
        this.watch(watcher);
        listener.assertNoEvents();
    }

    private void prepareWatcher(TestWatchKey watchKey) throws InterruptedException {
        Mockito.when((Object)this.watchServiceMock.take()).thenReturn((Object)watchKey).thenAnswer((Answer)new ThrowsExceptionClass(InterruptedException.class));
    }

    private void watch(TestFileSystemWatcher watcher) {
        try {
            watcher.startWatching();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private TestFileSystemWatcher createWatcher() {
        return new TestFileSystemWatcher(this.watchServiceMock);
    }

    private static class AssertableFileEventListener
    implements FileWatchEventListener {
        private final List<String> deletedFileNames = new ArrayList<String>();
        private final List<String> modifiedFileNames = new ArrayList<String>();

        private AssertableFileEventListener() {
        }

        public void fileDeleted(String fileName) {
            this.deletedFileNames.add(fileName);
        }

        public void fileModified(String fileName) {
            this.modifiedFileNames.add(fileName);
        }

        void assertNoEvents() {
            Assert.assertThat((String)"Should not have any deletion events", this.deletedFileNames, (Matcher)Matchers.empty());
            Assert.assertThat((String)"Should not have any modification events", this.modifiedFileNames, (Matcher)Matchers.empty());
        }

        void assertDeleted(String fileName) {
            Assert.assertThat((String)"Was expected to find notification about deletion.", this.deletedFileNames, (Matcher)Matchers.hasItem((Object)fileName));
        }

        void assertModified(String fileName) {
            Assert.assertThat((String)"Was expected to find notification about modification.", this.modifiedFileNames, (Matcher)Matchers.hasItem((Object)fileName));
        }
    }

    private static class TestWatchEvent<T>
    implements WatchEvent {
        private WatchEvent.Kind<T> eventKind;
        private T fileName;

        TestWatchEvent(WatchEvent.Kind<T> eventKind, T fileName) {
            this.eventKind = eventKind;
            this.fileName = fileName;
        }

        public WatchEvent.Kind kind() {
            return this.eventKind;
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public T context() {
            return this.fileName;
        }
    }

    private static class TestWatchKey
    implements WatchKey {
        private List<WatchEvent<?>> events;
        private boolean canceled;

        TestWatchKey(List<WatchEvent<?>> events) {
            this.events = events;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public List<WatchEvent<?>> pollEvents() {
            return this.events;
        }

        @Override
        public boolean reset() {
            return false;
        }

        @Override
        public void cancel() {
            this.canceled = true;
        }

        @Override
        public Watchable watchable() {
            return null;
        }

        public boolean isCanceled() {
            return this.canceled;
        }
    }

    private static class TestFileSystemWatcher
    extends DefaultFileSystemWatcher {
        private boolean closed;

        TestFileSystemWatcher(WatchService watchService) {
            super(watchService);
        }

        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

