/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.LimitedFileChannel;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.test.impl.ChannelInputStream;
import org.neo4j.test.impl.ChannelOutputStream;

public class LimitedFilesystemAbstraction
extends DelegatingFileSystemAbstraction {
    private volatile boolean outOfSpace;

    public LimitedFilesystemAbstraction(FileSystemAbstraction delegate) {
        super(delegate);
    }

    @Override
    public StoreChannel open(File fileName, OpenMode openMode) throws IOException {
        return new LimitedFileChannel(super.open(fileName, openMode), this);
    }

    @Override
    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return new ChannelOutputStream(this.open(fileName, OpenMode.READ_WRITE), append);
    }

    @Override
    public InputStream openAsInputStream(File fileName) throws IOException {
        return new ChannelInputStream(this.open(fileName, OpenMode.READ));
    }

    @Override
    public Reader openAsReader(File fileName, Charset charset) throws IOException {
        return new InputStreamReader(this.openAsInputStream(fileName), charset);
    }

    @Override
    public Writer openAsWriter(File fileName, Charset charset, boolean append) throws IOException {
        return new OutputStreamWriter(this.openAsOutputStream(fileName, append));
    }

    @Override
    public StoreChannel create(File fileName) throws IOException {
        this.ensureHasSpace();
        return new LimitedFileChannel(super.create(fileName), this);
    }

    @Override
    public void mkdirs(File fileName) throws IOException {
        this.ensureHasSpace();
        super.mkdirs(fileName);
    }

    @Override
    public void renameFile(File from, File to, CopyOption ... copyOptions) throws IOException {
        this.ensureHasSpace();
        super.renameFile(from, to, copyOptions);
    }

    public void runOutOfDiskSpace(boolean outOfSpace) {
        this.outOfSpace = outOfSpace;
    }

    public void ensureHasSpace() throws IOException {
        if (this.outOfSpace) {
            throw new IOException("No space left on device");
        }
    }
}

