/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.compress;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.compress.ZipUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ZipUtilsTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private DefaultFileSystemAbstraction fileSystem;

    @Before
    public void setUp() throws Exception {
        this.fileSystem = (DefaultFileSystemAbstraction)this.fileSystemRule.get();
    }

    @Test
    public void doNotCreateZipArchiveForNonExistentSource() throws IOException {
        File archiveFile = this.testDirectory.file("archive.zip");
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (File)this.testDirectory.file("doesNotExist"), (File)archiveFile);
        Assert.assertFalse((boolean)this.fileSystem.fileExists(archiveFile));
    }

    @Test
    public void doNotCreateZipArchiveForEmptyDirectory() throws IOException {
        File archiveFile = this.testDirectory.file("archive.zip");
        File emptyDirectory = this.testDirectory.directory("emptyDirectory");
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (File)emptyDirectory, (File)archiveFile);
        Assert.assertFalse((boolean)this.fileSystem.fileExists(archiveFile));
    }

    @Test
    public void archiveDirectory() throws IOException {
        File archiveFile = this.testDirectory.file("directoryArchive.zip");
        File directory = this.testDirectory.directory("directory");
        this.fileSystem.create(new File(directory, "a")).close();
        this.fileSystem.create(new File(directory, "b")).close();
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (File)directory, (File)archiveFile);
        Assert.assertTrue((boolean)this.fileSystem.fileExists(archiveFile));
        Assert.assertEquals((long)2L, (long)this.countArchiveEntries(archiveFile));
    }

    @Test
    public void archiveDirectoryWithSubdirectories() throws IOException {
        File archiveFile = this.testDirectory.file("directoryWithSubdirectoriesArchive.zip");
        File directoryArchive = this.testDirectory.directory("directoryWithSubdirs");
        File subdir1 = new File(directoryArchive, "subdir1");
        File subdir2 = new File(directoryArchive, "subdir");
        this.fileSystem.mkdir(subdir1);
        this.fileSystem.mkdir(subdir2);
        this.fileSystem.create(new File(directoryArchive, "a")).close();
        this.fileSystem.create(new File(directoryArchive, "b")).close();
        this.fileSystem.create(new File(subdir1, "c")).close();
        this.fileSystem.create(new File(subdir2, "d")).close();
        ZipUtils.zip(this.fileSystemRule.get(), (File)directoryArchive, (File)archiveFile);
        Assert.assertTrue((boolean)((DefaultFileSystemAbstraction)this.fileSystemRule.get()).fileExists(archiveFile));
        Assert.assertEquals((long)6L, (long)this.countArchiveEntries(archiveFile));
    }

    @Test
    public void archiveFile() throws IOException {
        File archiveFile = this.testDirectory.file("fileArchive.zip");
        File aFile = this.testDirectory.file("a");
        this.fileSystem.create(aFile).close();
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (File)aFile, (File)archiveFile);
        Assert.assertTrue((boolean)this.fileSystem.fileExists(archiveFile));
        Assert.assertEquals((long)1L, (long)this.countArchiveEntries(archiveFile));
    }

    @Test
    public void supportSpacesInDestinationPath() throws IOException {
        File archiveFile = this.testDirectory.file("file archive.zip");
        File aFile = this.testDirectory.file("a");
        this.fileSystem.create(aFile).close();
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (File)aFile, (File)archiveFile);
    }

    private int countArchiveEntries(File archiveFile) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(archiveFile)));){
            int entries = 0;
            while (zipInputStream.getNextEntry() != null) {
                ++entries;
            }
            int n = entries;
            return n;
        }
    }
}

