/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;

class SwapperSetTest {
    private SwapperSet set;

    SwapperSetTest() {
    }

    @BeforeEach
    void setUp() {
        this.set = new SwapperSet();
    }

    @Test
    void mustReturnAllocationWithSwapper() {
        DummyPageSwapper a = new DummyPageSwapper("a", 42);
        DummyPageSwapper b = new DummyPageSwapper("b", 43);
        int idA = this.set.allocate((PageSwapper)a);
        int idB = this.set.allocate((PageSwapper)b);
        SwapperSet.SwapperMapping allocA = this.set.getAllocation(idA);
        SwapperSet.SwapperMapping allocB = this.set.getAllocation(idB);
        MatcherAssert.assertThat((Object)allocA.swapper, (Matcher)Matchers.is((Object)a));
        MatcherAssert.assertThat((Object)allocB.swapper, (Matcher)Matchers.is((Object)b));
    }

    @Test
    void accessingFreedAllocationMustReturnNull() {
        int id = this.set.allocate((PageSwapper)new DummyPageSwapper("a", 42));
        this.set.free(id);
        Assertions.assertNull((Object)this.set.getAllocation(id));
    }

    @Test
    void doubleFreeMustThrow() {
        int id = this.set.allocate((PageSwapper)new DummyPageSwapper("a", 42));
        this.set.free(id);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.set.free(id));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"double free"));
    }

    @Test
    void freedIdsMustNotBeReusedBeforeVacuum() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        IntHashSet ids = new IntHashSet(10000);
        for (int i = 0; i < 10000; ++i) {
            this.allocateFreeAndAssertNotReused(swapper, (MutableIntSet)ids, i);
        }
    }

    private void allocateFreeAndAssertNotReused(PageSwapper swapper, MutableIntSet ids, int i) {
        int id = this.set.allocate(swapper);
        this.set.free(id);
        if (!ids.add(id)) {
            Assertions.fail((String)("Expected ids.add( id ) to return true for id " + id + " in iteration " + i + " but it instead returned false"));
        }
    }

    @Test
    void freedAllocationsMustBecomeAvailableAfterVacuum() {
        IntHashSet allocated = new IntHashSet();
        IntHashSet freed = new IntHashSet();
        IntHashSet vacuumed = new IntHashSet();
        IntHashSet reused = new IntHashSet();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        this.allocateAndAddTenThousand((MutableIntSet)allocated, swapper);
        allocated.forEach(arg_0 -> this.lambda$freedAllocationsMustBecomeAvailableAfterVacuum$f53d8ac5$1((MutableIntSet)freed, arg_0));
        this.set.vacuum(arg_0 -> ((MutableIntSet)vacuumed).addAll(arg_0));
        this.allocateAndAddTenThousand((MutableIntSet)reused, swapper);
        MatcherAssert.assertThat((Object)allocated, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)freed)));
        MatcherAssert.assertThat((Object)allocated, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)vacuumed)));
        MatcherAssert.assertThat((Object)allocated, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)reused)));
    }

    private void allocateAndAddTenThousand(MutableIntSet allocated, PageSwapper swapper) {
        for (int i = 0; i < 10000; ++i) {
            this.allocateAndAdd(allocated, swapper);
        }
    }

    private void allocateAndAdd(MutableIntSet allocated, PageSwapper swapper) {
        int id = this.set.allocate(swapper);
        allocated.add(id);
    }

    @Test
    void vacuumMustNotDustOffAnyIdsWhenNoneHaveBeenFreed() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        for (int i = 0; i < 100; ++i) {
            this.set.allocate((PageSwapper)swapper);
        }
        IntHashSet vacuumedIds = new IntHashSet();
        this.set.vacuum(arg_0 -> ((MutableIntSet)vacuumedIds).addAll(arg_0));
        if (!vacuumedIds.isEmpty()) {
            throw new AssertionError((Object)("Vacuum found id " + vacuumedIds + " when it should have found nothing"));
        }
    }

    @Test
    void mustNotUseZeroAsSwapperId() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        Matcher isNotZero = Matchers.is((Matcher)Matchers.not((Object)0));
        for (int i = 0; i < 10000; ++i) {
            MatcherAssert.assertThat((Object)this.set.allocate((PageSwapper)swapper), (Matcher)isNotZero);
        }
    }

    @Test
    void gettingAllocationZeroMustThrow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.set.getAllocation(0));
    }

    @Test
    void freeOfIdZeroMustThrow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.set.free(0));
    }

    @Test
    void mustKeepTrackOfAvailableSwapperIds() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        int initial = 0x1FFFFE;
        MatcherAssert.assertThat((Object)this.set.countAvailableIds(), (Matcher)Matchers.is((Object)initial));
        int id = this.set.allocate((PageSwapper)swapper);
        MatcherAssert.assertThat((Object)this.set.countAvailableIds(), (Matcher)Matchers.is((Object)(initial - 1)));
        this.set.free(id);
        MatcherAssert.assertThat((Object)this.set.countAvailableIds(), (Matcher)Matchers.is((Object)(initial - 1)));
        this.set.vacuum(x -> {});
        MatcherAssert.assertThat((Object)this.set.countAvailableIds(), (Matcher)Matchers.is((Object)initial));
    }

    private /* synthetic */ void lambda$freedAllocationsMustBecomeAvailableAfterVacuum$f53d8ac5$1(MutableIntSet freed, int id) {
        this.set.free(id);
        freed.add(id);
    }
}

