/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.Extensions;
import org.neo4j.resources.Profiler;
import org.neo4j.test.extension.ExecutionSharedContext;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.ProfilerExtension;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@Extensions(value={@ExtendWith(value={TestDirectoryExtension.class, ProfilerExtension.class}), @ExtendWith(value={ConfigurationParameterCondition.class})})
class ProfilerExtensionVerificationTest {
    static final String TEST_DIR = "test dir";
    @Inject
    TestDirectory testDirectory;
    @Inject
    Profiler profiler;

    ProfilerExtensionVerificationTest() {
    }

    @Test
    void testThatPasses() throws Exception {
        ExecutionSharedContext.CONTEXT.clear();
        ExecutionSharedContext.CONTEXT.setValue(TEST_DIR, this.testDirectory.absolutePath());
        this.profiler.profile();
        this.someVeryExpensiveComputation();
    }

    @Test
    void testThatFails() throws Exception {
        ExecutionSharedContext.CONTEXT.clear();
        ExecutionSharedContext.CONTEXT.setValue(TEST_DIR, this.testDirectory.absolutePath());
        this.profiler.profile();
        this.someVeryExpensiveComputation();
        Assertions.fail((String)"This is exactly like that 'worst movie death scene ever' from the Turkish film Kareteci Kiz.");
    }

    private void someVeryExpensiveComputation() throws InterruptedException {
        Thread.sleep(1000L);
    }

    static class ConfigurationParameterCondition
    implements ExecutionCondition {
        static final String TEST_TOGGLE = "testToggle";

        ConfigurationParameterCondition() {
        }

        public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
            Optional option = context.getConfigurationParameter(TEST_TOGGLE);
            return option.map(ConditionEvaluationResult::enabled).orElseGet(() -> ConditionEvaluationResult.disabled((String)"configuration parameter not present"));
        }
    }
}

