/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.io.pagecache.PageSwapper;

final class SwapperSet {
    private static final SwapperMapping SENTINEL = new SwapperMapping(0, null);
    private static final SwapperMapping TOMBSTONE = new SwapperMapping(0, null);
    private static final int MAX_SWAPPER_ID = 0x1FFFFF;
    private volatile SwapperMapping[] swapperMappings = new SwapperMapping[]{SENTINEL};
    private final MutableIntSet free = new IntHashSet();
    private final Object vacuumLock = new Object();
    private int freeCounter;

    SwapperSet() {
    }

    SwapperMapping getAllocation(int id) {
        this.checkId(id);
        SwapperMapping swapperMapping = this.swapperMappings[id];
        if (swapperMapping == null || swapperMapping == TOMBSTONE) {
            return null;
        }
        return swapperMapping;
    }

    private void checkId(int id) {
        if (id == 0) {
            throw new IllegalArgumentException("0 is an invalid swapper id");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int allocate(PageSwapper swapper) {
        SwapperMapping[] swapperMappings = this.swapperMappings;
        MutableIntSet mutableIntSet = this.free;
        synchronized (mutableIntSet) {
            if (!this.free.isEmpty()) {
                int id = this.free.intIterator().next();
                this.free.remove(id);
                swapperMappings[id] = new SwapperMapping(id, swapper);
                this.swapperMappings = swapperMappings;
                return id;
            }
        }
        int id = swapperMappings.length;
        if (id + 1 > 0x1FFFFF) {
            throw new IllegalStateException("All swapper ids are allocated: 2097151");
        }
        swapperMappings = Arrays.copyOf(swapperMappings, id + 1);
        swapperMappings[id] = new SwapperMapping(id, swapper);
        this.swapperMappings = swapperMappings;
        return id;
    }

    synchronized boolean free(int id) {
        this.checkId(id);
        SwapperMapping[] swapperMappings = this.swapperMappings;
        SwapperMapping current = swapperMappings[id];
        if (current == null || current == TOMBSTONE) {
            throw new IllegalStateException("PageSwapper allocation id " + id + " is currently not allocated. Likely a double free bug.");
        }
        swapperMappings[id] = TOMBSTONE;
        this.swapperMappings = swapperMappings;
        ++this.freeCounter;
        if (this.freeCounter == 20) {
            this.freeCounter = 0;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void vacuum(Consumer<IntSet> evictAllLoadedPagesCallback) {
        Object object = this.vacuumLock;
        synchronized (object) {
            IntHashSet freeIds = new IntHashSet();
            SwapperMapping[] swapperMappings = this.swapperMappings;
            for (int id = 0; id < swapperMappings.length; ++id) {
                SwapperMapping swapperMapping = swapperMappings[id];
                if (swapperMapping != TOMBSTONE) continue;
                freeIds.add(id);
            }
            evictAllLoadedPagesCallback.accept((IntSet)freeIds);
            SwapperSet swapperSet = this;
            synchronized (swapperSet) {
                MutableIntIterator itr = freeIds.intIterator();
                while (itr.hasNext()) {
                    int freeId = itr.next();
                    swapperMappings[freeId] = null;
                }
                this.swapperMappings = swapperMappings;
            }
            swapperSet = this.free;
            synchronized (swapperSet) {
                this.free.addAll((IntIterable)freeIds);
            }
        }
    }

    synchronized int countAvailableIds() {
        int available = 0x1FFFFF;
        available -= this.swapperMappings.length;
        return available += this.free.size();
    }

    static final class SwapperMapping {
        public final int id;
        public final PageSwapper swapper;

        private SwapperMapping(int id, PageSwapper swapper) {
            this.id = id;
            this.swapper = swapper;
        }
    }
}

