/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.neo4j.io.IOUtils;
import org.neo4j.test.matchers.NestedThrowableMatcher;

@RunWith(value=MockitoJUnitRunner.class)
public class IOUtilsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private AutoCloseable faultyClosable;
    @Mock
    private AutoCloseable goodClosable1;
    @Mock
    private AutoCloseable goodClosable2;

    @Test
    public void closeAllSilently() throws Exception {
        IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{this.goodClosable1, this.faultyClosable, this.goodClosable2});
        ((AutoCloseable)Mockito.verify((Object)this.goodClosable1)).close();
        ((AutoCloseable)Mockito.verify((Object)this.goodClosable2)).close();
        ((AutoCloseable)Mockito.verify((Object)this.faultyClosable)).close();
    }

    @Test
    public void closeAllAndRethrowException() throws Exception {
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Faulty closable")}).when((Object)this.faultyClosable)).close();
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage("Exception closing multiple resources");
        this.expectedException.expect((Matcher)new NestedThrowableMatcher(IOException.class));
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.goodClosable1, this.faultyClosable, this.goodClosable2});
    }

    @Test
    public void closeMustIgnoreNullResources() throws Exception {
        AutoCloseable a = () -> {};
        Object b = null;
        AutoCloseable c = () -> {};
        IOUtils.close(IOException::new, (AutoCloseable[])new AutoCloseable[]{a, b, c});
    }
}

