/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.io.File;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.Extensions;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.ExecutionSharedContext;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@Extensions(value={@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class}), @ExtendWith(value={ConfigurationParameterCondition.class})})
class DirectoryExtensionLifecycleVerificationTest {
    @Inject
    private TestDirectory directory;

    DirectoryExtensionLifecycleVerificationTest() {
    }

    @Test
    void executeAndCleanupDirectory() {
        File file = this.directory.createFile("a");
        Assertions.assertTrue((boolean)file.exists());
        ExecutionSharedContext.CONTEXT.setValue("successfulFileName", file);
    }

    @Test
    void failAndKeepDirectory() {
        File file = this.directory.createFile("b");
        ExecutionSharedContext.CONTEXT.setValue("failedFileName", file);
        throw new RuntimeException("simulate test failure");
    }

    @Test
    void lockFileAndFailToDeleteDirectory() {
        File nonDeletableDirectory = this.directory.directory("c");
        ExecutionSharedContext.CONTEXT.setValue("lockedFileName", nonDeletableDirectory);
        Assertions.assertTrue((boolean)nonDeletableDirectory.setReadable(false, false));
    }

    static class ConfigurationParameterCondition
    implements ExecutionCondition {
        static final String TEST_TOGGLE = "testToggle";

        ConfigurationParameterCondition() {
        }

        public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
            Optional option = context.getConfigurationParameter(TEST_TOGGLE);
            return option.map(ConditionEvaluationResult::enabled).orElseGet(() -> ConditionEvaluationResult.disabled((String)"configuration parameter not present"));
        }
    }
}

