/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={TestDirectoryExtension.class})
class ChannelOutputStreamTest {
    @Inject
    TestDirectory tmpDir;

    ChannelOutputStreamTest() {
    }

    @Test
    void shouldStoreAByteAtBoundary() throws Exception {
        try (EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();){
            File workFile = this.tmpDir.file("a");
            fs.mkdirs(this.tmpDir.directory());
            OutputStream out = fs.openAsOutputStream(workFile, false);
            byte[] b = new byte[8097];
            b[b.length - 1] = 7;
            out.write(b);
            out.flush();
            InputStream in = fs.openAsInputStream(workFile);
            in.skip(8096L);
            Assertions.assertEquals((int)7, (int)in.read());
        }
    }
}

