/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class PageCacheAndDependenciesRule
implements TestRule {
    private RuleChain chain;
    private FileSystemRule<? extends FileSystemAbstraction> fs;
    private TestDirectory directory;
    private PageCacheRule pageCacheRule;
    private PageCacheRule.PageCacheConfig pageCacheConfig = PageCacheRule.config();
    private Class<?> clazz;

    public PageCacheAndDependenciesRule with(FileSystemRule<? extends FileSystemAbstraction> fs) {
        this.fs = fs;
        return this;
    }

    public PageCacheAndDependenciesRule with(PageCacheRule.PageCacheConfig config) {
        this.pageCacheConfig = config;
        return this;
    }

    public PageCacheAndDependenciesRule with(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public Statement apply(Statement base, Description description) {
        if (this.chain == null) {
            if (this.fs == null) {
                this.fs = new EphemeralFileSystemRule();
            }
            this.pageCacheRule = new PageCacheRule(this.pageCacheConfig);
            this.directory = TestDirectory.testDirectory(this.clazz, this.fs);
            this.chain = RuleChain.outerRule(this.fs).around((TestRule)this.directory).around((TestRule)this.pageCacheRule);
        }
        return this.chain.apply(base, description);
    }

    public FileSystemRule<? extends FileSystemAbstraction> fileSystemRule() {
        return this.fs;
    }

    public FileSystemAbstraction fileSystem() {
        return this.fs.get();
    }

    public TestDirectory directory() {
        return this.directory;
    }

    public PageCacheRule pageCacheRule() {
        return this.pageCacheRule;
    }

    public PageCache pageCache() {
        return this.pageCacheRule.getPageCache(this.fs);
    }
}

