/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.io.fs.FileVisitors;

@RunWith(value=Parameterized.class)
public class FileVisitorsDecoratorsTest {
    @Parameterized.Parameter(value=0)
    public String name;
    @Parameterized.Parameter(value=1)
    public Function<FileVisitor<Path>, FileVisitor<Path>> decoratorConstructor;
    @Parameterized.Parameter(value=2)
    public boolean throwsExceptions;
    public FileVisitor<Path> wrapped = (FileVisitor)Mockito.mock(FileVisitor.class);
    public FileVisitor<Path> decorator;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> formats() {
        return Arrays.asList({"decorator", FileVisitors.Decorator::new, false}, {"onFile", wrapped -> FileVisitors.onFile((ThrowingConsumer)ThrowingConsumer.noop(), (FileVisitor)wrapped), false}, {"onDirectory", wrapped -> FileVisitors.onDirectory((ThrowingConsumer)ThrowingConsumer.noop(), (FileVisitor)wrapped), false}, {"throwExceptions", FileVisitors::throwExceptions, true}, {"onlyMatching", wrapped -> FileVisitors.onlyMatching((Predicate)Predicates.alwaysTrue(), (FileVisitor)wrapped), false});
    }

    @Before
    public void setup() {
        this.decorator = this.decoratorConstructor.apply(this.wrapped);
    }

    @Test
    public void shouldDelegatePreVisitDirectory() throws IOException {
        Path dir = Paths.get("some-dir", new String[0]);
        BasicFileAttributes attrs = (BasicFileAttributes)Mockito.mock(BasicFileAttributes.class);
        this.decorator.preVisitDirectory(dir, attrs);
        ((FileVisitor)Mockito.verify(this.wrapped)).preVisitDirectory(dir, attrs);
    }

    @Test
    public void shouldPropagateReturnValueFromPreVisitDirectory() throws IOException {
        for (FileVisitResult result : FileVisitResult.values()) {
            Mockito.when((Object)((Object)this.wrapped.preVisitDirectory((Path)ArgumentMatchers.any(), (BasicFileAttributes)ArgumentMatchers.any()))).thenReturn((Object)result);
            MatcherAssert.assertThat((Object)((Object)this.decorator.preVisitDirectory(null, null)), (Matcher)Matchers.is((Object)((Object)result)));
        }
    }

    @Test
    public void shouldPropagateExceptionsFromPreVisitDirectory() throws IOException {
        Mockito.when((Object)((Object)this.wrapped.preVisitDirectory((Path)ArgumentMatchers.any(), (BasicFileAttributes)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new IOException()});
        try {
            this.decorator.preVisitDirectory(null, null);
            Assert.fail((String)"expected exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void shouldDelegatePostVisitDirectory() throws IOException {
        Path dir = Paths.get("some-dir", new String[0]);
        IOException e = this.throwsExceptions ? null : new IOException();
        this.decorator.postVisitDirectory(dir, e);
        ((FileVisitor)Mockito.verify(this.wrapped)).postVisitDirectory(dir, e);
    }

    @Test
    public void shouldPropagateReturnValueFromPostVisitDirectory() throws IOException {
        for (FileVisitResult result : FileVisitResult.values()) {
            Mockito.when((Object)((Object)this.wrapped.postVisitDirectory((Path)ArgumentMatchers.any(), (IOException)ArgumentMatchers.any()))).thenReturn((Object)result);
            MatcherAssert.assertThat((Object)((Object)this.decorator.postVisitDirectory(null, null)), (Matcher)Matchers.is((Object)((Object)result)));
        }
    }

    @Test
    public void shouldPropagateExceptionsFromPostVisitDirectory() throws IOException {
        Mockito.when((Object)((Object)this.wrapped.postVisitDirectory((Path)ArgumentMatchers.any(), (IOException)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new IOException()});
        try {
            this.decorator.postVisitDirectory(null, null);
            Assert.fail((String)"expected exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void shouldDelegateVisitFile() throws IOException {
        Path dir = Paths.get("some-dir", new String[0]);
        BasicFileAttributes attrs = (BasicFileAttributes)Mockito.mock(BasicFileAttributes.class);
        this.decorator.visitFile(dir, attrs);
        ((FileVisitor)Mockito.verify(this.wrapped)).visitFile(dir, attrs);
    }

    @Test
    public void shouldPropagateReturnValueFromVisitFile() throws IOException {
        for (FileVisitResult result : FileVisitResult.values()) {
            Mockito.when((Object)((Object)this.wrapped.visitFile((Path)ArgumentMatchers.any(), (BasicFileAttributes)ArgumentMatchers.any()))).thenReturn((Object)result);
            MatcherAssert.assertThat((Object)((Object)this.decorator.visitFile(null, null)), (Matcher)Matchers.is((Object)((Object)result)));
        }
    }

    @Test
    public void shouldPropagateExceptionsFromVisitFile() throws IOException {
        Mockito.when((Object)((Object)this.wrapped.visitFile((Path)ArgumentMatchers.any(), (BasicFileAttributes)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new IOException()});
        try {
            this.decorator.visitFile(null, null);
            Assert.fail((String)"expected exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void shouldDelegateVisitFileFailed() throws IOException {
        Path dir = Paths.get("some-dir", new String[0]);
        IOException e = this.throwsExceptions ? null : new IOException();
        this.decorator.visitFileFailed(dir, e);
        ((FileVisitor)Mockito.verify(this.wrapped)).visitFileFailed(dir, e);
    }

    @Test
    public void shouldPropagateReturnValueFromVisitFileFailed() throws IOException {
        for (FileVisitResult result : FileVisitResult.values()) {
            Mockito.when((Object)((Object)this.wrapped.visitFileFailed((Path)ArgumentMatchers.any(), (IOException)ArgumentMatchers.any()))).thenReturn((Object)result);
            MatcherAssert.assertThat((Object)((Object)this.decorator.visitFileFailed(null, null)), (Matcher)Matchers.is((Object)((Object)result)));
        }
    }

    @Test
    public void shouldPropagateExceptionsFromVisitFileFailed() throws IOException {
        Mockito.when((Object)((Object)this.wrapped.visitFileFailed((Path)ArgumentMatchers.any(), (IOException)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new IOException()});
        try {
            this.decorator.visitFileFailed(null, null);
            Assert.fail((String)"expected exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

