/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.io.fs.OffsetChannel;
import org.neo4j.io.fs.StoreChannel;

class OffsetChannelTest {
    private long offset = 128L;
    private StoreChannel actual = (StoreChannel)Mockito.mock(StoreChannel.class);
    private OffsetChannel channel = new OffsetChannel(this.actual, this.offset);
    private ByteBuffer buf = ByteBuffer.allocate(0);
    private ByteBuffer[] buffers = new ByteBuffer[0];

    OffsetChannelTest() {
    }

    @Test
    void tryLock() throws Exception {
        this.channel.tryLock();
        ((StoreChannel)Mockito.verify((Object)this.actual)).tryLock();
    }

    @Test
    void write() throws Exception {
        this.channel.write(this.buf);
        ((StoreChannel)Mockito.verify((Object)this.actual)).write(this.buf);
    }

    @Test
    void writeAll() throws Exception {
        this.channel.writeAll(this.buf);
        ((StoreChannel)Mockito.verify((Object)this.actual)).writeAll(this.buf);
    }

    @Test
    void writeAllWithPosition() throws Exception {
        long position = 500L;
        this.channel.writeAll(this.buf, position);
        ((StoreChannel)Mockito.verify((Object)this.actual)).writeAll(this.buf, position + this.offset);
    }

    @Test
    void read() throws Exception {
        this.channel.read(this.buf);
        ((StoreChannel)Mockito.verify((Object)this.actual)).read(this.buf);
    }

    @Test
    void force() throws Exception {
        this.channel.force(false);
        ((StoreChannel)Mockito.verify((Object)this.actual)).force(false);
    }

    @Test
    void readWithPosition() throws Exception {
        long position = 500L;
        this.channel.read(this.buf, position);
        ((StoreChannel)Mockito.verify((Object)this.actual)).read(this.buf, position + this.offset);
    }

    @Test
    void position() throws Exception {
        long position = 500L;
        Mockito.when((Object)this.actual.position()).thenReturn((Object)position);
        Assertions.assertEquals((long)(position - this.offset), (long)this.channel.position());
        ((StoreChannel)Mockito.verify((Object)this.actual)).position();
    }

    @Test
    void positionWithPosition() throws Exception {
        long position = 500L;
        this.channel.position(position);
        ((StoreChannel)Mockito.verify((Object)this.actual)).position(500L + this.offset);
    }

    @Test
    void size() throws Exception {
        long size = 256L;
        Mockito.when((Object)this.actual.size()).thenReturn((Object)size);
        Assertions.assertEquals((long)(256L - this.offset), (long)this.channel.size());
        ((StoreChannel)Mockito.verify((Object)this.actual)).size();
    }

    @Test
    void truncate() throws Exception {
        long size = 256L;
        this.channel.truncate(size);
        ((StoreChannel)Mockito.verify((Object)this.actual)).truncate(size + this.offset);
    }

    @Test
    void flush() throws Exception {
        this.channel.flush();
        ((StoreChannel)Mockito.verify((Object)this.actual)).flush();
    }

    @Test
    void writeMultiple() throws Exception {
        this.channel.write(this.buffers);
        ((StoreChannel)Mockito.verify((Object)this.actual)).write(this.buffers);
    }

    @Test
    void writeMultipleExtended() throws Exception {
        int off = 16;
        int len = 32;
        this.channel.write(this.buffers, off, len);
        ((StoreChannel)Mockito.verify((Object)this.actual)).write(this.buffers, off, len);
    }

    @Test
    void readMultiple() throws Exception {
        this.channel.read(this.buffers);
        ((StoreChannel)Mockito.verify((Object)this.actual)).read(this.buffers);
    }

    @Test
    void readMultipleExtended() throws Exception {
        int off = 16;
        int len = 32;
        this.channel.read(this.buffers, off, len);
        ((StoreChannel)Mockito.verify((Object)this.actual)).read(this.buffers, off, len);
    }

    @Test
    void isOpen() {
        this.channel.isOpen();
        ((StoreChannel)Mockito.verify((Object)this.actual)).isOpen();
    }

    @Test
    void close() throws Exception {
        this.channel.close();
        ((StoreChannel)Mockito.verify((Object)this.actual)).close();
    }
}

