/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.randomharness;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.io.pagecache.randomharness.Action;
import org.neo4j.io.pagecache.randomharness.Plan;
import org.neo4j.resources.Profiler;

class PlanRunner
implements Callable<Void> {
    private final Plan plan;
    private final AtomicBoolean stopSignal;
    private final Profiler profiler;

    PlanRunner(Plan plan, AtomicBoolean stopSignal, Profiler profiler) {
        this.plan = plan;
        this.stopSignal = stopSignal;
        this.profiler = profiler;
    }

    @Override
    public Void call() throws Exception {
        try (Profiler.ProfiledInterval profilingRun = this.profiler.profile();){
            Action action = this.plan.next();
            while (action != null && !this.stopSignal.get()) {
                try {
                    action.perform();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                action = this.plan.next();
            }
            Void void_ = null;
            return void_;
        }
    }
}

