/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.DirectoryExtensionLifecycleVerificationTest;
import org.neo4j.test.extension.ExecutionSharedContext;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class})
class TestDirectoryExtensionTest {
    @Inject
    TestDirectory testDirectory;
    @Inject
    DefaultFileSystemAbstraction fileSystem;

    TestDirectoryExtensionTest() {
    }

    @Test
    void testDirectoryInjectionWorks() {
        Assertions.assertNotNull((Object)((Object)this.testDirectory));
    }

    @Test
    void testDirectoryInitialisedForUsage() {
        File directory = this.testDirectory.directory();
        Assertions.assertNotNull((Object)directory);
        Assertions.assertTrue((boolean)directory.exists());
        Path targetTestData = Paths.get("target", "test data");
        Assertions.assertTrue((boolean)directory.getAbsolutePath().contains(targetTestData.toString()));
    }

    @Test
    void testDirectoryUsesFileSystemFromExtension() {
        Assertions.assertSame((Object)this.fileSystem, (Object)this.testDirectory.getFileSystem());
    }

    @Test
    void createTestFile() {
        File file = this.testDirectory.createFile("a");
        Assertions.assertEquals((Object)"a", (Object)file.getName());
        Assertions.assertTrue((boolean)this.fileSystem.fileExists(file));
    }

    @Test
    void failedTestShouldKeepDirectory() {
        ExecutionSharedContext.CONTEXT.clear();
        TestDirectoryExtensionTest.execute("failAndKeepDirectory", new TestExecutionListener[0]);
        File failedFile = (File)ExecutionSharedContext.CONTEXT.getValue("failedFileName");
        Assertions.assertNotNull((Object)failedFile);
        Assertions.assertTrue((boolean)failedFile.exists());
    }

    @Test
    void successfulTestShouldCleanupDirectory() {
        ExecutionSharedContext.CONTEXT.clear();
        TestDirectoryExtensionTest.execute("executeAndCleanupDirectory", new TestExecutionListener[0]);
        File greenTestFail = (File)ExecutionSharedContext.CONTEXT.getValue("successfulFileName");
        Assertions.assertNotNull((Object)greenTestFail);
        Assertions.assertFalse((boolean)greenTestFail.exists());
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void exceptionOnDirectoryDeletionIncludeTestDisplayName() throws IOException {
        ExecutionSharedContext.CONTEXT.clear();
        FailedTestExecutionListener failedTestListener = new FailedTestExecutionListener();
        TestDirectoryExtensionTest.execute("lockFileAndFailToDeleteDirectory", failedTestListener);
        File lockedFile = (File)ExecutionSharedContext.CONTEXT.getValue("lockedFileName");
        Assertions.assertNotNull((Object)lockedFile);
        Assumptions.assumeTrue((boolean)lockedFile.exists());
        Assertions.assertTrue((boolean)lockedFile.setReadable(true, true));
        FileUtils.deleteRecursively((File)lockedFile);
        failedTestListener.assertTestObserver();
    }

    private static void execute(String testName, TestExecutionListener ... testExecutionListeners) {
        LauncherDiscoveryRequest discoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectMethod(DirectoryExtensionLifecycleVerificationTest.class, (String)testName)}).configurationParameter("testToggle", "true").build();
        Launcher launcher = LauncherFactory.create();
        launcher.execute(discoveryRequest, testExecutionListeners);
    }

    private static class FailedTestExecutionListener
    implements TestExecutionListener {
        private int resultsObserved;

        private FailedTestExecutionListener() {
        }

        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
                ++this.resultsObserved;
                String exceptionMessage = testExecutionResult.getThrowable().map(Throwable::getMessage).orElse("");
                MatcherAssert.assertThat((Object)exceptionMessage, (Matcher)Matchers.containsString((String)"Fail to cleanup test directory for lockFileAndFailToDeleteDirectory"));
            }
        }

        void assertTestObserver() {
            Assertions.assertEquals((int)1, (int)this.resultsObserved);
        }
    }
}

