/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class EphemeralPageSwapperFactory
implements PageSwapperFactory,
AutoCloseable {
    private final ConcurrentHashMap<File, EphemeralSwapper> swappers = new ConcurrentHashMap();

    public void open(FileSystemAbstraction fs, Configuration config) {
    }

    public String implementationName() {
        return "ephemeral";
    }

    public long getRequiredBufferAlignment() {
        return 1L;
    }

    public PageSwapper createPageSwapper(File file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist, boolean noChannelStriping) throws IOException {
        EphemeralSwapper swapper = this.swappers.compute(file, (f, existing) -> {
            if (existing != null) {
                ((EphemeralSwapper)existing).onEviction = onEviction;
                ((EphemeralSwapper)existing).closed = false;
                return existing;
            }
            if (createIfNotExist) {
                return new EphemeralSwapper(file, filePageSize, onEviction, this.swappers);
            }
            return null;
        });
        if (swapper == null) {
            throw new NoSuchFileException(file.getAbsolutePath());
        }
        return swapper;
    }

    public void syncDevice() {
    }

    @Override
    public void close() {
        this.swappers.forEachValue(1L, EphemeralSwapper::free);
    }

    private static class EphemeralSwapper
    implements PageSwapper {
        private final ConcurrentHashMap<Long, Long> buffers = new ConcurrentHashMap();
        private final File file;
        private final int filePageSize;
        private final ConcurrentHashMap<File, EphemeralSwapper> swappers;
        private final AtomicLong lastPageId;
        private final Function<Long, Long> allocateBuffer;
        private final Consumer<Long> freeMemory;
        private volatile PageEvictionCallback onEviction;
        private volatile boolean closed;

        private EphemeralSwapper(File file, int filePageSize, PageEvictionCallback onEviction, ConcurrentHashMap<File, EphemeralSwapper> swappers) {
            this.file = file;
            this.filePageSize = filePageSize;
            this.onEviction = onEviction;
            this.swappers = swappers;
            this.lastPageId = new AtomicLong(-1L);
            this.allocateBuffer = fpi -> UnsafeUtil.allocateMemory((long)filePageSize);
            this.freeMemory = addr -> UnsafeUtil.free((long)addr, (long)filePageSize);
        }

        public long read(long filePageId, long bufferAddress, int bufferSize) throws IOException {
            this.assertIO(filePageId);
            Long addr = this.buffers.get(filePageId);
            int read = 0;
            if (addr != null) {
                long ptr = addr;
                UnsafeUtil.copyMemory((long)ptr, (long)bufferAddress, (long)bufferSize);
                read = bufferSize;
            }
            if (read < bufferSize) {
                UnsafeUtil.setMemory((long)(bufferAddress + (long)read), (long)(bufferSize - read), (byte)0);
            }
            return read;
        }

        public long read(long startFilePageId, long[] bufferAddresses, int bufferSize, int arrayOffset, int length) throws IOException {
            long data = 0L;
            for (int i = 0; i < length; ++i) {
                data += this.read(startFilePageId + (long)i, bufferAddresses[arrayOffset + i], bufferSize);
            }
            return data;
        }

        public long write(long filePageId, long bufferAddress) throws IOException {
            long currMax;
            this.assertIO(filePageId);
            while ((currMax = this.lastPageId.get()) < filePageId && !this.lastPageId.compareAndSet(currMax, filePageId)) {
            }
            long addr = this.buffers.computeIfAbsent(filePageId, this.allocateBuffer);
            UnsafeUtil.copyMemory((long)bufferAddress, (long)addr, (long)this.filePageSize);
            return this.filePageSize;
        }

        private void assertIO(long filePageId) throws IOException {
            if (this.closed) {
                throw new ClosedChannelException();
            }
            if (filePageId < 0L) {
                throw new IOException("Negative page id: " + filePageId);
            }
        }

        public long write(long startFilePageId, long[] bufferAddresses, int arrayOffset, int length) throws IOException {
            long data = 0L;
            for (int i = 0; i < length; ++i) {
                data += this.write(startFilePageId + (long)i, bufferAddresses[arrayOffset + i]);
            }
            return data;
        }

        public void evicted(long pageId) {
            if (!this.closed) {
                this.onEviction.onEvict(pageId);
            }
        }

        public File file() {
            return this.file;
        }

        public void close() {
            this.closed = true;
        }

        public void closeAndDelete() throws IOException {
            this.truncate();
            this.close();
            this.swappers.remove(this.file);
        }

        void free() {
            this.buffers.forEachValue(1000L, this.freeMemory);
            this.buffers.clear();
        }

        public void force() throws IOException {
            this.assertIO(0L);
        }

        public long getLastPageId() {
            return this.lastPageId.get();
        }

        public void truncate() throws IOException {
            this.free();
            this.lastPageId.set(-1L);
        }
    }
}

