/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.memory.GlobalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.scheduler.JobScheduler;

public final class StandalonePageCacheFactory {
    private StandalonePageCacheFactory() {
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler) {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory();
        factory.open(fileSystem, Configuration.EMPTY);
        return StandalonePageCacheFactory.createPageCache(factory, jobScheduler);
    }

    public static PageCache createPageCache(PageSwapperFactory factory, JobScheduler jobScheduler) {
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        DefaultPageCursorTracerSupplier cursorTracerSupplier = DefaultPageCursorTracerSupplier.INSTANCE;
        VersionContextSupplier versionContextSupplier = EmptyVersionContextSupplier.EMPTY;
        MemoryAllocator memoryAllocator = MemoryAllocator.createAllocator("8 MiB", (MemoryAllocationTracker)GlobalMemoryTracker.INSTANCE);
        return new MuninnPageCache(factory, memoryAllocator, cacheTracer, (PageCursorTracerSupplier)cursorTracerSupplier, versionContextSupplier, jobScheduler);
    }
}

