/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.neo4j.function.Predicates;
import org.neo4j.io.fs.FileVisitors;

@RunWith(value=MockitoJUnitRunner.class)
public class OnlyMatchingFileVisitorTest {
    @Mock
    public FileVisitor<Path> wrapped;

    @Test
    public void shouldNotDelegatePreVisitDirectoryIfPredicateDoesntMatch() throws IOException {
        FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).preVisitDirectory(null, null);
        ((FileVisitor)Mockito.verify(this.wrapped, (VerificationMode)Mockito.never())).preVisitDirectory(ArgumentMatchers.any(), (BasicFileAttributes)ArgumentMatchers.any());
    }

    @Test
    public void shouldNotDelegatePostVisitDirectoryIfPredicateDoesntMatch() throws IOException {
        FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).postVisitDirectory(null, null);
        ((FileVisitor)Mockito.verify(this.wrapped, (VerificationMode)Mockito.never())).postVisitDirectory(ArgumentMatchers.any(), (IOException)ArgumentMatchers.any());
    }

    @Test
    public void shouldNotDelegateVisitFileIfPredicateDoesntMatch() throws IOException {
        FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).visitFile(null, null);
        ((FileVisitor)Mockito.verify(this.wrapped, (VerificationMode)Mockito.never())).visitFile(ArgumentMatchers.any(), (BasicFileAttributes)ArgumentMatchers.any());
    }

    @Test
    public void shouldNotDelegateVisitFileFailedIfPredicateDoesntMatch() throws IOException {
        FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).visitFileFailed(null, null);
        ((FileVisitor)Mockito.verify(this.wrapped, (VerificationMode)Mockito.never())).visitFileFailed(ArgumentMatchers.any(), (IOException)ArgumentMatchers.any());
    }

    @Test
    public void shouldNotSkipSubtreeFromPreVisitDirectoryIfPredicateDoesntMatch() throws IOException {
        Assert.assertThat((Object)((Object)FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).preVisitDirectory(null, null)), (Matcher)Matchers.is((Object)((Object)FileVisitResult.SKIP_SUBTREE)));
    }

    @Test
    public void shouldContinueAfterPostVisitDirectoryIfPredicateDoesntMatch() throws IOException {
        Assert.assertThat((Object)((Object)FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).postVisitDirectory(null, null)), (Matcher)Matchers.is((Object)((Object)FileVisitResult.CONTINUE)));
    }

    @Test
    public void shouldContinueAfterVisitFileIfPredicateDoesntMatch() throws IOException {
        Assert.assertThat((Object)((Object)FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).visitFile(null, null)), (Matcher)Matchers.is((Object)((Object)FileVisitResult.CONTINUE)));
    }

    @Test
    public void shouldContinueAfterVisitFileFailedIfPredicateDoesntMatch() throws IOException {
        Assert.assertThat((Object)((Object)FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).visitFileFailed(null, null)), (Matcher)Matchers.is((Object)((Object)FileVisitResult.CONTINUE)));
    }
}

