/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.StreamFilesRecursive;
import org.neo4j.io.fs.watcher.DefaultFileSystemWatcher;
import org.neo4j.io.fs.watcher.FileWatcher;

public class DefaultFileSystemAbstraction
implements FileSystemAbstraction {
    static final String UNABLE_TO_CREATE_DIRECTORY_FORMAT = "Unable to write directory path [%s] for Neo4j store.";
    public static final Set<OpenOption> WRITE_OPTIONS = Set.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    private static final Set<OpenOption> READ_OPTIONS = Set.of(StandardOpenOption.READ);
    private static final OpenOption[] APPEND_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    private static final OpenOption[] DEFAULT_OUTPUT_OPTIONS = new OpenOption[0];

    @Override
    public FileWatcher fileWatcher() throws IOException {
        WatchService watchService = FileSystems.getDefault().newWatchService();
        return new DefaultFileSystemWatcher(watchService);
    }

    @Override
    public StoreFileChannel open(File fileName, Set<OpenOption> options) throws IOException {
        FileChannel channel = FileChannel.open(fileName.toPath(), options, new FileAttribute[0]);
        return this.getStoreFileChannel(channel);
    }

    @Override
    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return Files.newOutputStream(fileName.toPath(), append ? APPEND_OPTIONS : DEFAULT_OUTPUT_OPTIONS);
    }

    @Override
    public InputStream openAsInputStream(File fileName) throws IOException {
        return Files.newInputStream(fileName.toPath(), new OpenOption[0]);
    }

    @Override
    public Reader openAsReader(File fileName, Charset charset) throws IOException {
        return new InputStreamReader(this.openAsInputStream(fileName), charset);
    }

    @Override
    public Writer openAsWriter(File fileName, Charset charset, boolean append) throws IOException {
        return new OutputStreamWriter(this.openAsOutputStream(fileName, append), charset);
    }

    @Override
    public StoreFileChannel write(File fileName) throws IOException {
        return this.open(fileName, (Set)WRITE_OPTIONS);
    }

    @Override
    public StoreFileChannel read(File fileName) throws IOException {
        return this.open(fileName, (Set)READ_OPTIONS);
    }

    @Override
    public boolean mkdir(File fileName) {
        return fileName.mkdir();
    }

    @Override
    public void mkdirs(File file) throws IOException {
        if (file.exists() && file.isDirectory()) {
            return;
        }
        try {
            Files.createDirectories(file.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IOException(String.format(UNABLE_TO_CREATE_DIRECTORY_FORMAT, file), e);
        }
    }

    @Override
    public boolean fileExists(File file) {
        return file.exists();
    }

    @Override
    public long getFileSize(File file) {
        return file.length();
    }

    @Override
    public long getBlockSize(File file) throws IOException {
        return FileUtils.blockSize(file);
    }

    @Override
    public boolean deleteFile(File fileName) {
        return FileUtils.deleteFile(fileName);
    }

    @Override
    public void deleteRecursively(File directory) throws IOException {
        FileUtils.deleteRecursively(directory);
    }

    @Override
    public void renameFile(File from, File to, CopyOption ... copyOptions) throws IOException {
        Files.move(from.toPath(), to.toPath(), copyOptions);
    }

    @Override
    public File[] listFiles(File directory) {
        return directory.listFiles();
    }

    @Override
    public File[] listFiles(File directory, FilenameFilter filter) {
        return directory.listFiles(filter);
    }

    @Override
    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    @Override
    public void moveToDirectory(File file, File toDirectory) throws IOException {
        FileUtils.moveFileToDirectory(file, toDirectory);
    }

    @Override
    public void copyToDirectory(File file, File toDirectory) throws IOException {
        FileUtils.copyFileToDirectory(file, toDirectory);
    }

    @Override
    public void copyFile(File from, File to) throws IOException {
        FileUtils.copyFile(from, to);
    }

    @Override
    public void copyFile(File from, File to, CopyOption ... copyOptions) throws IOException {
        FileUtils.copyFile(from, to, copyOptions);
    }

    @Override
    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        FileUtils.copyRecursively(fromDirectory, toDirectory);
    }

    @Override
    public void truncate(File path, long size) throws IOException {
        FileUtils.truncateFile(path, size);
    }

    @Override
    public long lastModifiedTime(File file) {
        return file.lastModified();
    }

    @Override
    public void deleteFileOrThrow(File file) throws IOException {
        Files.delete(file.toPath());
    }

    @Override
    public Stream<FileHandle> streamFilesRecursive(File directory) throws IOException {
        return StreamFilesRecursive.streamFilesRecursive(directory, this);
    }

    @Override
    public int getFileDescriptor(StoreChannel channel) {
        return channel.getFileDescriptor();
    }

    protected StoreFileChannel getStoreFileChannel(FileChannel channel) {
        return new StoreFileChannel(channel);
    }

    @Override
    public void close() throws IOException {
    }
}

