/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import com.sun.nio.file.ExtendedOpenOption;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.internal.nativeimpl.NativeCallResult;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.FileLockException;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.util.FeatureToggles;

public class SingleFilePageSwapper
implements PageSwapper {
    private static final boolean PREALLOCATE_MAPPED_FILES = FeatureToggles.flag(SingleFilePageSwapper.class, (String)"PREALLOCATE_MAPPED_FILES", (boolean)true);
    private static final long FILE_SIZE_OFFSET = UnsafeUtil.getFieldOffset(SingleFilePageSwapper.class, (String)"fileSize");
    private static final ThreadLocal<ByteBuffer> PROXY_CACHE = new ThreadLocal();
    private final FileSystemAbstraction fs;
    private final File file;
    private final int filePageSize;
    private final Set<OpenOption> openOptions;
    private volatile PageEvictionCallback onEviction;
    private StoreChannel channel;
    private FileLock fileLock;
    private final boolean hasPositionLock;
    private boolean closed;
    private volatile long fileSize;

    private static ByteBuffer proxy(long buffer, int bufferLength) throws IOException {
        ByteBuffer buf = PROXY_CACHE.get();
        if (buf != null) {
            UnsafeUtil.initDirectByteBuffer((ByteBuffer)buf, (long)buffer, (int)bufferLength);
            return buf;
        }
        return SingleFilePageSwapper.createAndGetNewBuffer(buffer, bufferLength);
    }

    private static ByteBuffer createAndGetNewBuffer(long buffer, int bufferLength) throws IOException {
        ByteBuffer buf;
        try {
            buf = UnsafeUtil.newDirectByteBuffer((long)buffer, (int)bufferLength);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        PROXY_CACHE.set(buf);
        return buf;
    }

    SingleFilePageSwapper(File file, FileSystemAbstraction fs, int filePageSize, PageEvictionCallback onEviction, boolean useDirectIO) throws IOException {
        this.fs = fs;
        this.file = file;
        ArrayList<OpenOption> options = new ArrayList<OpenOption>(DefaultFileSystemAbstraction.WRITE_OPTIONS);
        if (useDirectIO) {
            this.validateDirectIOPossibility(file, filePageSize);
            options.add(ExtendedOpenOption.DIRECT);
        }
        this.openOptions = Set.copyOf(options);
        this.channel = this.createStoreChannel();
        this.filePageSize = filePageSize;
        this.onEviction = onEviction;
        this.increaseFileSizeTo(this.channel.size());
        try {
            this.acquireLock();
        }
        catch (IOException e) {
            try {
                this.channel.close();
            }
            catch (IOException ioe) {
                e.addSuppressed(ioe);
            }
            throw e;
        }
        this.hasPositionLock = this.channel.hasPositionLock();
    }

    private StoreChannel createStoreChannel() throws IOException {
        StoreChannel storeChannel = this.fs.open(this.file, this.openOptions);
        storeChannel.tryMakeUninterruptible();
        return storeChannel;
    }

    private void validateDirectIOPossibility(File file, int filePageSize) throws IOException {
        if (!SystemUtils.IS_OS_LINUX) {
            throw new IllegalArgumentException("DirectIO support is available only on Linux.");
        }
        long blockSize = this.fs.getBlockSize(file);
        long value = (long)filePageSize / blockSize;
        if (value * blockSize != (long)filePageSize) {
            throw new IllegalArgumentException("Direct IO can be used only when page cache page size is a multiplier of a block size. File page size: " + filePageSize + ", block size: " + blockSize);
        }
    }

    private void increaseFileSizeTo(long newFileSize) {
        long currentFileSize;
        while ((currentFileSize = this.getCurrentFileSize()) < newFileSize && !UnsafeUtil.compareAndSwapLong((Object)this, (long)FILE_SIZE_OFFSET, (long)currentFileSize, (long)newFileSize)) {
        }
    }

    private long getCurrentFileSize() {
        return UnsafeUtil.getLongVolatile((Object)this, (long)FILE_SIZE_OFFSET);
    }

    private void setCurrentFileSize(long size) {
        UnsafeUtil.putLongVolatile((Object)this, (long)FILE_SIZE_OFFSET, (long)size);
    }

    private void acquireLock() throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        try {
            this.fileLock = this.channel.tryLock();
            if (this.fileLock == null) {
                throw new FileLockException(this.file);
            }
        }
        catch (OverlappingFileLockException e) {
            throw new FileLockException(this.file, e);
        }
    }

    private int swapIn(long bufferAddress, long fileOffset) throws IOException {
        int readTotal = 0;
        try {
            int read;
            ByteBuffer bufferProxy = SingleFilePageSwapper.proxy(bufferAddress, this.filePageSize);
            while ((read = this.channel.read(bufferProxy, fileOffset + (long)readTotal)) != -1 && (readTotal += read) < this.filePageSize) {
            }
            int rest = this.filePageSize - readTotal;
            if (rest > 0) {
                UnsafeUtil.setMemory((long)(bufferAddress + (long)readTotal), (long)rest, (byte)MuninnPageCache.ZERO_BYTE);
            }
            return readTotal;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(SingleFilePageSwapper.formatSwapInErrorMessage(fileOffset, this.filePageSize, readTotal), e);
        }
    }

    private static String formatSwapInErrorMessage(long fileOffset, int filePageSize, int readTotal) {
        return "Read failed after " + readTotal + " of " + filePageSize + " bytes from fileOffset " + fileOffset + ".";
    }

    private int swapOut(long bufferAddress, long fileOffset) throws IOException {
        try {
            ByteBuffer bufferProxy = SingleFilePageSwapper.proxy(bufferAddress, this.filePageSize);
            this.channel.writeAll(bufferProxy, fileOffset);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
        return this.filePageSize;
    }

    private void clear(long bufferAddress, int bufferSize) {
        UnsafeUtil.setMemory((long)bufferAddress, (long)bufferSize, (byte)MuninnPageCache.ZERO_BYTE);
    }

    @Override
    public long read(long filePageId, long bufferAddress) throws IOException {
        block10: {
            Retry retry = new Retry();
            while (true) {
                try {
                    long fileOffset = this.pageIdToPosition(filePageId);
                    if (fileOffset < this.getCurrentFileSize()) {
                        long l = this.swapIn(bufferAddress, fileOffset);
                        return l;
                    }
                    this.clear(bufferAddress, this.filePageSize);
                    long l = 0L;
                    return l;
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                    if (retry.shouldRetry()) continue;
                    break block10;
                }
                break;
            }
            finally {
                retry.close();
            }
        }
        return -1L;
    }

    @Override
    public long read(long startFilePageId, long[] bufferAddresses, int arrayOffset, int length) throws IOException {
        block11: {
            if (length == 0) {
                return 0L;
            }
            Retry retry = new Retry();
            while (true) {
                try {
                    if (this.hasPositionLock) {
                        long l = this.readPositionedVectoredToFileChannel(startFilePageId, bufferAddresses, arrayOffset, length);
                        return l;
                    }
                    long l = this.readPositionedVectoredFallback(startFilePageId, bufferAddresses, arrayOffset, length);
                    return l;
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                    if (retry.shouldRetry()) continue;
                    break block11;
                }
                break;
            }
            finally {
                retry.close();
            }
        }
        return -1L;
    }

    private long readPositionedVectoredToFileChannel(long startFilePageId, long[] bufferAddresses, int arrayOffset, int length) throws IOException {
        ByteBuffer[] srcs;
        long fileOffset = this.pageIdToPosition(startFilePageId);
        long bytesRead = this.lockPositionReadVector(fileOffset, srcs = this.convertToByteBuffers(bufferAddresses, arrayOffset, length));
        if (bytesRead == -1L) {
            for (long address : bufferAddresses) {
                UnsafeUtil.setMemory((long)address, (long)this.filePageSize, (byte)MuninnPageCache.ZERO_BYTE);
            }
            return 0L;
        }
        if (bytesRead < (long)this.filePageSize * (long)length) {
            int pagesRead = (int)(bytesRead / (long)this.filePageSize);
            int bytesReadIntoLastReadPage = (int)(bytesRead % (long)this.filePageSize);
            int pagesNeedingZeroing = length - pagesRead;
            for (int i = 0; i < pagesNeedingZeroing; ++i) {
                long address = bufferAddresses[arrayOffset + pagesRead + i];
                long bytesToZero = this.filePageSize;
                if (i == 0) {
                    address += (long)bytesReadIntoLastReadPage;
                    bytesToZero -= (long)bytesReadIntoLastReadPage;
                }
                UnsafeUtil.setMemory((long)address, (long)bytesToZero, (byte)MuninnPageCache.ZERO_BYTE);
            }
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lockPositionReadVector(long fileOffset, ByteBuffer[] srcs) throws IOException {
        long toRead = (long)this.filePageSize * (long)srcs.length;
        long readTotal = 0L;
        Object object = this.channel.getPositionLock();
        synchronized (object) {
            long read;
            this.setPositionUnderLock(fileOffset);
            while ((read = this.channel.read(srcs)) != -1L && (readTotal += read) < toRead) {
            }
            return readTotal;
        }
    }

    private int readPositionedVectoredFallback(long startFilePageId, long[] bufferAddresses, int arrayOffset, int length) throws IOException {
        int bytes = 0;
        for (int i = 0; i < length; ++i) {
            long address = bufferAddresses[arrayOffset + i];
            bytes = (int)((long)bytes + this.read(startFilePageId + (long)i, address));
        }
        return bytes;
    }

    @Override
    public long write(long filePageId, long bufferAddress) throws IOException {
        block8: {
            long fileOffset = this.pageIdToPosition(filePageId);
            this.increaseFileSizeTo(fileOffset + (long)this.filePageSize);
            Retry retry = new Retry();
            while (true) {
                try {
                    long l = this.swapOut(bufferAddress, fileOffset);
                    return l;
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                    if (retry.shouldRetry()) continue;
                    break block8;
                }
                break;
            }
            finally {
                retry.close();
            }
        }
        return -1L;
    }

    @Override
    public long write(long startFilePageId, long[] bufferAddresses, int arrayOffset, int length) throws IOException {
        block11: {
            if (length == 0) {
                return 0L;
            }
            Retry retry = new Retry();
            while (true) {
                try {
                    if (this.hasPositionLock) {
                        long l = this.writePositionedVectoredToFileChannel(startFilePageId, bufferAddresses, arrayOffset, length);
                        return l;
                    }
                    long l = this.writePositionVectoredFallback(startFilePageId, bufferAddresses, arrayOffset, length);
                    return l;
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                    if (retry.shouldRetry()) continue;
                    break block11;
                }
                break;
            }
            finally {
                retry.close();
            }
        }
        return -1L;
    }

    private long writePositionedVectoredToFileChannel(long startFilePageId, long[] bufferAddresses, int arrayOffset, int length) throws IOException {
        long fileOffset = this.pageIdToPosition(startFilePageId);
        this.increaseFileSizeTo(fileOffset + (long)this.filePageSize * (long)length);
        ByteBuffer[] srcs = this.convertToByteBuffers(bufferAddresses, arrayOffset, length);
        return this.lockPositionWriteVector(fileOffset, srcs);
    }

    private ByteBuffer[] convertToByteBuffers(long[] bufferAddresses, int arrayOffset, int length) {
        ByteBuffer[] buffers = new ByteBuffer[length];
        for (int i = 0; i < length; ++i) {
            long address = bufferAddresses[arrayOffset + i];
            try {
                buffers[i] = UnsafeUtil.newDirectByteBuffer((long)address, (int)this.filePageSize);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to wrap pointer in ByteBuffer.", e);
            }
        }
        return buffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lockPositionWriteVector(long fileOffset, ByteBuffer[] srcs) throws IOException {
        try {
            long toWrite = (long)this.filePageSize * (long)srcs.length;
            long bytesWritten = 0L;
            Object object = this.channel.getPositionLock();
            synchronized (object) {
                this.setPositionUnderLock(fileOffset);
                while ((bytesWritten += this.channel.write(srcs)) < toWrite) {
                }
                return bytesWritten;
            }
        }
        catch (ClosedChannelException e) {
            this.tryReopen(e);
            throw new IOException("IO failed due to interruption", e);
        }
    }

    private void setPositionUnderLock(long fileOffset) throws IOException {
        try {
            this.channel.position(fileOffset);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    private int writePositionVectoredFallback(long startFilePageId, long[] bufferAddresses, int arrayOffset, int length) throws IOException {
        int bytes = 0;
        for (int i = 0; i < length; ++i) {
            long address = bufferAddresses[arrayOffset + i];
            bytes = (int)((long)bytes + this.write(startFilePageId + (long)i, address));
        }
        return bytes;
    }

    @Override
    public void evicted(long filePageId) {
        PageEvictionCallback callback = this.onEviction;
        if (callback != null) {
            callback.onEvict(filePageId);
        }
    }

    @Override
    public File file() {
        return this.file;
    }

    private long pageIdToPosition(long pageId) {
        return (long)this.filePageSize * pageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleFilePageSwapper that = (SingleFilePageSwapper)o;
        return this.file.equals(that.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    private synchronized void tryReopen(ClosedChannelException closedException) throws ClosedChannelException {
        if (this.channel.isOpen()) {
            return;
        }
        if (this.closed) {
            throw closedException;
        }
        try {
            this.channel = this.createStoreChannel();
            this.acquireLock();
        }
        catch (IOException e) {
            closedException.addSuppressed(e);
            throw closedException;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        try {
            this.channel.close();
        }
        finally {
            this.onEviction = null;
        }
    }

    @Override
    public synchronized void closeAndDelete() throws IOException {
        this.close();
        this.fs.deleteFile(this.file);
    }

    @Override
    public void force() throws IOException {
        try (Retry retry = new Retry();){
            do {
                try {
                    this.channel.force(false);
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                }
            } while (retry.shouldRetry());
        }
    }

    @Override
    public long getLastPageId() {
        long channelSize = this.getCurrentFileSize();
        if (channelSize == 0L) {
            return -1L;
        }
        long div = channelSize / (long)this.filePageSize;
        long mod = channelSize % (long)this.filePageSize;
        return mod == 0L ? div - 1L : div;
    }

    @Override
    public void truncate() throws IOException {
        this.setCurrentFileSize(0L);
        try (Retry retry = new Retry();){
            do {
                try {
                    this.channel.truncate(0L);
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                }
            } while (retry.shouldRetry());
        }
    }

    @Override
    public boolean canAllocate() {
        return PREALLOCATE_MAPPED_FILES && NativeAccessProvider.getNativeAccess().isAvailable() && this.channel.getFileDescriptor() != -1;
    }

    @Override
    public void allocate(long newFileSize) throws IOException {
        NativeCallResult result;
        NativeAccess access = NativeAccessProvider.getNativeAccess();
        if (access.isAvailable() && (result = access.tryPreallocateSpace(this.channel.getFileDescriptor(), newFileSize)).isError()) {
            throw new IOException(result.getErrorMessage());
        }
    }

    public String toString() {
        return "SingleFilePageSwapper{filePageSize=" + this.filePageSize + ", file=" + this.file + "}";
    }

    private class Retry
    implements AutoCloseable {
        private static final int RETRIES_ON_INTERRUPTION = 10;
        private int retries = 10;
        private ClosedChannelException caughtException;
        private ClosedChannelException initialException;
        private boolean wasInterrupted;

        private Retry() {
        }

        boolean shouldRetry() throws ClosedChannelException {
            if (this.caughtException != null && --this.retries >= 0) {
                this.wasInterrupted |= Thread.interrupted();
                SingleFilePageSwapper.this.tryReopen(this.caughtException);
                this.caughtException = null;
                return true;
            }
            return false;
        }

        void caught(ClosedChannelException exception) {
            this.caughtException = exception;
            if (this.initialException == null) {
                this.initialException = this.caughtException;
            }
        }

        @Override
        public void close() throws ClosedChannelException {
            if (this.wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            if (this.caughtException != null) {
                this.initialException.addSuppressed(this.caughtException);
                throw this.initialException;
            }
        }
    }
}

