/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import com.sun.nio.file.ExtendedOpenOption;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.internal.nativeimpl.NativeCallResult;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.FileLockException;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.util.FeatureToggles;

public class SingleFilePageSwapper
implements PageSwapper {
    private static final boolean PREALLOCATE_MAPPED_FILES = FeatureToggles.flag(SingleFilePageSwapper.class, (String)"PREALLOCATE_MAPPED_FILES", (boolean)true);
    private static final long FILE_SIZE_OFFSET = UnsafeUtil.getFieldOffset(SingleFilePageSwapper.class, (String)"fileSize");
    private static final ThreadLocal<ByteBuffer> PROXY_CACHE = new ThreadLocal();
    private final FileSystemAbstraction fs;
    private final Path path;
    private final int filePageSize;
    private final Set<OpenOption> openOptions;
    private volatile PageEvictionCallback onEviction;
    private StoreChannel channel;
    private FileLock fileLock;
    private final boolean hasPositionLock;
    private boolean closed;
    private volatile long fileSize;

    private static ByteBuffer proxy(long buffer, int bufferLength) throws IOException {
        ByteBuffer buf = PROXY_CACHE.get();
        if (buf != null) {
            UnsafeUtil.initDirectByteBuffer((ByteBuffer)buf, (long)buffer, (int)bufferLength);
            return buf;
        }
        return SingleFilePageSwapper.createAndGetNewBuffer(buffer, bufferLength);
    }

    private static ByteBuffer createAndGetNewBuffer(long buffer, int bufferLength) throws IOException {
        ByteBuffer buf;
        try {
            buf = UnsafeUtil.newDirectByteBuffer((long)buffer, (int)bufferLength);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        PROXY_CACHE.set(buf);
        return buf;
    }

    SingleFilePageSwapper(Path path, FileSystemAbstraction fs, int filePageSize, PageEvictionCallback onEviction, boolean useDirectIO) throws IOException {
        this.fs = fs;
        this.path = path;
        ArrayList<OpenOption> options = new ArrayList<OpenOption>(DefaultFileSystemAbstraction.WRITE_OPTIONS);
        if (useDirectIO) {
            this.validateDirectIOPossibility(path, filePageSize);
            options.add(ExtendedOpenOption.DIRECT);
        }
        this.openOptions = Set.copyOf(options);
        this.channel = this.createStoreChannel();
        this.filePageSize = filePageSize;
        this.onEviction = onEviction;
        this.increaseFileSizeTo(this.channel.size());
        try {
            this.acquireLock();
        }
        catch (IOException e) {
            try {
                this.channel.close();
            }
            catch (IOException ioe) {
                e.addSuppressed(ioe);
            }
            throw e;
        }
        this.hasPositionLock = this.channel.hasPositionLock();
    }

    private StoreChannel createStoreChannel() throws IOException {
        StoreChannel storeChannel = this.fs.open(this.path, this.openOptions);
        storeChannel.tryMakeUninterruptible();
        return storeChannel;
    }

    private void validateDirectIOPossibility(Path file, int filePageSize) throws IOException {
        if (!SystemUtils.IS_OS_LINUX) {
            throw new IllegalArgumentException("DirectIO support is available only on Linux.");
        }
        long blockSize = this.fs.getBlockSize(file);
        long value = (long)filePageSize / blockSize;
        if (value * blockSize != (long)filePageSize) {
            throw new IllegalArgumentException("Direct IO can be used only when page cache page size is a multiplier of a block size. File page size: " + filePageSize + ", block size: " + blockSize);
        }
    }

    private void increaseFileSizeTo(long newFileSize) {
        long currentFileSize;
        while ((currentFileSize = this.getCurrentFileSize()) < newFileSize && !UnsafeUtil.compareAndSwapLong((Object)this, (long)FILE_SIZE_OFFSET, (long)currentFileSize, (long)newFileSize)) {
        }
    }

    private long getCurrentFileSize() {
        return UnsafeUtil.getLongVolatile((Object)this, (long)FILE_SIZE_OFFSET);
    }

    private void setCurrentFileSize(long size) {
        UnsafeUtil.putLongVolatile((Object)this, (long)FILE_SIZE_OFFSET, (long)size);
    }

    private void acquireLock() throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        try {
            this.fileLock = this.channel.tryLock();
            if (this.fileLock == null) {
                throw new FileLockException(this.path);
            }
        }
        catch (OverlappingFileLockException e) {
            throw new FileLockException(this.path, e);
        }
    }

    private int swapIn(long bufferAddress, long fileOffset, int bufferSize) throws IOException {
        int readTotal = 0;
        try {
            int read;
            ByteBuffer bufferProxy = SingleFilePageSwapper.proxy(bufferAddress, bufferSize);
            while ((read = this.channel.read(bufferProxy, fileOffset + (long)readTotal)) != -1 && (readTotal += read) < bufferSize) {
            }
            int rest = bufferSize - readTotal;
            if (rest > 0) {
                UnsafeUtil.setMemory((long)(bufferAddress + (long)readTotal), (long)rest, (byte)MuninnPageCache.ZERO_BYTE);
            }
            return readTotal;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(SingleFilePageSwapper.formatSwapInErrorMessage(fileOffset, bufferSize, readTotal), e);
        }
    }

    private static String formatSwapInErrorMessage(long fileOffset, int size, int readTotal) {
        return "Read failed after " + readTotal + " of " + size + " bytes from fileOffset " + fileOffset + ".";
    }

    private int swapOut(long bufferAddress, long fileOffset, int bufferLength) throws IOException {
        try {
            ByteBuffer bufferProxy = SingleFilePageSwapper.proxy(bufferAddress, bufferLength);
            this.channel.writeAll(bufferProxy, fileOffset);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
        return bufferLength;
    }

    private void clear(long bufferAddress, int bufferSize) {
        UnsafeUtil.setMemory((long)bufferAddress, (long)bufferSize, (byte)MuninnPageCache.ZERO_BYTE);
    }

    @Override
    public long read(long filePageId, long bufferAddress) throws IOException {
        return this.read(filePageId, bufferAddress, this.filePageSize);
    }

    @Override
    public long read(long filePageId, long bufferAddress, int bufferLength) throws IOException {
        block10: {
            Retry retry = new Retry();
            while (true) {
                try {
                    long fileOffset = this.pageIdToPosition(filePageId);
                    if (fileOffset < this.getCurrentFileSize()) {
                        long l = this.swapIn(bufferAddress, fileOffset, bufferLength);
                        return l;
                    }
                    this.clear(bufferAddress, bufferLength);
                    long l = 0L;
                    return l;
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                    if (retry.shouldRetry()) continue;
                    break block10;
                }
                break;
            }
            finally {
                retry.close();
            }
        }
        return -1L;
    }

    @Override
    public long read(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length) throws IOException {
        block11: {
            if (length == 0) {
                return 0L;
            }
            Retry retry = new Retry();
            while (true) {
                try {
                    if (this.hasPositionLock) {
                        long l = this.readPositionedVectoredToFileChannel(startFilePageId, bufferAddresses, bufferLengths, length);
                        return l;
                    }
                    long l = this.readPositionedVectoredFallback(startFilePageId, bufferAddresses, bufferLengths, length);
                    return l;
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                    if (retry.shouldRetry()) continue;
                    break block11;
                }
                break;
            }
            finally {
                retry.close();
            }
        }
        return -1L;
    }

    private long readPositionedVectoredToFileChannel(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length) throws IOException {
        long fileOffset = this.pageIdToPosition(startFilePageId);
        long bytesToRead = this.countBuffersLengths(bufferLengths, length);
        ByteBuffer[] srcs = this.convertToByteBuffers(bufferAddresses, bufferLengths, length);
        long bytesRead = this.lockPositionReadVector(fileOffset, srcs, bytesToRead);
        if (bytesRead == -1L) {
            for (int i = 0; i < length; ++i) {
                UnsafeUtil.setMemory((long)bufferAddresses[i], (long)bufferLengths[i], (byte)MuninnPageCache.ZERO_BYTE);
            }
            return 0L;
        }
        if (bytesRead < bytesToRead) {
            long bytesToKeep = bytesRead;
            for (int bufferIndex = 0; bufferIndex < length; ++bufferIndex) {
                int bufferLength = bufferLengths[bufferIndex];
                if (bytesToKeep > (long)bufferLength) {
                    bytesToKeep = Math.subtractExact(bytesToKeep, (long)bufferLength);
                    continue;
                }
                UnsafeUtil.setMemory((long)(bufferAddresses[bufferIndex] + bytesToKeep), (long)((long)bufferLength - bytesToKeep), (byte)MuninnPageCache.ZERO_BYTE);
                bytesToKeep = 0L;
            }
        }
        return bytesRead;
    }

    private long countBuffersLengths(int[] bufferLengths, int length) {
        long bytesToRead = 0L;
        for (int i = 0; i < length; ++i) {
            bytesToRead += (long)bufferLengths[i];
        }
        return bytesToRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lockPositionReadVector(long fileOffset, ByteBuffer[] srcs, long bytesToRead) throws IOException {
        long readTotal = 0L;
        Object object = this.channel.getPositionLock();
        synchronized (object) {
            long read;
            this.setPositionUnderLock(fileOffset);
            while ((read = this.channel.read(srcs)) != -1L && (readTotal += read) < bytesToRead) {
            }
            return readTotal;
        }
    }

    private int readPositionedVectoredFallback(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length) throws IOException {
        int bytes = 0;
        long filePageId = startFilePageId;
        for (int i = 0; i < length; ++i) {
            long address = bufferAddresses[i];
            int bufferLength = bufferLengths[i];
            bytes = (int)((long)bytes + this.read(filePageId, address, bufferLength));
            filePageId += (long)(bufferLength / this.filePageSize);
        }
        return bytes;
    }

    @Override
    public long write(long filePageId, long bufferAddress) throws IOException {
        return this.write(filePageId, bufferAddress, this.filePageSize);
    }

    @Override
    public long write(long filePageId, long bufferAddress, int bufferLength) throws IOException {
        block8: {
            long fileOffset = this.pageIdToPosition(filePageId);
            this.increaseFileSizeTo(fileOffset + (long)bufferLength);
            Retry retry = new Retry();
            while (true) {
                try {
                    long l = this.swapOut(bufferAddress, fileOffset, bufferLength);
                    return l;
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                    if (retry.shouldRetry()) continue;
                    break block8;
                }
                break;
            }
            finally {
                retry.close();
            }
        }
        return -1L;
    }

    @Override
    public long write(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length, int totalAffectedPages) throws IOException {
        block11: {
            if (totalAffectedPages == 0) {
                return 0L;
            }
            Retry retry = new Retry();
            while (true) {
                try {
                    if (this.hasPositionLock) {
                        long l = this.writePositionedVectoredToFileChannel(startFilePageId, bufferAddresses, bufferLengths, length);
                        return l;
                    }
                    long l = this.writePositionVectoredFallback(startFilePageId, bufferAddresses, bufferLengths, length);
                    return l;
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                    if (retry.shouldRetry()) continue;
                    break block11;
                }
                break;
            }
            finally {
                retry.close();
            }
        }
        return -1L;
    }

    private long writePositionedVectoredToFileChannel(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length) throws IOException {
        long fileOffset = this.pageIdToPosition(startFilePageId);
        long bytesToWrite = this.countBuffersLengths(bufferLengths, length);
        this.increaseFileSizeTo(fileOffset + bytesToWrite);
        ByteBuffer[] srcs = this.convertToByteBuffers(bufferAddresses, bufferLengths, length);
        return this.lockPositionWriteVector(fileOffset, srcs, bytesToWrite);
    }

    private ByteBuffer[] convertToByteBuffers(long[] bufferAddresses, int[] bufferLengths, int length) {
        ByteBuffer[] buffers = new ByteBuffer[length];
        for (int i = 0; i < length; ++i) {
            try {
                buffers[i] = UnsafeUtil.newDirectByteBuffer((long)bufferAddresses[i], (int)bufferLengths[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to wrap pointer in ByteBuffer.", e);
            }
        }
        return buffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lockPositionWriteVector(long fileOffset, ByteBuffer[] srcs, long bytesToWrite) throws IOException {
        try {
            long bytesWritten = 0L;
            Object object = this.channel.getPositionLock();
            synchronized (object) {
                this.setPositionUnderLock(fileOffset);
                while ((bytesWritten += this.channel.write(srcs)) < bytesToWrite) {
                }
                return bytesWritten;
            }
        }
        catch (ClosedChannelException e) {
            this.tryReopen(e);
            throw new IOException("IO failed due to interruption", e);
        }
    }

    private void setPositionUnderLock(long fileOffset) throws IOException {
        try {
            this.channel.position(fileOffset);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    private int writePositionVectoredFallback(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length) throws IOException {
        int bytes = 0;
        long filePageId = startFilePageId;
        for (int i = 0; i < length; ++i) {
            long address = bufferAddresses[i];
            int bufferLength = bufferLengths[i];
            bytes = (int)((long)bytes + this.write(filePageId, address, bufferLength));
            filePageId += (long)(bufferLength / this.filePageSize);
        }
        return bytes;
    }

    @Override
    public void evicted(long filePageId) {
        PageEvictionCallback callback = this.onEviction;
        if (callback != null) {
            callback.onEvict(filePageId);
        }
    }

    @Override
    public Path path() {
        return this.path;
    }

    private long pageIdToPosition(long pageId) {
        return (long)this.filePageSize * pageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleFilePageSwapper that = (SingleFilePageSwapper)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private synchronized void tryReopen(ClosedChannelException closedException) throws ClosedChannelException {
        if (this.channel.isOpen()) {
            return;
        }
        if (this.closed) {
            throw closedException;
        }
        try {
            this.channel = this.createStoreChannel();
            this.acquireLock();
        }
        catch (IOException e) {
            closedException.addSuppressed(e);
            throw closedException;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        try {
            this.channel.close();
        }
        finally {
            this.onEviction = null;
        }
    }

    @Override
    public synchronized void closeAndDelete() throws IOException {
        this.close();
        this.fs.deleteFile(this.path);
    }

    @Override
    public void force() throws IOException {
        try (Retry retry = new Retry();){
            do {
                try {
                    this.channel.force(false);
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                }
            } while (retry.shouldRetry());
        }
    }

    @Override
    public long getLastPageId() {
        long channelSize = this.getCurrentFileSize();
        if (channelSize == 0L) {
            return -1L;
        }
        long div = channelSize / (long)this.filePageSize;
        long mod = channelSize % (long)this.filePageSize;
        return mod == 0L ? div - 1L : div;
    }

    @Override
    public void truncate() throws IOException {
        this.setCurrentFileSize(0L);
        try (Retry retry = new Retry();){
            do {
                try {
                    this.channel.truncate(0L);
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                }
            } while (retry.shouldRetry());
        }
    }

    @Override
    public boolean canAllocate() {
        return PREALLOCATE_MAPPED_FILES && NativeAccessProvider.getNativeAccess().isAvailable();
    }

    @Override
    public void allocate(long newFileSize) throws IOException {
        NativeCallResult result;
        NativeAccess access = NativeAccessProvider.getNativeAccess();
        if (access.isAvailable() && (result = access.tryPreallocateSpace(this.channel.getFileDescriptor(), newFileSize)).isError()) {
            throw new IOException(result.getErrorMessage());
        }
    }

    public String toString() {
        return "SingleFilePageSwapper{filePageSize=" + this.filePageSize + ", file=" + this.path + "}";
    }

    private class Retry
    implements AutoCloseable {
        private static final int RETRIES_ON_INTERRUPTION = 10;
        private int retries = 10;
        private ClosedChannelException caughtException;
        private ClosedChannelException initialException;
        private boolean wasInterrupted;

        private Retry() {
        }

        boolean shouldRetry() throws ClosedChannelException {
            if (this.caughtException != null && --this.retries >= 0) {
                this.wasInterrupted |= Thread.interrupted();
                SingleFilePageSwapper.this.tryReopen(this.caughtException);
                this.caughtException = null;
                return true;
            }
            return false;
        }

        void caught(ClosedChannelException exception) {
            this.caughtException = exception;
            if (this.initialException == null) {
                this.initialException = this.caughtException;
            }
        }

        @Override
        public void close() throws ClosedChannelException {
            if (this.wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            if (this.caughtException != null) {
                this.initialException.addSuppressed(this.caughtException);
                throw this.initialException;
            }
        }
    }
}

